/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.name:configserver", "spring.cloud.config.server.svn.uri:file:///./target/repos/svn-config-repo", "logging.level.org.springframework.cloud=DEBUG"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"subversion"})
public class SubversionConfigServerIntegrationTests {
    @LocalServerPort
    private int port;
    @Autowired
    private ApplicationContext context;

    @BeforeAll
    public static void init() throws Exception {
        ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/repos/svn-config-repo");
    }

    @Test
    public void contextLoads() {
        ResponseEntity exchange = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Environment environment = (Environment)exchange.getBody();
        Assertions.assertThat((List)environment.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("overrides");
        ConfigServerTestUtils.assertConfigEnabled(environment);
    }

    @Test
    public void defaultLabel() throws Exception {
        SvnKitEnvironmentRepository repository = (SvnKitEnvironmentRepository)this.context.getBean(SvnKitEnvironmentRepository.class);
        Assertions.assertThat((String)repository.getDefaultLabel()).isEqualTo("trunk");
    }

    @Test
    public void updateUnavailableRepo() throws IOException {
        this.contextLoads();
        ConfigServerTestUtils.deleteLocalRepo("svn-config-repo");
        Assertions.assertThat((File)new File("target/repos/", "svn-config-repo")).doesNotExist();
        this.contextLoads();
    }
}

