/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.util.MultiValueMap;

@SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.name:configserver", "spring.cloud.config.server.git.uri:file:./target/repos/config-repo"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
public class VanillaConfigServerIntegrationTests {
    @LocalServerPort
    private int port;

    @BeforeAll
    public static void init() throws IOException {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
        ConfigServerTestUtils.prepareLocalRepo();
    }

    @Test
    public void contextLoads() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Environment environment = (Environment)response.getBody();
        Assertions.assertThat((List)environment.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("overrides");
        ConfigServerTestUtils.assertConfigEnabled(environment);
    }

    @Test
    public void resourseEndpointsWork() {
        String text = (String)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development/master/bar.properties", String.class, new Object[0]);
        String expected = "foo: bar";
        ((AbstractStringAssert)Assertions.assertThat((String)text).as("invalid content", new Object[0])).isEqualTo(expected);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development/raw/bar.properties", HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        Assertions.assertThat((int)((byte[])response.getBody()).length).isEqualTo(expected.length());
    }

    @Test
    public void invalidYaml() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/invalid/default", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Assertions.assertThat((int)response.getStatusCodeValue()).isEqualTo(500);
    }
}

