/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.composite;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.test.context.runner.WebApplicationContextRunner;
import org.springframework.boot.test.system.OutputCaptureExtension;
import org.springframework.cloud.config.server.composite.CompositeUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.core.env.Environment;

@ExtendWith(value={OutputCaptureExtension.class})
public class CompositUtilsTests {
    @Test
    public void getCompositeTypeListWorks() {
        ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.config.name:compositeconfigserver", "spring.jmx.enabled=false", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[0].type:git", "spring.cloud.config.server.composite[1].uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.composite[1].type:svn"})).run(context -> {
            List types = CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment());
            Assertions.assertThat((List)types).containsExactly((Object[])new String[]{"git", "svn"});
        });
    }

    @Test
    public void getCompositeTypeListFails() {
        Assertions.assertThatThrownBy(() -> ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.config.name:compositeconfigserver", "spring.jmx.enabled=false", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[0].type:git", "spring.cloud.config.server.composite[2].uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.composite[2].type:svn"})).run(context -> CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment()))).isInstanceOf(IllegalStateException.class);
    }
}

