/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.test.util.ReflectionTestUtils;

public class ConfigServerHealthIndicatorTests {
    @Mock
    private EnvironmentRepository repository;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private Environment environment;
    private ConfigServerHealthIndicator indicator;

    @BeforeEach
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.indicator = new ConfigServerHealthIndicator(this.repository);
        this.indicator.init();
    }

    @Test
    public void defaultStatusWorks() {
        Mockito.when((Object)this.repository.findOne(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (String)Mockito.isNull(), ArgumentMatchers.anyBoolean())).thenReturn((Object)this.environment);
        ((ObjectAssert)Assertions.assertThat((Object)this.indicator.health().getStatus()).as("wrong default status", new Object[0])).isEqualTo((Object)Status.UP);
    }

    @Test
    public void exceptionStatusIsDownByDefault() {
        Mockito.when((Object)this.repository.findOne(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (String)Mockito.isNull(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException()});
        ((ObjectAssert)Assertions.assertThat((Object)this.indicator.health().getStatus()).as("wrong exception status", new Object[0])).isEqualTo((Object)Status.DOWN);
    }

    @Test
    public void exceptionDownStatusMayBeCustomized() {
        ReflectionTestUtils.setField((Object)this.indicator, (String)"downHealthStatus", (Object)"CUSTOM");
        Mockito.when((Object)this.repository.findOne(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (String)Mockito.isNull(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new RuntimeException()});
        ((ObjectAssert)Assertions.assertThat((Object)this.indicator.health().getStatus()).as("wrong exception status", new Object[0])).isEqualTo((Object)new Status("CUSTOM"));
    }

    @Test
    public void customLabelWorks() {
        ConfigServerHealthIndicator.Repository repo = new ConfigServerHealthIndicator.Repository();
        repo.setName("myname");
        repo.setProfiles("myprofile");
        repo.setLabel("mylabel");
        this.indicator.setRepositories(Collections.singletonMap("myname", repo));
        Mockito.when((Object)this.repository.findOne("myname", "myprofile", "mylabel", false)).thenReturn((Object)this.environment);
        ((ObjectAssert)Assertions.assertThat((Object)this.indicator.health().getStatus()).as("wrong default status", new Object[0])).isEqualTo((Object)Status.UP);
    }
}

