/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.EnableConfigServer;
import org.springframework.cloud.config.server.config.CustomEnvironmentRepositoryTests;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.support.EnvironmentRepositoryProperties;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

public class CustomCompositeEnvironmentRepositoryTests {

    static class CustomEnvironmentRepository
    implements EnvironmentRepository,
    Ordered {
        private final CustomEnvironmentProperties properties;

        CustomEnvironmentRepository(CustomEnvironmentProperties properties) {
            this.properties = properties;
        }

        public Environment findOne(String application, String profile, String label) {
            return this.findOne(application, profile, label, false);
        }

        public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
            Environment e = new Environment("test", new String[0], "label", "version", "state");
            PropertySource p = new PropertySource(this.properties.getPropertySourceName(), new HashMap());
            e.add(p);
            return e;
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }

    static class CustomEnvironmentProperties
    implements EnvironmentRepositoryProperties {
        private String propertySourceName;

        CustomEnvironmentProperties() {
        }

        CustomEnvironmentProperties(String propertySourceName) {
            this.propertySourceName = propertySourceName;
        }

        public String getPropertySourceName() {
            return this.propertySourceName;
        }

        public void setPropertySourceName(String propertySourceName) {
            this.propertySourceName = propertySourceName;
        }

        public void setOrder(int order) {
        }
    }

    static class CustomEnvironmentRepositoryFactory
    implements EnvironmentRepositoryFactory<CustomEnvironmentRepository, CustomEnvironmentProperties> {
        CustomEnvironmentRepositoryFactory() {
        }

        public CustomEnvironmentRepository build(CustomEnvironmentProperties environmentProperties) throws Exception {
            return new CustomEnvironmentRepository(environmentProperties);
        }
    }

    @SpringBootTest(classes={Config.class}, properties={"spring.config.name:compositeconfigserver", "spring.cloud.config.server.composite[0].type:git", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[1].type:custom", "spring.cloud.config.server.composite[1].propertySourceName:p"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "composite"})
    @DirtiesContext
    public static class ListTests {
        @LocalServerPort
        private int port;

        @BeforeAll
        public static void init() throws Exception {
            SystemReader.setInstance((SystemReader)new MockSystemReader());
            ConfigServerTestUtils.prepareLocalRepo();
        }

        @Test
        public void contextLoads() {
            Environment environment = (Environment)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development", Environment.class, new Object[0]);
            List propertySources = environment.getPropertySources();
            Assertions.assertThat((int)3).isEqualTo(propertySources.size());
            Assertions.assertThat((String)"overrides").isEqualTo(((PropertySource)propertySources.get(0)).getName());
            Assertions.assertThat((String)((PropertySource)propertySources.get(1)).getName()).contains(new CharSequence[]{"config-repo"});
            Assertions.assertThat((String)"p").isEqualTo(((PropertySource)propertySources.get(2)).getName());
        }

        @Configuration(proxyBeanMethods=false)
        @EnableAutoConfiguration
        @EnableConfigServer
        protected static class Config {
            protected Config() {
            }

            public static void main(String[] args) throws Exception {
                SpringApplication.run(CustomEnvironmentRepositoryTests.TestApplication.class, (String[])args);
            }

            @Bean
            public CustomEnvironmentRepositoryFactory customEnvironmentRepositoryFactory(ConfigurableEnvironment environment) {
                return new CustomEnvironmentRepositoryFactory();
            }
        }
    }

    @SpringBootTest(classes={Config.class}, properties={"spring.config.name:compositeconfigserver", "spring.cloud.config.server.git.uri:file:./target/repos/config-repo", "spring.cloud.config.server.git.order:1"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "git"})
    @DirtiesContext
    public static class StaticTests {
        @LocalServerPort
        private int port;

        @BeforeAll
        public static void init() throws Exception {
            SystemReader.setInstance((SystemReader)new MockSystemReader());
            ConfigServerTestUtils.prepareLocalRepo();
        }

        @Test
        public void contextLoads() {
            Environment environment = (Environment)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development", Environment.class, new Object[0]);
            List propertySources = environment.getPropertySources();
            Assertions.assertThat((int)3).isEqualTo(propertySources.size());
            Assertions.assertThat((String)"overrides").isEqualTo(((PropertySource)propertySources.get(0)).getName());
            Assertions.assertThat((String)((PropertySource)propertySources.get(1)).getName()).contains(new CharSequence[]{"config-repo"});
            Assertions.assertThat((String)"p").isEqualTo(((PropertySource)propertySources.get(2)).getName());
        }

        @Configuration(proxyBeanMethods=false)
        @EnableAutoConfiguration
        @EnableConfigServer
        protected static class Config {
            protected Config() {
            }

            public static void main(String[] args) throws Exception {
                SpringApplication.run(CustomEnvironmentRepositoryTests.TestApplication.class, (String[])args);
            }

            @Bean
            public EnvironmentRepository environmentRepository() {
                return new CustomEnvironmentRepository(new CustomEnvironmentProperties("p"));
            }
        }
    }
}

