/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.EnableConfigServer;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(classes={TestApplication.class}, properties={"spring.config.name:configserver"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
@DirtiesContext
public class CustomEnvironmentRepositoryTests {
    @LocalServerPort
    private int port;

    @Test
    public void contextLoads() {
        Environment environment = (Environment)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development", Environment.class, new Object[0]);
        Assertions.assertThat((List)environment.getPropertySources()).isNotEmpty();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableConfigServer
    protected static class TestApplication {
        protected TestApplication() {
        }

        public static void main(String[] args) throws Exception {
            SpringApplication.run(TestApplication.class, (String[])args);
        }

        @Bean
        public EnvironmentRepository environmentRepository() {
            return new EnvironmentRepository(){

                public Environment findOne(String application, String profile, String label) {
                    return this.findOne(application, profile, label, false);
                }

                public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
                    return new Environment("test", new String[0], "label", "version", "state");
                }
            };
        }
    }
}

