/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.EnvironmentConfigTokenProvider;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.support.GitCredentialsProviderFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.test.util.ReflectionTestUtils;

public class EnvironmentRepositoryConfigurationTests {
    @Test
    public void configTokenProviderCanBeOverridden() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{EnvironmentRepositoryConfiguration.class, TestBeans.class}))).withPropertyValues(new String[]{"spring.profiles.active=composite", "spring.cloud.config.server.vault.authentication=TOKEN", "spring.cloud.config.server.vault.token=testTokenValue", "spring.cloud.config.server.composite[0].type=vault", "spring.cloud.config.server.composite[1].type=git", "spring.cloud.config.server.composite[1].uri=https://test.com/Some-Test-Repo.git"})).run(context -> {
            Assertions.assertThat((Object)((ConfigTokenProvider)context.getBean(ConfigTokenProvider.class))).isNotNull();
            Assertions.assertThat((Object)((ConfigTokenProvider)context.getBean(ConfigTokenProvider.class))).isInstanceOf(EnvironmentConfigTokenProvider.class);
            EnvironmentConfigTokenProvider tokenProvider = (EnvironmentConfigTokenProvider)context.getBean(EnvironmentConfigTokenProvider.class);
            Assertions.assertThat((String)tokenProvider.getToken()).isEqualTo("testTokenValue");
        });
    }

    @Test
    public void awsParamStoreFactoryBeanExistsWithComposite() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{EnvironmentRepositoryConfiguration.class, TestBeans.class}))).withPropertyValues(new String[]{"spring.profiles.active=composite", "spring.cloud.config.server.composite[0].type=awsparamstore", "spring.cloud.config.server.composite[0].region=us-east-1", "spring.cloud.config.server.composite[1].type=git", "spring.cloud.config.server.composite[1].uri=https://test.com/Some-Test-Repo.git"})).run(context -> Assertions.assertThat((Object)((AwsParameterStoreEnvironmentRepositoryFactory)context.getBean(AwsParameterStoreEnvironmentRepositoryFactory.class))).isNotNull());
    }

    @Test
    public void customGitCredentialsProvider() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{GitTestBeans.class, TestBeans.class, EnvironmentRepositoryConfiguration.class}))).withPropertyValues(new String[]{"spring.profiles.active=git", "spring.cloud.config.server.git.uri=http://github.com/user/test"})).run(context -> Assertions.assertThat((Object)((GitCredentialsProviderFactory)context.getBean(GitCredentialsProviderFactory.class))).isInstanceOf(GitTestBeans.CustomGitCredentialsProviderFactory.class));
    }

    @Test
    public void configServerActuatorConfigurationWithCustomHealthStatus() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{EnableConfigurationPropertiesBeans.class, EnvironmentRepositoryConfiguration.ConfigServerActuatorConfiguration.class}))).withPropertyValues(new String[]{"spring.cloud.config.server.health.down-health-status=CUSTOMIZED"})).run(context -> {
            ConfigServerHealthIndicator healthIndicator = (ConfigServerHealthIndicator)context.getBean(ConfigServerHealthIndicator.class);
            Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)healthIndicator, (String)"downHealthStatus")).isEqualTo((Object)"CUSTOMIZED");
        });
    }

    @TestConfiguration
    public static class TestBeans {
        @Bean
        public ConfigServerProperties configServerProperties() {
            return new ConfigServerProperties();
        }
    }

    @TestConfiguration
    @AutoConfigureBefore(value={EnvironmentRepositoryConfiguration.class})
    public static class GitTestBeans {
        @Bean
        public GitCredentialsProviderFactory customGitCredentialsProviderFactory() {
            return new CustomGitCredentialsProviderFactory();
        }

        public static class CustomGitCredentialsProviderFactory
        extends GitCredentialsProviderFactory {
        }
    }

    @TestConfiguration
    @EnableConfigurationProperties
    public static class EnableConfigurationPropertiesBeans {
        @Bean
        public EnvironmentRepository environmentRepository() {
            return (EnvironmentRepository)Mockito.mock(EnvironmentRepository.class);
        }
    }
}

