/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.credentials;

import java.net.URISyntaxException;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.support.AwsCodeCommitCredentialProvider;
import org.springframework.cloud.config.server.support.GitCredentialsProviderFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class AwsCodeCommitCredentialsProviderTests {
    private static final String PASSWORD = "secret";
    private static final String USER = "test";
    private static final String AWS_REPO = "https://git-codecommit.us-east-1.amazonaws.com/v1/repos/test";
    private static final String BAD_REPO = "https://amazonaws.com/v1/repos/test";
    private static final String CURLY_BRACES_REPO = "https://git-codecommit.us-east-1.amazonaws.com/v1/repos/{application}";
    private AwsCodeCommitCredentialProvider provider;

    @BeforeEach
    public void init() {
        GitCredentialsProviderFactory factory = new GitCredentialsProviderFactory();
        this.provider = (AwsCodeCommitCredentialProvider)factory.createFor(AWS_REPO, USER, PASSWORD, null, false);
    }

    @Test
    public void basics() {
        Assertions.assertThat((Object)this.provider).isNotNull();
        Assertions.assertThat((String)this.provider.getUsername()).isEqualTo(USER);
        Assertions.assertThat((String)this.provider.getPassword()).isEqualTo(PASSWORD);
        Assertions.assertThat((boolean)this.provider.isInteractive()).isFalse();
    }

    @Test
    public void testSupportsUsernamePassword() {
        Assertions.assertThat((boolean)this.provider.supports(new CredentialItem[]{new CredentialItem.Username(), new CredentialItem.Password()})).isTrue();
    }

    @Test
    public void testNotSupportsOther() {
        Assertions.assertThat((boolean)this.provider.supports(new CredentialItem[]{new CredentialItem.YesNoType("OK To Login?")})).isFalse();
        Assertions.assertThat((boolean)this.provider.supports(new CredentialItem[]{new CredentialItem.StringType("OK To Login?", true)})).isFalse();
        Assertions.assertThat((boolean)this.provider.supports(new CredentialItem[]{new CredentialItem.Username(), new CredentialItem.Password(), new CredentialItem.StringType("OK To Login?", true)})).isFalse();
    }

    @Test
    public void testAwsCredentialsProviderIsNullInitially() {
        AwsCredentialsProvider awsProvider = this.provider.getAwsCredentialProvider();
        Assertions.assertThat((Object)awsProvider).isNull();
    }

    @Test
    public void testAwsCredentialsProviderIsDefinedAfterGet() throws URISyntaxException {
        AwsCredentialsProvider awsProvider = this.provider.getAwsCredentialProvider();
        Assertions.assertThat((Object)awsProvider).isNull();
        Assertions.assertThat((boolean)this.provider.get(new URIish(AWS_REPO), this.makeCredentialItems())).isTrue();
        awsProvider = this.provider.getAwsCredentialProvider();
        Assertions.assertThat((Object)awsProvider).isNotNull();
        Assertions.assertThat((boolean)(awsProvider instanceof AwsCodeCommitCredentialProvider.AWSStaticCredentialsProvider)).isTrue();
    }

    @Test
    public void testBadUriReturnsFalse() throws UnsupportedCredentialItem, URISyntaxException {
        CredentialItem[] credentialItems = this.makeCredentialItems();
        Assertions.assertThat((boolean)this.provider.get(new URIish(BAD_REPO), credentialItems)).isFalse();
    }

    @Test
    public void testUriWithCurlyBracesReturnsTrue() throws UnsupportedCredentialItem, URISyntaxException {
        GitCredentialsProviderFactory factory = new GitCredentialsProviderFactory();
        this.provider = (AwsCodeCommitCredentialProvider)factory.createFor(CURLY_BRACES_REPO, USER, PASSWORD, null, false);
        CredentialItem[] credentialItems = this.makeCredentialItems();
        Assertions.assertThat((boolean)this.provider.get(new URIish(CURLY_BRACES_REPO), credentialItems)).isTrue();
    }

    @Test
    public void testThrowsUnsupportedCredentialException() throws URISyntaxException {
        CredentialItem[] goodCredentialItems = this.makeCredentialItems();
        CredentialItem[] badCredentialItems = new CredentialItem[]{goodCredentialItems[0], goodCredentialItems[1], new CredentialItem.YesNoType("OK?")};
        try {
            this.provider.get(new URIish(AWS_REPO), badCredentialItems);
            Assertions.fail((String)"Expected UnsupportedCredentialItem exception");
        }
        catch (UnsupportedCredentialItem e) {
            Assertions.assertThat((String)e.getMessage()).isNotNull();
        }
    }

    @Test
    public void testReturnsCredentials() throws URISyntaxException {
        CredentialItem[] credentialItems = this.makeCredentialItems();
        Assertions.assertThat((boolean)this.provider.get(new URIish(AWS_REPO), credentialItems)).isTrue();
        String theUsername = ((CredentialItem.Username)credentialItems[0]).getValue();
        char[] thePassword = ((CredentialItem.Password)credentialItems[1]).getValue();
        Assertions.assertThat((String)theUsername).isEqualTo(USER);
        Assertions.assertThat((char[])thePassword).isNotNull();
        Assertions.assertThat((thePassword.length > 16 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((char)thePassword[8]).isEqualTo('T');
        Assertions.assertThat((char)thePassword[15]).isEqualTo('Z');
    }

    private CredentialItem[] makeCredentialItems() {
        CredentialItem[] credentialItems = new CredentialItem[]{new CredentialItem.Username(), new CredentialItem.Password()};
        return credentialItems;
    }
}

