/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.credentials;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.support.AwsCodeCommitCredentialProvider;
import org.springframework.cloud.config.server.support.GitCredentialsProviderFactory;
import org.springframework.cloud.config.server.support.GitSkipSslValidationCredentialsProvider;
import org.springframework.cloud.config.server.support.PassphraseCredentialsProvider;

public class GitCredentialsProviderFactoryTests {
    private static final String PASSWORD = "secret";
    private static final String USER = "test";
    private static final String FILE_REPO = "file:///home/user/repo";
    private static final String HTTPS_GIT_REPO = "https://github.com/spring-cloud/spring-cloud-config-test";
    private static final String SSH_GIT_REPO = "git@github.com:spring-cloud/spring-cloud-config-test.git";
    private static final String AWS_REPO = "https://git-codecommit.us-east-1.amazonaws.com/v1/repos/test";
    private GitCredentialsProviderFactory factory;

    @BeforeEach
    public void init() {
        this.factory = new GitCredentialsProviderFactory();
    }

    @Test
    public void testCreateForFileNoUsernameIsNull() {
        CredentialsProvider provider = this.factory.createFor(FILE_REPO, null, null, null, false);
        Assertions.assertThat((Object)provider).isNull();
    }

    @Test
    public void testCreateForFileWithUsernameAndPassword() {
        CredentialsProvider provider = this.factory.createFor(FILE_REPO, USER, PASSWORD, null, false);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof UsernamePasswordCredentialsProvider)).isTrue();
    }

    @Test
    public void testCreateForServerWithUsernameAndNoPassword() {
        CredentialsProvider provider = this.factory.createFor(HTTPS_GIT_REPO, USER, "", null, false);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof UsernamePasswordCredentialsProvider)).isTrue();
    }

    @Test
    public void testCreateForServerNoUsernameIsNull() {
        CredentialsProvider provider = this.factory.createFor(HTTPS_GIT_REPO, null, null, null, false);
        Assertions.assertThat((Object)provider).isNull();
    }

    @Test
    public void testCreateForServerWithUsername() {
        CredentialsProvider provider = this.factory.createFor(HTTPS_GIT_REPO, USER, PASSWORD, null, false);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof UsernamePasswordCredentialsProvider)).isTrue();
    }

    @Test
    public void testCreateForHttpsServerWithSkipSslValidation() {
        CredentialsProvider provider = this.factory.createFor(HTTPS_GIT_REPO, USER, PASSWORD, null, true);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof GitSkipSslValidationCredentialsProvider)).isTrue();
    }

    @Test
    public void testCreateForHttpsServerWithoutSpecifyingSkipSslValidation() {
        CredentialsProvider provider = this.factory.createFor(HTTPS_GIT_REPO, USER, PASSWORD, null);
        Assertions.assertThat((Object)provider).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(provider instanceof UsernamePasswordCredentialsProvider)).as("deprecated createFor() should not enable ssl validation skipping", new Object[0])).isTrue();
    }

    @Test
    public void testCreateForSshServerWithSkipSslValidation() {
        CredentialsProvider provider = this.factory.createFor(SSH_GIT_REPO, USER, PASSWORD, null, true);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof UsernamePasswordCredentialsProvider)).isTrue();
    }

    @Test
    public void testCreateForAwsNoUsername() {
        CredentialsProvider provider = this.factory.createFor(AWS_REPO, null, null, null, false);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof AwsCodeCommitCredentialProvider)).isTrue();
        AwsCodeCommitCredentialProvider aws = (AwsCodeCommitCredentialProvider)provider;
        Assertions.assertThat((String)aws.getUsername()).isNull();
        Assertions.assertThat((String)aws.getPassword()).isNull();
    }

    @Test
    public void testCreateForAwsWithUsername() {
        CredentialsProvider provider = this.factory.createFor(AWS_REPO, USER, PASSWORD, null, false);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof AwsCodeCommitCredentialProvider)).isTrue();
        AwsCodeCommitCredentialProvider aws = (AwsCodeCommitCredentialProvider)provider;
        Assertions.assertThat((String)aws.getUsername()).isEqualTo(USER);
        Assertions.assertThat((String)aws.getPassword()).isEqualTo(PASSWORD);
    }

    @Test
    public void testCreateForAwsDisabled() {
        this.factory.setAwsCodeCommitEnabled(false);
        CredentialsProvider provider = this.factory.createFor(AWS_REPO, null, null, null, false);
        Assertions.assertThat((Object)provider).isNull();
        provider = this.factory.createFor(AWS_REPO, USER, PASSWORD, null, false);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof UsernamePasswordCredentialsProvider)).isTrue();
    }

    @Test
    public void testCreatePassphraseCredentialProvider() {
        CredentialsProvider provider = this.factory.createFor(HTTPS_GIT_REPO, null, null, PASSWORD, false);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)(provider instanceof PassphraseCredentialsProvider)).isTrue();
    }

    @Test
    public void testIsAwsCodeCommitEnabled() {
        Assertions.assertThat((boolean)this.factory.isAwsCodeCommitEnabled()).isTrue();
    }

    @Test
    public void testSetAwsCodeCommitEnabled() {
        Assertions.assertThat((boolean)this.factory.isAwsCodeCommitEnabled()).isTrue();
        this.factory.setAwsCodeCommitEnabled(false);
        Assertions.assertThat((boolean)this.factory.isAwsCodeCommitEnabled()).isFalse();
    }
}

