/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.runners.Parameterized;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.environment.PropertyValueDescriptor;
import org.springframework.cloud.config.server.encryption.CipherEnvironmentEncryptor;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class CipherEnvironmentEncryptorTests {
    @Parameterized.Parameters
    public static List<Object[]> params() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{"deadbeef", "foo"});
        list.add(new Object[]{"4567890a12345678", "bar"});
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    public void shouldDecryptEnvironment(String salt, String key) {
        TextEncryptor textEncryptor = new EncryptorFactory(salt).create(key);
        CipherEnvironmentEncryptor encryptor = new CipherEnvironmentEncryptor(keys -> textEncryptor);
        String secret = UUID.randomUUID().toString();
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), "{cipher}" + textEncryptor.encrypt(secret))));
        Assertions.assertThat(((PropertySource)encryptor.decrypt(environment).getPropertySources().get(0)).getSource().get(environment.getName())).isEqualTo((Object)secret);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    public void shouldDecryptEnvironmentWithKey(String salt, String key) {
        TextEncryptor textEncryptor = new EncryptorFactory(salt).create(key);
        CipherEnvironmentEncryptor encryptor = new CipherEnvironmentEncryptor(keys -> textEncryptor);
        String secret = UUID.randomUUID().toString();
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), "{cipher}{key:test}" + textEncryptor.encrypt(secret))));
        Assertions.assertThat(((PropertySource)encryptor.decrypt(environment).getPropertySources().get(0)).getSource().get(environment.getName())).isEqualTo((Object)secret);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    public void shouldBeAbleToUseNullAsPropertyValue(String salt, String key) {
        TextEncryptor textEncryptor = new EncryptorFactory(salt).create(key);
        CipherEnvironmentEncryptor encryptor = new CipherEnvironmentEncryptor(keys -> textEncryptor);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), null)));
        Assertions.assertThat(((PropertySource)encryptor.decrypt(environment).getPropertySources().get(0)).getSource().get(environment.getName())).isEqualTo(null);
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    public void shouldDecryptEnvironmentIncludeOrigin(String salt, String key) {
        TextEncryptor textEncryptor = new EncryptorFactory(salt).create(key);
        CipherEnvironmentEncryptor encryptor = new CipherEnvironmentEncryptor(keys -> textEncryptor);
        String secret = UUID.randomUUID().toString();
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        String encrypted = "{cipher}" + textEncryptor.encrypt(secret);
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), new PropertyValueDescriptor((Object)encrypted, "encrypted value"))));
        Assertions.assertThat(((PropertySource)encryptor.decrypt(environment).getPropertySources().get(0)).getSource().get(environment.getName())).isEqualTo((Object)secret);
    }
}

