/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.CipherResourceYamlEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.ResourceUtils;

public class CipherResourceYamlEncryptorTests {
    private final String salt = "deadbeef";
    private final String key = "foo";
    private TextEncryptor textEncryptor = new EncryptorFactory("deadbeef").create("foo");
    private CipherResourceYamlEncryptor encryptor = new CipherResourceYamlEncryptor(new TextEncryptorLocator(){

        public TextEncryptor locate(Map<String, String> keys) {
            return CipherResourceYamlEncryptorTests.this.textEncryptor;
        }
    });

    @Test
    public void whenDecryptResource_thenAllEncryptedValuesDecrypted() throws Exception {
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        File file = ResourceUtils.getFile((String)"classpath:resource-encryptor/test.yml");
        String text = new String(Files.readAllBytes(file.toPath()));
        String decyptedResource = this.encryptor.decrypt(text, environment);
        Assertions.assertThat((boolean)decyptedResource.contains("{cipher}")).isFalse();
    }
}

