/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.bootstrap.encrypt.TextEncryptorUtils;
import org.springframework.cloud.config.server.config.DefaultTextEncryptionAutoConfiguration;
import org.springframework.cloud.config.server.config.RsaEncryptionAutoConfiguration;
import org.springframework.cloud.config.server.encryption.KeyStoreTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.LocatorTextEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

public class EncryptionAutoConfigurationTests {
    @Test
    public void defaultNoKeyAutoConfigurationTest() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{DefaultTextEncryptionAutoConfiguration.class, RsaEncryptionAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class, ServerProperties.class, PropertyPlaceholderAutoConfiguration.class}).properties(new String[]{"server.port=0"}).run(new String[0]);
        TextEncryptor textEncryptor = (TextEncryptor)context.getBean(TextEncryptor.class);
        Object[] textEncryptorLocatorNames = context.getBeanNamesForType(TextEncryptorLocator.class);
        Assertions.assertThat((Object)textEncryptor).isInstanceOf(TextEncryptorUtils.FailsafeTextEncryptor.class);
        Assertions.assertThat((Object[])textEncryptorLocatorNames).isEmpty();
        context.close();
    }

    @Test
    public void defaultKeyStoreAutoConfigurationTest() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{DefaultTextEncryptionAutoConfiguration.class, RsaEncryptionAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class, ServerProperties.class, PropertyPlaceholderAutoConfiguration.class}).properties(new String[]{"server.port=0", "encrypt.key-store.location=classpath:server.jks", "encrypt.key-store.password=letmein", "encrypt.key-store.alias=myKey"}).run(new String[0]);
        TextEncryptor textEncryptor = (TextEncryptor)context.getBean(TextEncryptor.class);
        TextEncryptorLocator textEncryptorLocator = (TextEncryptorLocator)context.getBean(TextEncryptorLocator.class);
        Assertions.assertThat((Object)textEncryptor).isInstanceOf(RsaSecretEncryptor.class);
        Assertions.assertThat((Object)textEncryptorLocator).isInstanceOf(KeyStoreTextEncryptorLocator.class);
        context.close();
    }

    @Test
    public void defaultKeyAutoConfigurationTest() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{DefaultTextEncryptionAutoConfiguration.class, RsaEncryptionAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class, ServerProperties.class, PropertyPlaceholderAutoConfiguration.class}).properties(new String[]{"server.port=0", "encrypt.key=mykey"}).run(new String[0]);
        TextEncryptor textEncryptor = (TextEncryptor)context.getBean(TextEncryptor.class);
        Object[] textEncryptorLocatorNames = context.getBeanNamesForType(TextEncryptorLocator.class);
        Assertions.assertThat((String)textEncryptor.getClass().getName()).isEqualTo("org.springframework.security.crypto.encrypt.HexEncodingTextEncryptor");
        Assertions.assertThat((Object[])textEncryptorLocatorNames).isEmpty();
        context.close();
    }

    @Test
    public void bootstrapNoKeyAutoConfigurationTest() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{DefaultTextEncryptionAutoConfiguration.class, RsaEncryptionAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class, ServerProperties.class, PropertyPlaceholderAutoConfiguration.class}).properties(new String[]{"server.port=0", "spring.cloud.bootstrap.enabled=true"}).run(new String[0]);
        TextEncryptor textEncryptor = (TextEncryptor)context.getBean(TextEncryptor.class);
        Object[] textEncryptorLocatorNames = context.getBeanNamesForType(TextEncryptorLocator.class);
        Assertions.assertThat((boolean)textEncryptor.getClass().isInstance(Encryptors.noOpText().getClass()));
        Assertions.assertThat((Object[])textEncryptorLocatorNames).isEmpty();
        context.close();
    }

    @Test
    public void bootstrapKeyAutoConfigurationTests() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{DefaultTextEncryptionAutoConfiguration.class, RsaEncryptionAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class, ServerProperties.class, PropertyPlaceholderAutoConfiguration.class}).properties(new String[]{"server.port=0", "spring.cloud.bootstrap.enabled=true", "encrypt.key=mykey"}).run(new String[0]);
        TextEncryptor textEncryptor = (TextEncryptor)context.getBean(TextEncryptor.class);
        Assertions.assertThat((String)textEncryptor.getClass().getName()).isEqualTo("org.springframework.security.crypto.encrypt.HexEncodingTextEncryptor");
        context.close();
    }

    @Test
    public void bootstrapKeyStoreAutoConfigurationTest() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{DefaultTextEncryptionAutoConfiguration.class, RsaEncryptionAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class, ServerProperties.class, PropertyPlaceholderAutoConfiguration.class}).properties(new String[]{"server.port=0", "spring.cloud.bootstrap.enabled=true", "encrypt.key-store.location=classpath:server.jks", "encrypt.key-store.password=letmein", "encrypt.key-store.alias=myKey"}).run(new String[0]);
        TextEncryptor textEncryptor = (TextEncryptor)context.getBean(TextEncryptor.class);
        TextEncryptorLocator textEncryptorLocator = (TextEncryptorLocator)context.getBean(TextEncryptorLocator.class);
        Assertions.assertThat((Object)textEncryptor).isInstanceOf(LocatorTextEncryptor.class);
        Assertions.assertThat((Object)textEncryptorLocator).isInstanceOf(KeyStoreTextEncryptorLocator.class);
        context.close();
    }
}

