/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.encryption.EncryptionController;
import org.springframework.cloud.config.server.encryption.EncryptionTooWeakException;
import org.springframework.cloud.config.server.encryption.SingleTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.http.MediaType;
import org.springframework.security.crypto.encrypt.Encryptors;

public class EncryptionControllerMultiTextEncryptorTests {
    EncryptionController controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator(Encryptors.noOpText()));
    String application = "application";
    String profiles = "profile1,profile2";
    String data = "foo";

    @Test
    public void shouldEncryptUsingApplicationAndProfiles() {
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator(Encryptors.text((CharSequence)"application", (CharSequence)"11")));
        String encrypted = this.controller.encrypt(this.application, this.profiles, this.data, MediaType.TEXT_PLAIN);
        Assertions.assertThat((String)this.controller.decrypt(this.application, this.profiles, encrypted, MediaType.TEXT_PLAIN)).isEqualTo(this.data);
    }

    @Test
    public void shouldNotEncryptUsingNoOp() {
        Assertions.assertThatThrownBy(() -> {
            String application = "unknown";
            this.controller.encrypt(application, this.profiles, this.data, MediaType.TEXT_PLAIN);
        }).isInstanceOf(EncryptionTooWeakException.class);
    }

    @Test
    public void shouldNotDecryptUsingNoOp() {
        Assertions.assertThatThrownBy(() -> {
            String application = "unknown";
            this.controller.decrypt(application, this.profiles, this.data, MediaType.TEXT_PLAIN);
        }).isInstanceOf(EncryptionTooWeakException.class);
    }
}

