/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.config.server.encryption.EncryptionController;
import org.springframework.cloud.config.server.encryption.EncryptionTooWeakException;
import org.springframework.cloud.config.server.encryption.InvalidCipherException;
import org.springframework.cloud.config.server.encryption.SingleTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.http.MediaType;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

public class EncryptionControllerTests {
    private EncryptionController controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator(Encryptors.noOpText()));

    @Test
    public void cannotDecryptWithoutKey() {
        AssertionsForClassTypes.assertThatExceptionOfType(EncryptionTooWeakException.class).isThrownBy(() -> this.controller.decrypt("foo", MediaType.TEXT_PLAIN));
    }

    @Test
    public void cannotDecryptWithNoopEncryptor() {
        AssertionsForClassTypes.assertThatExceptionOfType(EncryptionTooWeakException.class).isThrownBy(() -> this.controller.decrypt("foo", MediaType.TEXT_PLAIN));
    }

    @Test
    public void shouldThrowExceptionOnDecryptInvalidData() {
        AssertionsForClassTypes.assertThatExceptionOfType(InvalidCipherException.class).isThrownBy(() -> {
            this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
            this.controller.decrypt("foo", MediaType.TEXT_PLAIN);
        });
    }

    @Test
    public void shouldThrowExceptionOnDecryptWrongKey() {
        AssertionsForClassTypes.assertThatExceptionOfType(InvalidCipherException.class).isThrownBy(() -> {
            RsaSecretEncryptor encryptor = new RsaSecretEncryptor();
            this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
            this.controller.decrypt(encryptor.encrypt("foo"), MediaType.TEXT_PLAIN);
        });
    }

    @Test
    public void sunnyDayRsaKey() {
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
        String cipher = this.controller.encrypt("foo", MediaType.TEXT_PLAIN);
        Assertions.assertThat((String)this.controller.decrypt(cipher, MediaType.TEXT_PLAIN)).isEqualTo("foo");
    }

    @Test
    public void publicKey() {
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
        String key = this.controller.getPublicKey();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)key.startsWith("ssh-rsa")).as("Wrong key format: " + key, new Object[0])).isTrue();
    }

    @Test
    public void appAndProfile() {
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
        String cipher = this.controller.encrypt("app", "default", "foo bar", MediaType.TEXT_PLAIN);
        String decrypt = this.controller.decrypt("app", "default", cipher, MediaType.TEXT_PLAIN);
        ((AbstractStringAssert)Assertions.assertThat((String)decrypt).as("Wrong decrypted plaintext: " + decrypt, new Object[0])).isEqualTo("foo bar");
    }

    @Test
    public void formDataIn() {
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
        String cipher = this.controller.encrypt("foo bar=", MediaType.APPLICATION_FORM_URLENCODED);
        String decrypt = this.controller.decrypt(cipher + "=", MediaType.APPLICATION_FORM_URLENCODED);
        ((AbstractStringAssert)Assertions.assertThat((String)decrypt).as("Wrong decrypted plaintext: " + decrypt, new Object[0])).isEqualTo("foo bar");
    }

    @Test
    public void formDataInWithPrefix() {
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
        String cipher = this.controller.encrypt("{key:test}foo bar=", MediaType.APPLICATION_FORM_URLENCODED);
        String decrypt = this.controller.decrypt(cipher + "=", MediaType.APPLICATION_FORM_URLENCODED);
        ((AbstractStringAssert)Assertions.assertThat((String)decrypt).as("Wrong decrypted plaintext: " + decrypt, new Object[0])).isEqualTo("foo bar");
    }

    @Test
    public void prefixStrippedBeforeEncrypt() {
        TextEncryptor encryptor = (TextEncryptor)Mockito.mock(TextEncryptor.class);
        Mockito.when((Object)encryptor.encrypt(ArgumentMatchers.anyString())).thenReturn((Object)"myEncryptedValue");
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator(encryptor));
        this.controller.encrypt("{key:test}foo", MediaType.TEXT_PLAIN);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((TextEncryptor)Mockito.verify((Object)encryptor, (VerificationMode)Mockito.atLeastOnce())).encrypt((String)captor.capture());
        ((AbstractStringAssert)Assertions.assertThat((String)((String)captor.getValue())).doesNotContain(new CharSequence[]{"{key:test}"})).as("Prefix must be stripped prior to encrypt", new Object[0]);
    }

    @Test
    public void encryptDecyptTextWithCurlyBrace() {
        this.controller = new EncryptionController((TextEncryptorLocator)new SingleTextEncryptorLocator((TextEncryptor)new RsaSecretEncryptor()));
        String plain = "textwith}brace";
        String cipher = this.controller.encrypt(plain, MediaType.APPLICATION_FORM_URLENCODED);
        String decrypt = this.controller.decrypt(cipher, MediaType.APPLICATION_FORM_URLENCODED);
        Assertions.assertThat((String)decrypt).isEqualTo(plain);
    }

    @Test
    public void addEnvironment() {
        TextEncryptorLocator locator = new TextEncryptorLocator(){
            private final RsaSecretEncryptor encryptor = new RsaSecretEncryptor();

            public TextEncryptor locate(Map<String, String> keys) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)keys.containsKey("key")).as("Missing encryptor key", new Object[0])).isTrue();
                ((AbstractStringAssert)Assertions.assertThat((String)keys.get("key")).as("Bad encryptor key value", new Object[0])).isEqualTo("value");
                return this.encryptor;
            }
        };
        this.controller = new EncryptionController(locator);
        String cipher = this.controller.encrypt("app", "default", "{key:value}foo bar", MediaType.TEXT_PLAIN);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)cipher.contains("{name:app}")).as("Wrong cipher: " + cipher, new Object[0])).isFalse();
        String decrypt = this.controller.decrypt("app", "default", cipher, MediaType.TEXT_PLAIN);
        ((AbstractStringAssert)Assertions.assertThat((String)decrypt).as("Wrong decrypted plaintext: " + decrypt, new Object[0])).isEqualTo("foo bar");
    }
}

