/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.util.MultiValueMap;

public class EncryptionIntegrationTests {

    @SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.use-legacy-processing=true", "spring.cloud.bootstrap.name:keystore-bootstrap", "spring.cloud.config.server.encrypt.enabled=false", "encrypt.keyStore.alias=myencryptionkey"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "git"})
    @DirtiesContext
    public static class KeystoreConfigurationEncryptionOnlyIntegrationTests {
        @Autowired
        private TestRestTemplate testRestTemplate;

        @BeforeAll
        public static void setupTest() throws Exception {
            ConfigServerTestUtils.prepareLocalRepo("./", "target/repos", "encrypt-repo", "target/config");
        }

        @Test
        public void shouldOnlySupportEncryption() {
            ResponseEntity entity = this.testRestTemplate.getForEntity("/keystore-bootstrap/encrypt", String.class, new Object[0]);
            Assertions.assertThat((Object)entity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
            Assertions.assertThat((String)((String)entity.getBody())).contains(new CharSequence[]{"{cipher}{key:mytestkey}AQCohs2V6P8/UiG6a4TF/CZTCBdt5Q7wvNvcyf6vs2ByK2ZYSM77Nu0sOAduxUpMbVwJ/syecmkIXR+hU3EfT2uqPieA7/v5n33ppqIQ9JAt5JggdYIGe+wX25zU3DTXOOJdAAMzNX+zjOVyCh0QtmJf/kFslg6NqQq0E+kSg3zBi3AnkKj5BLnLIxkjxzKA4mnDXpSm7ekLZZP2iQSYSW/82AC7UOLLzTqwInMI3tJLW1e9Ne+LDsjmSxA+nkK9zhidtXPwb/SPaNF74cJCEf9mgzzKYwJlwqChLzJt8UQ1jHwRc8B6FufmizUHSp27nxdtVB4HMqh3nNsMCy137Ces58T09ZS/y/cYNRxcFbp78MHFHUqAgbC0B/p5t6h4XbQ="});
            HttpEntity encryptionRequest = new HttpEntity((Object)"valueToBeEncrypted");
            entity = this.testRestTemplate.postForEntity("/encrypt", (Object)encryptionRequest, String.class, new Object[0]);
            Assertions.assertThat((Object)entity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
            HttpHeaders decryptionRequestHeaders = new HttpHeaders();
            decryptionRequestHeaders.setContentType(MediaType.TEXT_PLAIN);
            HttpEntity decryptionRequest = new HttpEntity((Object)((String)entity.getBody()), (MultiValueMap)decryptionRequestHeaders);
            entity = this.testRestTemplate.postForEntity("/decrypt", (Object)decryptionRequest, String.class, new Object[0]);
            Assertions.assertThat((Object)entity.getStatusCode()).isEqualTo((Object)HttpStatus.BAD_REQUEST);
        }
    }

    @SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.use-legacy-processing=true", "spring.cloud.bootstrap.name:keystore-bootstrap"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "native"})
    @DirtiesContext
    public static class KeystoreConfigurationIntegrationTests {
        @Autowired
        private TestRestTemplate testRestTemplate;

        @Test
        public void keystoreBootstrapConfig() throws Exception {
            ResponseEntity entity = this.testRestTemplate.getForEntity("/encrypt/status", String.class, new Object[0]);
            Assertions.assertThat((Object)entity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        }
    }

    @SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.use-legacy-processing=true", "spring.cloud.bootstrap.name:symmetric-key-bootstrap"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "native"})
    @DirtiesContext
    public static class BootstrapConfigSymmetricEncryptionIntegrationTests {
        @Autowired
        private TestRestTemplate testRestTemplate;

        @Test
        public void symmetricEncryptionBootstrapConfig() throws Exception {
            ResponseEntity entity = this.testRestTemplate.getForEntity("/encrypt/status", String.class, new Object[0]);
            Assertions.assertThat((Object)entity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        }
    }

    @SpringBootTest(classes={TestConfigServerApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.config.use-legacy-processing=true", "encrypt.key=foobar"})
    @ActiveProfiles(value={"test", "native"})
    @DirtiesContext
    public static class ConfigSymmetricEncryptionIntegrationTests {
        @Autowired
        private TestRestTemplate testRestTemplate;

        @Test
        public void symmetricEncryptionEnabled() throws Exception {
            ResponseEntity entity = this.testRestTemplate.getForEntity("/encrypt/status", String.class, new Object[0]);
            Assertions.assertThat((Object)entity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        }
    }
}

