/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.encryption.EnvironmentPrefixHelper;

public class EnvironmentPrefixHelperTests {
    private EnvironmentPrefixHelper helper = new EnvironmentPrefixHelper();

    @Test
    public void testAddPrefix() {
        Assertions.assertThat((String)this.helper.addPrefix(Collections.singletonMap("bar", "spam"), "foo")).isEqualTo("{bar:spam}foo");
    }

    @Test
    public void testAddNoPrefix() {
        Assertions.assertThat((String)this.helper.addPrefix(Collections.emptyMap(), "foo")).isEqualTo("foo");
    }

    @Test
    public void testStripNoPrefix() {
        Assertions.assertThat((String)this.helper.stripPrefix("foo")).isEqualTo("foo");
    }

    @Test
    public void testStripPrefix() {
        Assertions.assertThat((String)this.helper.stripPrefix("{key:foo}foo")).isEqualTo("foo");
    }

    @Test
    public void testStripPrefixWithEscape() {
        Assertions.assertThat((String)this.helper.stripPrefix("{plain}{key:foo}foo")).isEqualTo("{key:foo}foo");
    }

    @Test
    public void testKeysDefaults() {
        Map keys = this.helper.getEncryptorKeys("foo", "bar", "spam");
        Assertions.assertThat((Map)keys).containsEntry((Object)"name", (Object)"foo");
        Assertions.assertThat((Map)keys).containsEntry((Object)"profiles", (Object)"bar");
    }

    @Test
    public void testKeysWithPrefix() {
        Map keys = this.helper.getEncryptorKeys("foo", "bar", "{key:mykey}foo");
        Assertions.assertThat((Map)keys).hasSize(3);
        Assertions.assertThat((Map)keys).containsEntry((Object)"key", (Object)"mykey");
    }

    @Test
    public void testKeysWithPrefixAndEscape() {
        Map keys = this.helper.getEncryptorKeys("foo", "bar", "{key:mykey}{plain}{foo:bar}foo");
        Assertions.assertThat((Map)keys).hasSize(3);
        Assertions.assertThat((Map)keys).containsEntry((Object)"key", (Object)"mykey");
    }

    @Test
    public void testTextWithCurlyBracesNoPrefix() {
        Assertions.assertThat((String)this.helper.stripPrefix("textwith}brac{es")).isEqualTo("textwith}brac{es");
    }

    @Test
    public void testTextWithCurlyBracesPrefix() {
        Assertions.assertThat((String)this.helper.stripPrefix("{key:foo}{name:bar}textwith}brac{es{and}prefix")).isEqualTo("textwith}brac{es{and}prefix");
    }
}

