/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.encryption.KeyStoreTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.SecretLocator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;

public class KeyStoreTextEncryptorLocatorTests {
    private KeyStoreTextEncryptorLocator locator = new KeyStoreTextEncryptorLocator(new KeyStoreKeyFactory((Resource)new ClassPathResource("server.jks"), "letmein".toCharArray()), "changeme", "mytestkey");

    @Test
    public void testDefaults() {
        TextEncryptor encryptor = this.locator.locate(Collections.emptyMap());
        Assertions.assertThat((String)encryptor.decrypt(encryptor.encrypt("foo"))).isEqualTo("foo");
    }

    @Test
    public void testDifferentKeyDefaultSecret() {
        this.locator.setSecretLocator(new SecretLocator(){

            public char[] locate(String secret) {
                Assertions.assertThat((String)secret).isEqualTo("changeme");
                return "letmein".toCharArray();
            }
        });
        TextEncryptor encryptor = this.locator.locate(Collections.singletonMap("key", "mykey"));
        Assertions.assertThat((String)encryptor.decrypt(encryptor.encrypt("foo"))).isEqualTo("foo");
    }

    @Test
    public void testDifferentKeyAndSecret() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "mytestkey");
        map.put("secret", "changeme");
        TextEncryptor encryptor = this.locator.locate(map);
        Assertions.assertThat((String)encryptor.decrypt(encryptor.encrypt("foo"))).isEqualTo("foo");
    }

    @Test
    public void testDefaultEncryptor() {
        TextEncryptor encryptor1 = this.locator.locate(Collections.emptyMap());
        TextEncryptor encryptor2 = this.locator.locate(Collections.emptyMap());
        Assertions.assertThat((Object)encryptor1).isEqualTo((Object)encryptor2);
    }
}

