/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption.vault;

import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.encryption.vault.VaultEnvironmentEncryptor;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.support.VaultResponse;

public class VaultEnvironmentEncryptorTests {
    @Test
    public void shouldResolveProperty() {
        String secret = "mysecret";
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get("accounts/mypay")).thenReturn((Object)this.withVaultResponse("access_key", secret));
        VaultEnvironmentEncryptor encryptor = new VaultEnvironmentEncryptor(keyValueTemplate);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), "{vault}:accounts/mypay#access_key")));
        Assertions.assertThat(((PropertySource)encryptor.decrypt(environment).getPropertySources().get(0)).getSource().get(environment.getName())).isEqualTo((Object)secret);
    }

    @Test
    public void shouldReturnNullIfPropertyNotFoundInVault() {
        String secret = "mysecret";
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        Mockito.when((Object)keyValueTemplate.get("accounts/mypay")).thenReturn((Object)this.withVaultResponse("access_key", secret));
        VaultEnvironmentEncryptor encryptor = new VaultEnvironmentEncryptor(keyValueTemplate);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), "{vault}:accounts/mypay#another_key")));
        Assertions.assertThat(((PropertySource)encryptor.decrypt(environment).getPropertySources().get(0)).getSource().get(environment.getName())).isNull();
    }

    @Test
    public void shouldSkipPropertyWithNotVaultPrefix() {
        String value = "test{vault}:accounts/mypay#access_key";
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        VaultEnvironmentEncryptor encryptor = new VaultEnvironmentEncryptor(keyValueTemplate);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), value)));
        Assertions.assertThat(((PropertySource)encryptor.decrypt(environment).getPropertySources().get(0)).getSource().get(environment.getName())).isEqualTo((Object)value);
    }

    @Test
    public void shouldMarkAsInvalidPropertyWithNoKeyValue() {
        String value = "{vault}:accounts/mypay";
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        VaultEnvironmentEncryptor encryptor = new VaultEnvironmentEncryptor(keyValueTemplate);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), value)));
        Environment processedEnvironment = encryptor.decrypt(environment);
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get(environment.getName())).isNull();
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get("invalid." + environment.getName())).isEqualTo((Object)"<n/a>");
    }

    @Test
    public void shouldMarkAsInvalidPropertyWithNoEmptyValue() {
        String value = "{vault}:accounts/mypay#";
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        VaultEnvironmentEncryptor encryptor = new VaultEnvironmentEncryptor(keyValueTemplate);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), value)));
        Environment processedEnvironment = encryptor.decrypt(environment);
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get(environment.getName())).isNull();
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get("invalid." + environment.getName())).isEqualTo((Object)"<n/a>");
    }

    @Test
    public void shouldMarkAsInvalidPropertyWithWrongFormat() {
        String value = "{vault}test:accounts/mypay#";
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        VaultEnvironmentEncryptor encryptor = new VaultEnvironmentEncryptor(keyValueTemplate);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), value)));
        Environment processedEnvironment = encryptor.decrypt(environment);
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get(environment.getName())).isNull();
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get("invalid." + environment.getName())).isEqualTo((Object)"<n/a>");
    }

    @Test
    public void shouldMarkAsInvalidPropertyWithWrongFormat2() {
        String value = "{vault}:#xxx";
        VaultKeyValueOperations keyValueTemplate = (VaultKeyValueOperations)Mockito.mock(VaultKeyValueOperations.class);
        VaultEnvironmentEncryptor encryptor = new VaultEnvironmentEncryptor(keyValueTemplate);
        Environment environment = new Environment("name", new String[]{"profile", "label"});
        environment.add(new PropertySource("a", Collections.singletonMap(environment.getName(), value)));
        Environment processedEnvironment = encryptor.decrypt(environment);
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get(environment.getName())).isNull();
        Assertions.assertThat(((PropertySource)processedEnvironment.getPropertySources().get(0)).getSource().get("invalid." + environment.getName())).isEqualTo((Object)"<n/a>");
    }

    private VaultResponse withVaultResponse(String key, Object value) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put(key, value);
        VaultResponse response = new VaultResponse();
        response.setData(responseData);
        return response;
    }
}

