/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepository;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.Parameter;
import software.amazon.awssdk.services.ssm.model.ParameterType;

public class AWSParameterStoreEnvironmentRepositoryUnitTest {
    private static final Map<String, String> SHARED_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.root", "warn");
            this.put("spring.cache.redis.time-to-live", "0");
        }
    };
    private static final Map<String, String> SHARED_DEFAULT_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.root", "error");
            this.put("spring.cache.redis.time-to-live", "1000");
        }
    };
    private final SsmClient ssmClient = (SsmClient)Mockito.mock(SsmClient.class, (String)"aws-ssm-client-mock");
    private final ConfigServerProperties configServerProperties = new ConfigServerProperties();
    private final AwsParameterStoreEnvironmentProperties environmentProperties = new AwsParameterStoreEnvironmentProperties();
    private final AwsParameterStoreEnvironmentRepository repository = new AwsParameterStoreEnvironmentRepository(this.ssmClient, this.configServerProperties, this.environmentProperties);

    @Test
    public void testFindOneWithPaginatedAwsSsmClientResponse() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        this.environmentProperties.setMaxResults(1);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.setupAwsSsmClientMocks(expected, false, true);
        Environment result = this.repository.findOne(application, profile, null);
        AssertionsForClassTypes.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    private void setupAwsSsmClientMocks(Environment environment, boolean withSlashesForPropertyName, boolean paginatedResponse) {
        for (PropertySource ps : environment.getPropertySources()) {
            String path = StringUtils.delete((String)ps.getName(), (String)this.environmentProperties.getOrigin());
            GetParametersByPathRequest request = (GetParametersByPathRequest)GetParametersByPathRequest.builder().path(path).recursive(Boolean.valueOf(this.environmentProperties.isRecursive())).withDecryption(Boolean.valueOf(this.environmentProperties.isDecryptValues())).maxResults(Integer.valueOf(this.environmentProperties.getMaxResults())).build();
            Set<Parameter> parameters = this.getParameters(ps, path, withSlashesForPropertyName);
            GetParametersByPathResponse response = (GetParametersByPathResponse)GetParametersByPathResponse.builder().parameters(parameters).build();
            if (paginatedResponse && this.environmentProperties.getMaxResults() < parameters.size()) {
                List<Set<Parameter>> chunks = this.splitParametersIntoChunks(parameters);
                String nextToken = null;
                for (int i = 0; i < chunks.size(); ++i) {
                    Set<Parameter> chunk = chunks.get(i);
                    if (i == 0) {
                        nextToken = this.generateNextToken();
                        GetParametersByPathResponse responseClone = (GetParametersByPathResponse)response.toBuilder().parameters(chunk).nextToken(nextToken).build();
                        Mockito.when((Object)this.ssmClient.getParametersByPath((GetParametersByPathRequest)ArgumentMatchers.eq((Object)request))).thenReturn((Object)responseClone);
                        continue;
                    }
                    if (i == chunks.size() - 1) {
                        GetParametersByPathRequest requestClone = (GetParametersByPathRequest)request.toBuilder().nextToken(nextToken).build();
                        GetParametersByPathResponse responseClone = (GetParametersByPathResponse)response.toBuilder().parameters(chunk).build();
                        Mockito.when((Object)this.ssmClient.getParametersByPath((GetParametersByPathRequest)ArgumentMatchers.eq((Object)requestClone))).thenReturn((Object)responseClone);
                        continue;
                    }
                    String newNextToken = this.generateNextToken();
                    GetParametersByPathRequest requestClone = (GetParametersByPathRequest)request.toBuilder().nextToken(nextToken).build();
                    GetParametersByPathResponse responseClone = (GetParametersByPathResponse)response.toBuilder().parameters(chunk).nextToken(newNextToken).build();
                    Mockito.when((Object)this.ssmClient.getParametersByPath((GetParametersByPathRequest)ArgumentMatchers.eq((Object)requestClone))).thenReturn((Object)responseClone);
                    nextToken = newNextToken;
                }
                continue;
            }
            Mockito.when((Object)this.ssmClient.getParametersByPath((GetParametersByPathRequest)ArgumentMatchers.eq((Object)request))).thenReturn((Object)response);
        }
    }

    private Set<Parameter> getParameters(PropertySource propertySource, String path, boolean withSlashesForPropertyName) {
        Function<Map.Entry, Parameter> mapper = p -> (Parameter)Parameter.builder().name(path + (withSlashesForPropertyName ? ((String)p.getKey()).replace(".", "/") : p.getKey())).type(ParameterType.STRING).value((String)p.getValue()).version(Long.valueOf(1L)).build();
        return propertySource.getSource().entrySet().stream().map(mapper).collect(Collectors.toSet());
    }

    private List<Set<Parameter>> splitParametersIntoChunks(Set<Parameter> parameters) {
        AtomicInteger counter = new AtomicInteger();
        Collector collector = Collectors.groupingBy(p -> counter.getAndIncrement() / this.environmentProperties.getMaxResults(), Collectors.toSet());
        return new ArrayList<Set<Parameter>>(parameters.stream().collect(collector).values());
    }

    private String generateNextToken() {
        String random = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        return Base64.getEncoder().encodeToString(random.getBytes(StandardCharsets.UTF_8));
    }
}

