/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepository;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepositoryFactory;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.Parameter;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;

@Testcontainers
@Tag(value="DockerRequired")
public class AwsParameterStoreEnvironmentRepositoryTests {
    @Container
    private static final LocalStackContainer localstack = new LocalStackContainer(DockerImageName.parse((String)"localstack/localstack:1.3.1")).withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.SSM});
    private final StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey()));
    private final SsmClient ssmClient = (SsmClient)((SsmClientBuilder)((SsmClientBuilder)((SsmClientBuilder)SsmClient.builder().region(Region.of((String)localstack.getRegion()))).credentialsProvider((AwsCredentialsProvider)this.staticCredentialsProvider)).endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.SSM))).build();
    private final ConfigServerProperties configServerProperties = new ConfigServerProperties();
    private final AwsParameterStoreEnvironmentProperties environmentProperties = new AwsParameterStoreEnvironmentProperties();
    private final AwsParameterStoreEnvironmentRepository repository = new AwsParameterStoreEnvironmentRepository(this.ssmClient, this.configServerProperties, this.environmentProperties);
    private final List<String> toBeRemoved = new ArrayList<String>();
    private final Map<String, String> SHARED_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.root", "warn");
            this.put("spring.cache.redis.time-to-live", "0");
        }
    };
    private final Map<String, String> SHARED_DEFAULT_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.root", "error");
            this.put("spring.cache.redis.time-to-live", "1000");
        }
    };
    private final Map<String, String> SHARED_PRODUCTION_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.root", "fatal");
            this.put("spring.cache.redis.time-to-live", "5000");
        }
    };
    private final Map<String, String> APPLICATION_SPECIFIC_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.com.example.service", "trace");
            this.put("spring.cache.redis.time-to-live", "30000");
        }
    };
    private final Map<String, String> APPLICATION_SPECIFIC_DEFAULT_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.com.example.service", "debug");
            this.put("spring.cache.redis.time-to-live", "60000");
        }
    };
    private final Map<String, String> APPLICATION_SPECIFIC_PRODUCTION_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("logging.level.com.example.service", "info");
            this.put("spring.cache.redis.time-to-live", "300000");
        }
    };

    @AfterEach
    public void cleanUp() {
        this.toBeRemoved.forEach(value -> this.ssmClient.deleteParameter((DeleteParameterRequest)DeleteParameterRequest.builder().name(value).build()));
        this.toBeRemoved.clear();
    }

    @Test
    public void testFindOneWithNullApplicationAndNullProfile() {
        String application = null;
        String profile = null;
        String defaultApp = this.configServerProperties.getDefaultApplicationName();
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(defaultApp, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNullApplicationAndDefaultProfile() {
        String application = null;
        String profile = this.configServerProperties.getDefaultProfile();
        String defaultApp = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(defaultApp, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNullApplicationAndNonExistentProfile() {
        String application = null;
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String defaultApp = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String name = "aws:ssm:parameter:/config/application/";
        PropertySource ps = new PropertySource(name, this.SHARED_PROPERTIES);
        Environment expected = new Environment(defaultApp, profiles, null, null, null);
        expected.add(ps);
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNullApplicationAndExistentProfile() {
        String application = null;
        String profile = "production";
        String defaultApp = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String sharedProdParamsPsName = "aws:ssm:parameter:/config/application-production/";
        PropertySource sharedProdParamsPs = new PropertySource(sharedProdParamsPsName, this.SHARED_PRODUCTION_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(defaultApp, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedProdParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNullProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndDefaultProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNonExistentProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String name = "aws:ssm:parameter:/config/application/";
        PropertySource ps = new PropertySource(name, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.add(ps);
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndExistentProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = "production";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String sharedProdParamsPsName = "aws:ssm:parameter:/config/application-production/";
        PropertySource sharedProdParamsPs = new PropertySource(sharedProdParamsPsName, this.SHARED_PRODUCTION_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedProdParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNonExistentApplicationAndNullProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNonExistentApplicationAndDefaultProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNonExistentApplicationAndNonExistentProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String name = "aws:ssm:parameter:/config/application/";
        PropertySource ps = new PropertySource(name, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.add(ps);
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNonExistentApplicationAndExistentProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String profile = "production";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String sharedProdParamsPsName = "aws:ssm:parameter:/config/application-production/";
        PropertySource sharedProdParamsPs = new PropertySource(sharedProdParamsPsName, this.SHARED_PRODUCTION_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedProdParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithExistentApplicationAndNullProfile() {
        String application = "service";
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String appSpecificDefaultParamsPsName = "aws:ssm:parameter:/config/service-default/";
        PropertySource appSpecificDefaultParamsPs = new PropertySource(appSpecificDefaultParamsPsName, this.APPLICATION_SPECIFIC_DEFAULT_PROPERTIES);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String appSpecificParamsPsName = "aws:ssm:parameter:/config/service/";
        PropertySource appSpecificParamsPs = new PropertySource(appSpecificParamsPsName, this.APPLICATION_SPECIFIC_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(appSpecificDefaultParamsPs, sharedDefaultParamsPs, appSpecificParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithExistentApplicationAndDefaultProfile() {
        String application = "service";
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String appSpecificDefaultParamsPsName = "aws:ssm:parameter:/config/service-default/";
        PropertySource appSpecificDefaultParamsPs = new PropertySource(appSpecificDefaultParamsPsName, this.APPLICATION_SPECIFIC_DEFAULT_PROPERTIES);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String appSpecificParamsPsName = "aws:ssm:parameter:/config/service/";
        PropertySource appSpecificParamsPs = new PropertySource(appSpecificParamsPsName, this.APPLICATION_SPECIFIC_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(appSpecificDefaultParamsPs, sharedDefaultParamsPs, appSpecificParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithExistentApplicationAndNonExistentProfile() {
        String application = "service";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)33));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String appSpecificParamsPsName = "aws:ssm:parameter:/config/service/";
        PropertySource appSpecificParamsPs = new PropertySource(appSpecificParamsPsName, this.APPLICATION_SPECIFIC_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(appSpecificParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithExistentApplicationAndExistentProfile() {
        String application = "service";
        String profile = "production";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String appSpecificProdParamsPsName = "aws:ssm:parameter:/config/service-production/";
        PropertySource appSpecificProdParamsPs = new PropertySource(appSpecificProdParamsPsName, this.APPLICATION_SPECIFIC_PRODUCTION_PROPERTIES);
        String sharedProdParamsPsName = "aws:ssm:parameter:/config/application-production/";
        PropertySource sharedProdParamsPs = new PropertySource(sharedProdParamsPsName, this.SHARED_PRODUCTION_PROPERTIES);
        String appSpecificParamsPsName = "aws:ssm:parameter:/config/service/";
        PropertySource appSpecificParamsPs = new PropertySource(appSpecificParamsPsName, this.APPLICATION_SPECIFIC_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(appSpecificProdParamsPs, sharedProdParamsPs, appSpecificParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithExistentApplicationAndMultipleExistentProfiles() {
        String application = "service";
        String profile = this.configServerProperties.getDefaultProfile() + ",production";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String appSpecificProdParamsPsName = "aws:ssm:parameter:/config/service-production/";
        PropertySource appSpecificProdParamsPs = new PropertySource(appSpecificProdParamsPsName, this.APPLICATION_SPECIFIC_PRODUCTION_PROPERTIES);
        String sharedProdParamsPsName = "aws:ssm:parameter:/config/application-production/";
        PropertySource sharedProdParamsPs = new PropertySource(sharedProdParamsPsName, this.SHARED_PRODUCTION_PROPERTIES);
        String appSpecificDefaultParamsPsName = "aws:ssm:parameter:/config/service-default/";
        PropertySource appSpecificDefaultParamsPs = new PropertySource(appSpecificDefaultParamsPsName, this.APPLICATION_SPECIFIC_DEFAULT_PROPERTIES);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String appSpecificParamsPsName = "aws:ssm:parameter:/config/service/";
        PropertySource appSpecificParamsPs = new PropertySource(appSpecificParamsPsName, this.APPLICATION_SPECIFIC_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(appSpecificProdParamsPs, sharedProdParamsPs, appSpecificDefaultParamsPs, sharedDefaultParamsPs, appSpecificParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithOverrides() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        HashMap<String, String> overrides = new HashMap<String, String>(4){
            {
                this.put("logging.level.root", "boom");
                this.put("logging.level.com.example.service", "boom");
                this.put("spring.cache.redis.time-to-live", "-1");
            }
        };
        this.configServerProperties.setOverrides((Map)overrides);
        PropertySource overridesPs = new PropertySource("overrides", (Map)overrides);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(overridesPs, sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithSlashesInTheParameterKeyPath() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String sharedDefaultParamsPsName = "aws:ssm:parameter:/config/application-default/";
        PropertySource sharedDefaultParamsPs = new PropertySource(sharedDefaultParamsPsName, this.SHARED_DEFAULT_PROPERTIES);
        String sharedParamsPsName = "aws:ssm:parameter:/config/application/";
        PropertySource sharedParamsPs = new PropertySource(sharedParamsPsName, this.SHARED_PROPERTIES);
        Environment expected = new Environment(application, profiles, null, null, null);
        expected.addAll(Arrays.asList(sharedDefaultParamsPs, sharedParamsPs));
        this.putParameters(expected, true);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void testFindOneWithNoParametersInThePaths() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expected = new Environment(application, profiles, null, null, null);
        Environment result = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)result).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expected);
    }

    @Test
    public void factoryCustomizableWithRegion() {
        AwsParameterStoreEnvironmentRepositoryFactory factory = new AwsParameterStoreEnvironmentRepositoryFactory(new ConfigServerProperties());
        AwsParameterStoreEnvironmentProperties properties = new AwsParameterStoreEnvironmentProperties();
        properties.setRegion("us-east-1");
        AwsParameterStoreEnvironmentRepository repository = factory.build(properties);
        Assertions.assertThat((Object)repository).isNotNull();
    }

    @Test
    public void factoryCustomizableWithRegionAndEndpoint() {
        AwsParameterStoreEnvironmentRepositoryFactory factory = new AwsParameterStoreEnvironmentRepositoryFactory(new ConfigServerProperties());
        AwsParameterStoreEnvironmentProperties properties = new AwsParameterStoreEnvironmentProperties();
        properties.setRegion("us-east-1");
        properties.setEndpoint("https://myawsendpoint/");
        AwsParameterStoreEnvironmentRepository repository = factory.build(properties);
        Assertions.assertThat((Object)repository).isNotNull();
    }

    private void putParameters(Environment environment) {
        this.putParameters(environment, false);
    }

    private void putParameters(Environment environment, boolean withSlashesForPropertyName) {
        for (PropertySource ps : environment.getPropertySources()) {
            String path = StringUtils.delete((String)ps.getName(), (String)this.environmentProperties.getOrigin());
            Set<Parameter> parameters = this.getParameters(ps, path, withSlashesForPropertyName);
            parameters.forEach(value -> {
                this.ssmClient.putParameter((PutParameterRequest)PutParameterRequest.builder().name(value.name()).dataType("text").value(value.value()).build());
                this.toBeRemoved.add(value.name());
            });
        }
    }

    private Set<Parameter> getParameters(PropertySource propertySource, String path, boolean withSlashesForPropertyName) {
        Function<Map.Entry, Parameter> mapper = p -> (Parameter)Parameter.builder().name(path + (withSlashesForPropertyName ? ((String)p.getKey()).replace(".", "/") : p.getKey())).type(ParameterType.STRING).value((String)p.getValue()).version(Long.valueOf(1L)).build();
        return propertySource.getSource().entrySet().stream().map(mapper).collect(Collectors.toSet());
    }

    @Test
    public void testOrderPopulation() {
        int expectedOrder = Integer.MIN_VALUE;
        AwsParameterStoreEnvironmentRepositoryFactory factory = new AwsParameterStoreEnvironmentRepositoryFactory(new ConfigServerProperties());
        AwsParameterStoreEnvironmentProperties properties = new AwsParameterStoreEnvironmentProperties();
        properties.setRegion("us-east-1");
        properties.setEndpoint("https://myawsendpoint/");
        properties.setOrder(expectedOrder);
        AwsParameterStoreEnvironmentRepository repository = factory.build(properties);
        int actualOrder = repository.getOrder();
        Assertions.assertThat((int)actualOrder).isEqualTo(expectedOrder);
    }
}

