/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentRepository;
import org.springframework.cloud.config.server.environment.AwsS3EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.BucketVersioningStatus;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;

@Testcontainers
@Tag(value="DockerRequired")
public class AwsS3EnvironmentRepositoryTests {
    @Container
    private static final LocalStackContainer localstack = new LocalStackContainer(DockerImageName.parse((String)"localstack/localstack:1.3.1")).withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.S3});
    private final ConfigServerProperties server = new ConfigServerProperties();
    private final StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey()));
    private final S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)localstack.getRegion()))).credentialsProvider((AwsCredentialsProvider)this.staticCredentialsProvider)).endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.S3))).build();
    private final EnvironmentRepository envRepo = new AwsS3EnvironmentRepository(this.s3Client, "bucket1", this.server);
    private final List<String> toBeRemoved = new ArrayList<String>();
    final String yamlContent = "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n";
    final String jsonContent = "{\n \"cloudfoundry\": {\n  \"enabled\": true,\n  \"accounts\": [{\n   \"name\": \"acc1\",\n   \"user\": \"user1\",\n   \"password\": \"password1\",\n   \"api\": \"api.sys.acc1.cf-app.com\",\n   \"environment\": \"test1\"\n  }, {\n   \"name\": \"acc2\",\n   \"user\": \"user2\",\n   \"password\": \"password2\",\n   \"api\": \"api.sys.acc2.cf-app.com\",\n   \"environment\": \"test2\"\n  }]\n }\n}";
    final Properties expectedProperties = new Properties();

    public AwsS3EnvironmentRepositoryTests() {
        this.expectedProperties.put("cloudfoundry.enabled", (Object)true);
        this.expectedProperties.put("cloudfoundry.accounts[0].name", "acc1");
        this.expectedProperties.put("cloudfoundry.accounts[0].user", "user1");
        this.expectedProperties.put("cloudfoundry.accounts[0].password", "password1");
        this.expectedProperties.put("cloudfoundry.accounts[0].api", "api.sys.acc1.cf-app.com");
        this.expectedProperties.put("cloudfoundry.accounts[0].environment", "test1");
        this.expectedProperties.put("cloudfoundry.accounts[1].name", "acc2");
        this.expectedProperties.put("cloudfoundry.accounts[1].user", "user2");
        this.expectedProperties.put("cloudfoundry.accounts[1].password", "password2");
        this.expectedProperties.put("cloudfoundry.accounts[1].api", "api.sys.acc2.cf-app.com");
        this.expectedProperties.put("cloudfoundry.accounts[1].environment", "test2");
    }

    @BeforeAll
    public static void createBucket() {
        StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey()));
        S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)localstack.getRegion()))).credentialsProvider((AwsCredentialsProvider)staticCredentialsProvider)).endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.S3))).build();
        s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket("bucket1").build());
        s3Client.putBucketVersioning((PutBucketVersioningRequest)PutBucketVersioningRequest.builder().bucket("bucket1").versioningConfiguration((VersioningConfiguration)VersioningConfiguration.builder().status(BucketVersioningStatus.ENABLED).build()).build());
    }

    @AfterEach
    public void cleanUp() {
        this.toBeRemoved.forEach(value -> this.s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket("bucket1").key(value).build()));
        this.toBeRemoved.clear();
    }

    @Test
    public void failToFindNonexistentObject() {
        Environment env = this.envRepo.findOne("foo", "bar", null);
        Assertions.assertThat((List)env.getPropertySources()).isEmpty();
    }

    @Test
    public void findPropertiesObject() throws UnsupportedEncodingException {
        String propertyContent = "cloudfoundry.enabled=true\ncloudfoundry.accounts[0].name=acc1\ncloudfoundry.accounts[0].user=user1\ncloudfoundry.accounts[0].password=password1\ncloudfoundry.accounts[0].api=api.sys.acc1.cf-app.com\ncloudfoundry.accounts[0].environment=test1\ncloudfoundry.accounts[1].name=acc2\ncloudfoundry.accounts[1].user=user2\ncloudfoundry.accounts[1].password=password2\ncloudfoundry.accounts[1].api=api.sys.acc2.cf-app.com\ncloudfoundry.accounts[1].environment=test2\n";
        String versionId = this.putFiles("foo-bar.properties", propertyContent);
        this.expectedProperties.put("cloudfoundry.enabled", "true");
        Environment env = this.envRepo.findOne("foo", "bar", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "bar");
    }

    @Test
    public void findJsonObject() throws UnsupportedEncodingException {
        String versionId = this.putFiles("foo-bar.json", "{\n \"cloudfoundry\": {\n  \"enabled\": true,\n  \"accounts\": [{\n   \"name\": \"acc1\",\n   \"user\": \"user1\",\n   \"password\": \"password1\",\n   \"api\": \"api.sys.acc1.cf-app.com\",\n   \"environment\": \"test1\"\n  }, {\n   \"name\": \"acc2\",\n   \"user\": \"user2\",\n   \"password\": \"password2\",\n   \"api\": \"api.sys.acc2.cf-app.com\",\n   \"environment\": \"test2\"\n  }]\n }\n}");
        Environment env = this.envRepo.findOne("foo", "bar", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "bar");
    }

    @Test
    public void findYamlObject() throws UnsupportedEncodingException {
        String versionId = this.putFiles("foo-bar.yaml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", "bar", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "bar");
    }

    @Test
    public void findYmlObject() throws UnsupportedEncodingException {
        String versionId = this.putFiles("foo-bar.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", "bar", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "bar");
    }

    @Test
    public void findWithDefaultProfile() throws UnsupportedEncodingException {
        String versionId = this.putFiles("foo.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", null, null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "default");
    }

    @Test
    public void findWithDefaultProfileUsingSuffix() throws UnsupportedEncodingException {
        String versionId = this.putFiles("foo-default.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", null, null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "default");
    }

    @Test
    public void findWithMultipleProfilesAllFound() throws UnsupportedEncodingException {
        this.putFiles("foo-profile1.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        String versionId = this.putFiles("foo-profile2.yml", "{\n \"cloudfoundry\": {\n  \"enabled\": true,\n  \"accounts\": [{\n   \"name\": \"acc1\",\n   \"user\": \"user1\",\n   \"password\": \"password1\",\n   \"api\": \"api.sys.acc1.cf-app.com\",\n   \"environment\": \"test1\"\n  }, {\n   \"name\": \"acc2\",\n   \"user\": \"user2\",\n   \"password\": \"password2\",\n   \"api\": \"api.sys.acc2.cf-app.com\",\n   \"environment\": \"test2\"\n  }]\n }\n}");
        Environment env = this.envRepo.findOne("foo", "profile1,profile2", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 2, "profile1", "profile2");
    }

    @Test
    public void findWithMultipleProfilesOneFound() throws UnsupportedEncodingException {
        String versionId = this.putFiles("foo-profile2.yml", "{\n \"cloudfoundry\": {\n  \"enabled\": true,\n  \"accounts\": [{\n   \"name\": \"acc1\",\n   \"user\": \"user1\",\n   \"password\": \"password1\",\n   \"api\": \"api.sys.acc1.cf-app.com\",\n   \"environment\": \"test1\"\n  }, {\n   \"name\": \"acc2\",\n   \"user\": \"user2\",\n   \"password\": \"password2\",\n   \"api\": \"api.sys.acc2.cf-app.com\",\n   \"environment\": \"test2\"\n  }]\n }\n}");
        Environment env = this.envRepo.findOne("foo", "profile1,profile2", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "profile1", "profile2");
    }

    @Test
    public void findWithOneProfileDefaultOneFound() throws UnsupportedEncodingException {
        this.putFiles("foo-profile1.yml", "{\n \"cloudfoundry\": {\n  \"enabled\": true,\n  \"accounts\": [{\n   \"name\": \"acc1\",\n   \"user\": \"user1\",\n   \"password\": \"password1\",\n   \"api\": \"api.sys.acc1.cf-app.com\",\n   \"environment\": \"test1\"\n  }, {\n   \"name\": \"acc2\",\n   \"user\": \"user2\",\n   \"password\": \"password2\",\n   \"api\": \"api.sys.acc2.cf-app.com\",\n   \"environment\": \"test2\"\n  }]\n }\n}");
        String versionId = this.putFiles("foo.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", "profile1", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 2, "profile1");
    }

    @Test
    public void findWithNoProfileAndNoServerDefaultOneFound() throws UnsupportedEncodingException {
        this.server.setDefaultProfile(null);
        String versionId = this.putFiles("foo.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", null, null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, new String[0]);
    }

    @Test
    public void findWithLabel() throws UnsupportedEncodingException {
        String versionId = this.putFiles("label1/foo-bar.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", "bar", "label1");
        this.assertExpectedEnvironment(env, "foo", "label1", versionId, 1, "bar");
    }

    @Test
    public void findWithVersion() throws UnsupportedEncodingException {
        String versionId = this.putFiles("foo-bar.yml", "cloudfoundry:\n  enabled: true\n  accounts:\n    - name: acc1\n      user: 'user1'\n      password: 'password1'\n      api: api.sys.acc1.cf-app.com\n      environment: test1\n    - name: acc2\n      user: 'user2'\n      password: 'password2'\n      api: api.sys.acc2.cf-app.com\n      environment: test2\n");
        Environment env = this.envRepo.findOne("foo", "bar", null);
        this.assertExpectedEnvironment(env, "foo", null, versionId, 1, "bar");
    }

    @Test
    public void findWithMultipleApplicationAllFound() throws UnsupportedEncodingException {
        this.putFiles("foo-profile1.yml", "{\n \"cloudfoundry\": {\n  \"enabled\": true,\n  \"accounts\": [{\n   \"name\": \"acc1\",\n   \"user\": \"user1\",\n   \"password\": \"password1\",\n   \"api\": \"api.sys.acc1.cf-app.com\",\n   \"environment\": \"test1\"\n  }, {\n   \"name\": \"acc2\",\n   \"user\": \"user2\",\n   \"password\": \"password2\",\n   \"api\": \"api.sys.acc2.cf-app.com\",\n   \"environment\": \"test2\"\n  }]\n }\n}");
        String versionId = this.putFiles("bar-profile1.yml", "{\n \"cloudfoundry\": {\n  \"enabled\": true,\n  \"accounts\": [{\n   \"name\": \"acc1\",\n   \"user\": \"user1\",\n   \"password\": \"password1\",\n   \"api\": \"api.sys.acc1.cf-app.com\",\n   \"environment\": \"test1\"\n  }, {\n   \"name\": \"acc2\",\n   \"user\": \"user2\",\n   \"password\": \"password2\",\n   \"api\": \"api.sys.acc2.cf-app.com\",\n   \"environment\": \"test2\"\n  }]\n }\n}");
        Environment env = this.envRepo.findOne("foo,bar", "profile1", null);
        this.assertExpectedEnvironment(env, "foo,bar", null, versionId, 2, "profile1");
    }

    @Test
    public void factoryCustomizable() {
        AwsS3EnvironmentRepositoryFactory factory = new AwsS3EnvironmentRepositoryFactory(new ConfigServerProperties());
        AwsS3EnvironmentProperties properties = new AwsS3EnvironmentProperties();
        properties.setRegion("us-east-1");
        properties.setEndpoint("https://myawsendpoint/");
        AwsS3EnvironmentRepository repository = factory.build(properties);
        Assertions.assertThat((Object)repository).isNotNull();
    }

    @Test
    public void getLocationsTest() {
        AwsS3EnvironmentRepositoryFactory factory = new AwsS3EnvironmentRepositoryFactory(new ConfigServerProperties());
        AwsS3EnvironmentProperties properties = new AwsS3EnvironmentProperties();
        properties.setRegion("us-east-1");
        properties.setBucket("test");
        AwsS3EnvironmentRepository repository = factory.build(properties);
        Assertions.assertThat((Object)repository.getLocations("app", "default", "main")).isEqualTo((Object)new SearchPathLocator.Locations("app", "default", "main", null, new String[]{"s3://test/main"}));
        Assertions.assertThat((Object)repository.getLocations("app", "default", null)).isEqualTo((Object)new SearchPathLocator.Locations("app", "default", null, null, new String[]{"s3://test/"}));
        Assertions.assertThat((Object)repository.getLocations("app", "default", "")).isEqualTo((Object)new SearchPathLocator.Locations("app", "default", "", null, new String[]{"s3://test/"}));
        ConfigServerProperties configServerProperties = new ConfigServerProperties();
        configServerProperties.setDefaultLabel("defaultlabel");
        factory = new AwsS3EnvironmentRepositoryFactory(configServerProperties);
        repository = factory.build(properties);
        Assertions.assertThat((Object)repository.getLocations("app", "default", null)).isEqualTo((Object)new SearchPathLocator.Locations("app", "default", "defaultlabel", null, new String[]{"s3://test/defaultlabel"}));
        Assertions.assertThat((Object)repository.getLocations("app", "default", "")).isEqualTo((Object)new SearchPathLocator.Locations("app", "default", "defaultlabel", null, new String[]{"s3://test/defaultlabel"}));
    }

    private String putFiles(String fileName, String propertyContent) {
        this.toBeRemoved.add(fileName);
        return this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket("bucket1").key(fileName).build(), RequestBody.fromString((String)propertyContent)).versionId();
    }

    private void assertExpectedEnvironment(Environment env, String applicationName, String label, String versionId, int propertySourceCount, String ... profiles) {
        Assertions.assertThat((String)env.getName()).isEqualTo(applicationName);
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)profiles);
        Assertions.assertThat((String)env.getLabel()).isEqualTo(label);
        Assertions.assertThat((String)env.getVersion()).isEqualTo(versionId);
        Assertions.assertThat((List)env.getPropertySources()).hasSize(propertySourceCount);
        for (PropertySource ps : env.getPropertySources()) {
            Assertions.assertThat((Map)ps.getSource()).isEqualTo((Object)this.expectedProperties);
        }
    }
}

