/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentRepository;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentRepositoryFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest;

@Testcontainers
@Tag(value="DockerRequired")
public class AwsSecretsManagerEnvironmentRepositoryTests {
    @Container
    private static final LocalStackContainer localstack = new LocalStackContainer(DockerImageName.parse((String)"localstack/localstack:1.3.1")).withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.SECRETSMANAGER});
    private static final Log log = LogFactory.getLog(AwsSecretsManagerEnvironmentRepository.class);
    private final StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey()));
    private final SecretsManagerClient smClient = (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)localstack.getRegion()))).credentialsProvider((AwsCredentialsProvider)this.staticCredentialsProvider)).endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.SECRETSMANAGER))).build();
    private final ConfigServerProperties configServerProperties = new ConfigServerProperties();
    private final AwsSecretsManagerEnvironmentProperties environmentProperties = new AwsSecretsManagerEnvironmentProperties();
    private final AwsSecretsManagerEnvironmentRepository repository = new AwsSecretsManagerEnvironmentRepository(this.smClient, this.configServerProperties, this.environmentProperties);
    private final AwsSecretsManagerEnvironmentProperties labeledEnvironmentProperties = new AwsSecretsManagerEnvironmentProperties();
    private final AwsSecretsManagerEnvironmentRepository labeledRepository = new AwsSecretsManagerEnvironmentRepository(this.smClient, this.configServerProperties, this.labeledEnvironmentProperties);
    private final AwsSecretsManagerEnvironmentProperties ignoreLabelEnvironmentProperties = new AwsSecretsManagerEnvironmentProperties(){
        {
            this.setIgnoreLabel(true);
        }
    };
    private final AwsSecretsManagerEnvironmentRepository ignoreLabelRepository = new AwsSecretsManagerEnvironmentRepository(this.smClient, this.configServerProperties, this.ignoreLabelEnvironmentProperties);
    private final ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
    private final List<String> toBeRemoved = new ArrayList<String>();
    private final List<String> markedForDeletion = new ArrayList<String>();

    private static Map<String, String> getFooProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-s3");
                this.put("s3.secretKey", "ce945da2-740a-4915-a090-2978428dad05");
            }
        };
    }

    private static Map<String, String> getFooDefaultProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-default-s3");
                this.put("s3.secretKey", "8c3c58c9-daef-4d21-96b0-c2b68a7a8234");
            }
        };
    }

    private static Map<String, String> getFooProdProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-prod-s3");
                this.put("s3.secretKey", "42ca062d-8e4b-435e-9e4a-d058835817c0");
            }
        };
    }

    private static Map<String, String> getFooEastProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-east-s3");
                this.put("s3.secretKey", "657f6ac5-2e1c-487d-9d61-1df109b29edf");
            }
        };
    }

    private static Map<String, String> getApplicationDefaultProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-shared-default-s3");
                this.put("s3.secretKey", "691972aa-68d2-4e55-8d9b-eedd4c63a998");
            }
        };
    }

    private static Map<String, String> getApplicationProdProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-shared-prod-s3");
                this.put("s3.secretKey", "90c1dd88-5b20-41fa-a4e9-e1d638188732");
            }
        };
    }

    private static Map<String, String> getApplicationEastProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-east-s3");
                this.put("s3.secretKey", "236e01a7-623b-40f4-88c1-eb4d89229dd6");
            }
        };
    }

    private static Map<String, String> getApplicationProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-shared-s3");
                this.put("s3.secretKey", "25300773-eb3b-4ace-b6fc-500c87331da7");
            }
        };
    }

    private static Map<String, String> getApplicationReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-shared-s3");
                this.put("s3.secretKey", "f616d232-e777-11ec-8fea-0242ac120002");
            }
        };
    }

    private static Map<String, String> getApplicationDefaultReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-shared-default-s3");
                this.put("s3.secretKey", "02db4214-e778-11ec-8fea-0242ac120002");
            }
        };
    }

    private static Map<String, String> getApplicationProdReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-shared-prod-s3");
                this.put("s3.secretKey", "db0d3eae-e78b-11ec-8fea-0242ac120002");
            }
        };
    }

    private static Map<String, String> getApplicationEastReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "application-east-s3");
                this.put("s3.secretKey", "e7e99834-e78b-11ec-8fea-0242ac120002");
            }
        };
    }

    private static Map<String, String> getFooReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-s3");
                this.put("s3.secretKey", "edec8728-e78b-11ec-8fea-0242ac120002");
            }
        };
    }

    private static Map<String, String> getFooDefaultReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-default-s3");
                this.put("s3.secretKey", "f3ebef4c-e78b-11ec-8fea-0242ac120002");
            }
        };
    }

    private static Map<String, String> getFooProdReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-prod-s3");
                this.put("s3.secretKey", "004ba75a-e78c-11ec-8fea-0242ac120002");
            }
        };
    }

    private static Map<String, String> getFooEastReleaseProperties() {
        return new HashMap<String, String>(){
            {
                this.put("s3.accessKey", "foo-east-s3");
                this.put("s3.secretKey", "044f287c-e78c-11ec-8fea-0242ac120002");
            }
        };
    }

    @AfterEach
    public void cleanUp() {
        this.markedForDeletion.forEach(value -> this.smClient.restoreSecret((RestoreSecretRequest)RestoreSecretRequest.builder().secretId(value).build()));
        this.markedForDeletion.clear();
        this.toBeRemoved.forEach(value -> this.smClient.deleteSecret((DeleteSecretRequest)DeleteSecretRequest.builder().secretId(value).forceDeleteWithoutRecovery(Boolean.valueOf(true)).build()));
        this.toBeRemoved.clear();
    }

    @Test
    public void testFindOneWithNullApplicationAndNonExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndDefaultProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = this.configServerProperties.getDefaultProfile();
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = "prod";
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNullProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndDefaultProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNonExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNullProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndDefaultProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNonExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNullProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndDefaultProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileForFooAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndNoDefaultProfilesAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod,east";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooEastPropertiesName = "aws:secrets:/secret/foo-east/";
        PropertySource fooEastProperties = new PropertySource(fooEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooEastProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        String applicationEastPropertiesName = "aws:secrets:/secret/application-east/";
        PropertySource applicationEastProperties = new PropertySource(applicationEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationEastProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooEastProperties, applicationEastProperties, fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfileAndNoDefaultsAndNullLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod,east";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooEastPropertiesName = "aws:secrets:/secret/foo-east/";
        PropertySource fooEastProperties = new PropertySource(fooEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooEastProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        String applicationEastPropertiesName = "aws:secrets:/secret/application-east/";
        PropertySource applicationEastProperties = new PropertySource(applicationEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationEastProperties());
        Environment expectedEnv = new Environment(application, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooEastProperties, applicationEastProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndNullProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = null;
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndNonExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndDefaultProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = this.configServerProperties.getDefaultProfile();
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = "prod";
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNullProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = null;
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndDefaultProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNonExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = "prod";
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNullProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = null;
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndDefaultProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = this.configServerProperties.getDefaultProfile();
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNonExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = "prod";
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNullProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = null;
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndDefaultProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = this.configServerProperties.getDefaultProfile();
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileForFooAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod";
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndNoDefaultProfilesAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod";
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfileAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod,east";
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfileAndNoDefaultsAndNonExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod,east";
        String label = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndNullProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = null;
        String label = "release";
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndNonExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String label = "release";
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndDefaultProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = this.configServerProperties.getDefaultProfile();
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String label = "release";
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = "prod";
        String label = "release";
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNullProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = null;
        String label = "release";
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndDefaultProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNonExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = "prod";
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNullProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = null;
        String label = "release";
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndDefaultProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = this.configServerProperties.getDefaultProfile();
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNonExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = "prod";
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNullProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = null;
        String label = "release";
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndDefaultProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = this.configServerProperties.getDefaultProfile();
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileForFooAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod";
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdReleaseProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultReleaseProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndNoDefaultProfilesAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod";
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdReleaseProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfileAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod,east";
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdReleaseProperties());
        String fooEastPropertiesName = "aws:secrets:/secret/foo-east/";
        PropertySource fooEastProperties = new PropertySource(fooEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooEastReleaseProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultReleaseProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        String applicationEastPropertiesName = "aws:secrets:/secret/application-east/";
        PropertySource applicationEastProperties = new PropertySource(applicationEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationEastReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooEastProperties, applicationEastProperties, fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfileAndNoDefaultsAndExistingLabelWhenDefaultLabelIsSet() {
        String application = "foo";
        String profile = "prod,east";
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdReleaseProperties());
        String fooEastPropertiesName = "aws:secrets:/secret/foo-east/";
        PropertySource fooEastProperties = new PropertySource(fooEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooEastReleaseProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        String applicationEastPropertiesName = "aws:secrets:/secret/application-east/";
        PropertySource applicationEastProperties = new PropertySource(applicationEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationEastReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, label, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooEastProperties, applicationEastProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndExistingLabelWhenIgnoreLabelIsSet() {
        String application = "foo";
        String profile = "prod";
        String label = "release";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdReleaseProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooReleaseProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultReleaseProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdReleaseProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultReleaseProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationReleaseProperties());
        Environment expectedEnv = new Environment(application, profiles, null, null, null);
        expectedEnv.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.ignoreLabelRepository.findOne(application, profile, label);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndNullProfile() {
        String application = null;
        String profile = null;
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(defaultApplication, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNullApplicationAndNullProfileAndNullLabelWhenDefaultLabelIsSet() {
        String application = null;
        String profile = null;
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String defaultLabel = this.labeledEnvironmentProperties.getDefaultLabel();
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment expectedEnv = new Environment(defaultApplication, profiles, defaultLabel, null, null);
        expectedEnv.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(expectedEnv);
        Environment resultEnv = this.labeledRepository.findOne(application, profile, defaultLabel);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)expectedEnv);
    }

    @Test
    public void testFindOneWithNullApplicationAndNonExistingProfile() {
        String application = null;
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(defaultApplication, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNullApplicationAndDefaultProfile() {
        String application = null;
        String profile = this.configServerProperties.getDefaultProfile();
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(defaultApplication, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNullApplicationAndExistingProfile() {
        String application = null;
        String profile = "prod";
        String defaultApplication = this.configServerProperties.getDefaultApplicationName();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(defaultApplication, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNullProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndDefaultProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndNonExistingProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithDefaultApplicationAndExistingProfile() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNullProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndDefaultProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndNonExistingProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNonExistingApplicationAndExistingProfile() {
        String application = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)3, (int)25));
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationProdProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNullProfile() {
        String application = "foo";
        String profile = null;
        String defaultProfile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)defaultProfile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndDefaultProfile() {
        String application = "foo";
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfile() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfile() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileForFoo() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfile() {
        String application = "foo";
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndExistingProfileAndNoDefaultProfiles() {
        String application = "foo";
        String profile = "prod";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfile() {
        String application = "foo";
        String profile = "prod,east";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooEastPropertiesName = "aws:secrets:/secret/foo-east/";
        PropertySource fooEastProperties = new PropertySource(fooEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooEastProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String fooDefaultPropertiesName = "aws:secrets:/secret/foo-default/";
        PropertySource fooDefaultProperties = new PropertySource(fooDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooDefaultProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        String applicationEastPropertiesName = "aws:secrets:/secret/application-east/";
        PropertySource applicationEastProperties = new PropertySource(applicationEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationEastProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooEastProperties, applicationEastProperties, fooDefaultProperties, applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndMultipleExistingProfileAndNoDefaults() {
        String application = "foo";
        String profile = "prod,east";
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooProdPropertiesName = "aws:secrets:/secret/foo-prod/";
        PropertySource fooProdProperties = new PropertySource(fooProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProdProperties());
        String fooEastPropertiesName = "aws:secrets:/secret/foo-east/";
        PropertySource fooEastProperties = new PropertySource(fooEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooEastProperties());
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationProdPropertiesName = "aws:secrets:/secret/application-prod/";
        PropertySource applicationProdProperties = new PropertySource(applicationProdPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProdProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        String applicationEastPropertiesName = "aws:secrets:/secret/application-east/";
        PropertySource applicationEastProperties = new PropertySource(applicationEastPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationEastProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(fooProdProperties, applicationProdProperties, fooEastProperties, applicationEastProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithOverrides() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        HashMap<String, String> overrides = new HashMap<String, String>(4){
            {
                this.put("s3.accessKey", "override-s3");
                this.put("s3.secretKey", "e7437a7d-dfa0-48a4-86d6-668fc0c157a7");
            }
        };
        this.configServerProperties.setOverrides((Map)overrides);
        PropertySource overrideProperties = new PropertySource("overrides", (Map)overrides);
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(overrideProperties, applicationDefaultProperties, applicationProperties));
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithNoSecretsStored() {
        String application = this.configServerProperties.getDefaultApplicationName();
        String profile = this.configServerProperties.getDefaultProfile();
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment environment = new Environment(application, profiles, null, null, null);
        this.putSecrets(environment);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)environment);
    }

    @Test
    public void testFindOneWithExistingApplicationAndNonExistingProfileAndNoDefaultProfileForFooMarkedForDeletion() {
        String application = "foo";
        String profile = RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)2, (int)25));
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        String fooPropertiesName = "aws:secrets:/secret/foo/";
        PropertySource fooProperties = new PropertySource(fooPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getFooProperties());
        String applicationDefaultPropertiesName = "aws:secrets:/secret/application-default/";
        PropertySource applicationDefaultProperties = new PropertySource(applicationDefaultPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationDefaultProperties());
        String applicationPropertiesName = "aws:secrets:/secret/application/";
        PropertySource applicationProperties = new PropertySource(applicationPropertiesName, AwsSecretsManagerEnvironmentRepositoryTests.getApplicationProperties());
        Environment environment = new Environment(application, profiles, null, null, null);
        environment.addAll(Arrays.asList(applicationDefaultProperties, fooProperties, applicationProperties));
        this.putSecrets(environment);
        this.deleteSecrets(environment);
        Environment emptyEnvironment = new Environment(application, profiles, null, null, null);
        Environment resultEnv = this.repository.findOne(application, profile, null);
        Assertions.assertThat((Object)resultEnv).usingRecursiveComparison().withStrictTypeChecking().isEqualTo((Object)emptyEnvironment);
    }

    @Test
    public void factoryCustomizableWithRegion() {
        AwsSecretsManagerEnvironmentRepositoryFactory factory = new AwsSecretsManagerEnvironmentRepositoryFactory(new ConfigServerProperties());
        AwsSecretsManagerEnvironmentProperties properties = new AwsSecretsManagerEnvironmentProperties();
        properties.setRegion("us-east-1");
        AwsSecretsManagerEnvironmentRepository repository = factory.build(properties);
        Assertions.assertThat((Object)repository).isNotNull();
    }

    @Test
    public void factoryCustomizableWithRegionAndEndpoint() {
        AwsSecretsManagerEnvironmentRepositoryFactory factory = new AwsSecretsManagerEnvironmentRepositoryFactory(new ConfigServerProperties());
        AwsSecretsManagerEnvironmentProperties properties = new AwsSecretsManagerEnvironmentProperties();
        properties.setRegion("us-east-1");
        properties.setEndpoint("https://myawsendpoint/");
        AwsSecretsManagerEnvironmentRepository repository = factory.build(properties);
        Assertions.assertThat((Object)repository).isNotNull();
    }

    private void putSecrets(Environment environment) {
        String label = environment.getLabel() != null ? environment.getLabel() : this.environmentProperties.getDefaultLabel();
        for (PropertySource ps : environment.getPropertySources()) {
            String path = StringUtils.delete((String)ps.getName(), (String)this.environmentProperties.getOrigin());
            String secrets = this.getSecrets(ps);
            CreateSecretResponse response = this.smClient.createSecret((CreateSecretRequest)CreateSecretRequest.builder().name(path).secretString(secrets).build());
            if (!ObjectUtils.isEmpty((Object)label)) {
                this.smClient.updateSecretVersionStage((UpdateSecretVersionStageRequest)UpdateSecretVersionStageRequest.builder().secretId(path).moveToVersionId(response.versionId()).versionStage(label).build());
            }
            this.toBeRemoved.add(path);
        }
    }

    private void deleteSecrets(Environment environment) {
        for (PropertySource ps : environment.getPropertySources()) {
            String path = StringUtils.delete((String)ps.getName(), (String)this.environmentProperties.getOrigin());
            this.smClient.deleteSecret((DeleteSecretRequest)DeleteSecretRequest.builder().secretId(path).recoveryWindowInDays(Long.valueOf(30L)).build());
            this.markedForDeletion.add(path);
        }
    }

    private String getSecrets(PropertySource ps) {
        Map map = ps.getSource();
        try {
            return this.objectMapper.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            log.error((Object)"Unable to generate secret string", (Throwable)e);
            return "";
        }
    }
}

