/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.CompositeConfiguration;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.RepositoryException;
import org.springframework.cloud.config.server.environment.SearchPathCompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;

public class CompositeEnvironmentRepositoryTests {
    @Test
    public void testOrder() {
        PropertySource p1 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p1").when((Object)p1)).getName();
        PropertySource p2 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p2").when((Object)p2)).getName();
        PropertySource p3 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p3").when((Object)p3)).getName();
        PropertySource p4 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p4").when((Object)p4)).getName();
        PropertySource p5 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p5").when((Object)p5)).getName();
        String sLoc1 = "loc1";
        String sLoc2 = "loc2";
        String sLoc3 = "loc3";
        String sLoc4 = "loc4";
        String sLoc5 = "loc5";
        Environment e1 = new Environment("app", new String[]{"dev"});
        e1.add(p1);
        e1.add(p5);
        Environment e2 = new Environment("app", new String[]{"dev"});
        e2.add(p2);
        Environment e3 = new Environment("app", new String[]{"dev"});
        e3.add(p3);
        e3.add(p4);
        SearchPathLocator.Locations loc1 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc1});
        SearchPathLocator.Locations loc2 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc5, sLoc4});
        SearchPathLocator.Locations loc3 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc3, sLoc2});
        ArrayList<TestOrderedEnvironmentRepository> repos = new ArrayList<TestOrderedEnvironmentRepository>();
        repos.add(new TestOrderedEnvironmentRepository(3, e1, loc1));
        repos.add(new TestOrderedEnvironmentRepository(2, e3, loc2));
        repos.add(new TestOrderedEnvironmentRepository(1, e2, loc3));
        SearchPathCompositeEnvironmentRepository compositeRepo = new SearchPathCompositeEnvironmentRepository(repos, ObservationRegistry.NOOP, true);
        Environment compositeEnv = compositeRepo.findOne("foo", "bar", "world", false);
        List propertySources = compositeEnv.getPropertySources();
        Assertions.assertThat((List)propertySources).hasSize(5);
        Assertions.assertThat((String)((PropertySource)propertySources.get(0)).getName()).isEqualTo("p2");
        Assertions.assertThat((String)((PropertySource)propertySources.get(1)).getName()).isEqualTo("p3");
        Assertions.assertThat((String)((PropertySource)propertySources.get(2)).getName()).isEqualTo("p4");
        Assertions.assertThat((String)((PropertySource)propertySources.get(3)).getName()).isEqualTo("p1");
        Assertions.assertThat((String)((PropertySource)propertySources.get(4)).getName()).isEqualTo("p5");
        SearchPathLocator.Locations locations = compositeRepo.getLocations("app", "dev", "label");
        String[] locationStrings = locations.getLocations();
        Assertions.assertThat((int)locationStrings.length).isEqualTo(5);
        Assertions.assertThat((String)locationStrings[0]).isEqualTo(sLoc3);
        Assertions.assertThat((String)locationStrings[1]).isEqualTo(sLoc2);
        Assertions.assertThat((String)locationStrings[2]).isEqualTo(sLoc5);
        Assertions.assertThat((String)locationStrings[3]).isEqualTo(sLoc4);
        Assertions.assertThat((String)locationStrings[4]).isEqualTo(sLoc1);
    }

    @Test
    public void testVersion() {
        PropertySource p1 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p1").when((Object)p1)).getName();
        PropertySource p2 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p2").when((Object)p2)).getName();
        String sLoc1 = "loc1";
        String sLoc2 = "loc2";
        Environment e1 = new Environment("app", new String[]{"dev"});
        e1.add(p1);
        e1.setVersion("1");
        e1.setState("state");
        Environment e2 = new Environment("app", new String[]{"dev"});
        e2.add(p2);
        e2.setVersion("2");
        e2.setState("state2");
        SearchPathLocator.Locations loc1 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc1});
        SearchPathLocator.Locations loc2 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc1, sLoc2});
        ArrayList<TestOrderedEnvironmentRepository> repos = new ArrayList<TestOrderedEnvironmentRepository>();
        repos.add(new TestOrderedEnvironmentRepository(3, e1, loc1));
        ArrayList<TestOrderedEnvironmentRepository> repos2 = new ArrayList<TestOrderedEnvironmentRepository>();
        repos2.add(new TestOrderedEnvironmentRepository(3, e1, loc1));
        repos2.add(new TestOrderedEnvironmentRepository(3, e2, loc2));
        SearchPathCompositeEnvironmentRepository compositeRepo = new SearchPathCompositeEnvironmentRepository(repos, ObservationRegistry.NOOP, true);
        SearchPathCompositeEnvironmentRepository multiCompositeRepo = new SearchPathCompositeEnvironmentRepository(repos2, ObservationRegistry.NOOP, true);
        Environment env = compositeRepo.findOne("app", "dev", "label", false);
        Assertions.assertThat((String)env.getVersion()).isEqualTo("1");
        Assertions.assertThat((String)env.getState()).isEqualTo("state");
        Environment multiEnv = multiCompositeRepo.findOne("app", "dev", "label", false);
        Assertions.assertThat((String)multiEnv.getVersion()).isEqualTo(null);
        Assertions.assertThat((String)multiEnv.getState()).isEqualTo(null);
    }

    @Test
    public void overridingCompositeEnvRepo_contextLoads() {
        try (AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();){
            context.register(new Class[]{OverrideCompositeConfig.class, CompositeConfiguration.class, ConfigServerHealthIndicator.class});
            context.refresh();
        }
    }

    @Test
    public void testFailingSubordinateRepositorySkipped() {
        PropertySource p1 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p1").when((Object)p1)).getName();
        PropertySource p2 = (PropertySource)Mockito.mock(PropertySource.class);
        ((PropertySource)Mockito.doReturn((Object)"p2").when((Object)p2)).getName();
        String sLoc1 = "loc1";
        String sLoc2 = "loc2";
        Environment e1 = new Environment("app", new String[]{"dev"});
        e1.add(p1);
        e1.setVersion("1");
        e1.setState("state");
        Environment e2 = new Environment("app", new String[]{"dev"});
        e2.add(p2);
        e2.setVersion("2");
        e2.setState("state2");
        SearchPathLocator.Locations loc1 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc1});
        SearchPathLocator.Locations loc2 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc1, sLoc2});
        ArrayList<TestOrderedEnvironmentRepository> repos = new ArrayList<TestOrderedEnvironmentRepository>();
        repos.add(new TestOrderedEnvironmentRepository(2, e1, loc1));
        repos.add(new TestFailingEnvironmentRepository(1, e2, loc2));
        SearchPathCompositeEnvironmentRepository compositeRepo = new SearchPathCompositeEnvironmentRepository(repos, ObservationRegistry.NOOP, false);
        Environment env = compositeRepo.findOne("app", "dev", "label", false);
        List propertySources = env.getPropertySources();
        Assertions.assertThat((List)propertySources).hasSize(1);
        Assertions.assertThat((String)((PropertySource)propertySources.get(0)).getName()).isEqualTo("p1");
    }

    @Test
    public void testFailOnErrorFlagFalseForGetLocations() {
        String sLoc1 = "loc1";
        Environment e1 = new Environment("app", new String[]{"dev"});
        SearchPathLocator.Locations loc1 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc1});
        ArrayList<TestFailingLocationRepository> repos = new ArrayList<TestFailingLocationRepository>();
        repos.add(new TestFailingLocationRepository(1, e1, loc1));
        SearchPathCompositeEnvironmentRepository compositeRepo = new SearchPathCompositeEnvironmentRepository(repos, ObservationRegistry.NOOP, false);
        SearchPathLocator.Locations locations = compositeRepo.getLocations("app", "dev", "label");
        Assertions.assertThat((Object[])locations.getLocations()).isEmpty();
    }

    @Test
    public void testFailOnErrorFlagTrueForGetLocations() {
        String sLoc1 = "loc1";
        Environment e1 = new Environment("app", new String[]{"dev"});
        SearchPathLocator.Locations loc1 = new SearchPathLocator.Locations("app", "dev", "label", "version", new String[]{sLoc1});
        ArrayList<TestFailingLocationRepository> repos = new ArrayList<TestFailingLocationRepository>();
        repos.add(new TestFailingLocationRepository(1, e1, loc1));
        SearchPathCompositeEnvironmentRepository compositeRepo = new SearchPathCompositeEnvironmentRepository(repos, ObservationRegistry.NOOP, true);
        AssertionsForClassTypes.assertThatExceptionOfType(RepositoryException.class).isThrownBy(() -> compositeRepo.getLocations("app", "dev", "label"));
    }

    private static class TestOrderedEnvironmentRepository
    implements EnvironmentRepository,
    SearchPathLocator,
    Ordered {
        private Environment env;
        private SearchPathLocator.Locations locations;
        private int order = Integer.MAX_VALUE;

        TestOrderedEnvironmentRepository(int order, Environment env, SearchPathLocator.Locations locations) {
            this.order = order;
            this.env = env;
            this.locations = locations;
        }

        public Environment findOne(String application, String profile, String label) {
            return this.findOne(application, profile, label, false);
        }

        public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
            return this.env;
        }

        public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
            return this.locations;
        }

        public int getOrder() {
            return this.order;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class OverrideCompositeConfig {
        OverrideCompositeConfig() {
        }

        @Bean
        @Primary
        CompositeEnvironmentRepository customCompositeEnvironmentRepository() {
            return new CompositeEnvironmentRepository(Arrays.asList(new TestOrderedEnvironmentRepository(1, new Environment("app", new String[]{"dev"}), null)), ObservationRegistry.NOOP, true);
        }
    }

    private static class TestFailingEnvironmentRepository
    extends TestOrderedEnvironmentRepository {
        TestFailingEnvironmentRepository(int order, Environment env, SearchPathLocator.Locations locations) {
            super(order, env, locations);
        }

        @Override
        public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
            throw new IllegalArgumentException("Failing for some reason");
        }

        @Override
        public Environment findOne(String application, String profile, String label) {
            throw new IllegalArgumentException("Failing for some reason");
        }
    }

    private static class TestFailingLocationRepository
    extends TestOrderedEnvironmentRepository {
        TestFailingLocationRepository(int order, Environment env, SearchPathLocator.Locations locations) {
            super(order, env, locations);
        }

        @Override
        public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
            throw new RepositoryException("Failing for some reason");
        }
    }
}

