/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.http.apache.HttpClientConnection;
import org.junit.jupiter.api.Test;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.util.ReflectionTestUtils;

public class ConfigurableHttpConnectionFactoryIntegrationTests {
    private static final ProxyHostProperties AUTHENTICATED_HTTP_PROXY = new ProxyHostProperties();
    private static final ProxyHostProperties AUTHENTICATED_HTTPS_PROXY = new ProxyHostProperties();
    private static final ProxyHostProperties HTTP_PROXY = new ProxyHostProperties();
    private static final ProxyHostProperties HTTPS_PROXY = new ProxyHostProperties();

    @Test
    public void authenticatedHttpsProxy() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, null, AUTHENTICATED_HTTPS_PROXY)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl(repoUrl);
            this.makeRequest(httpClient, "https://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(AUTHENTICATED_HTTPS_PROXY.getHost());
    }

    @Test
    public void httpsProxy() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, null, HTTPS_PROXY)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl(repoUrl);
            this.makeRequest(httpClient, "https://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(HTTPS_PROXY.getHost());
    }

    @Test
    public void httpsProxy_placeholderUrl() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/{placeholder1}/{placeholder2}-repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, null, HTTPS_PROXY)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl("https://myrepo/someplaceholdervalue/anotherplaceholdervalue-repo.git");
            this.makeRequest(httpClient, "https://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(HTTPS_PROXY.getHost());
    }

    @Test
    public void httpsProxy_called_for_http_request_when_no_httpProxy_specified() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, null, HTTPS_PROXY)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl(repoUrl);
            this.makeRequest(httpClient, "http://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(HTTPS_PROXY.getHost());
    }

    @Test
    public void authenticatedHttpProxy() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, AUTHENTICATED_HTTP_PROXY, null)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl(repoUrl);
            this.makeRequest(httpClient, "http://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(AUTHENTICATED_HTTP_PROXY.getHost());
    }

    @Test
    public void httpProxy() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, HTTP_PROXY, null)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl(repoUrl);
            this.makeRequest(httpClient, "http://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(HTTP_PROXY.getHost());
    }

    @Test
    public void httpProxy_placeholderUrl() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/{placeholder}-repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, HTTP_PROXY, null)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl("https://myrepo/someplaceholdervalue-repo.git");
            this.makeRequest(httpClient, "http://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(HTTP_PROXY.getHost());
    }

    @Test
    public void httpProxy_called_for_https_request_when_no_httpsProxy_specified() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            String repoUrl = "https://myrepo/repo.git";
            new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(this.gitProperties(repoUrl, HTTP_PROXY, null)).run(new String[0]);
            HttpClient httpClient = this.getHttpClientForUrl(repoUrl);
            this.makeRequest(httpClient, "https://somehost");
        }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(HTTP_PROXY.getHost());
    }

    @Test
    public void httpProxy_fromSystemProperty() throws Exception {
        ProxySelector defaultProxySelector = ProxySelector.getDefault();
        try {
            Assertions.assertThatThrownBy(() -> {
                ProxySelector.setDefault(new ProxySelector(){

                    @Override
                    public List<Proxy> select(URI uri) {
                        InetSocketAddress address = new InetSocketAddress(HTTP_PROXY.getHost(), HTTP_PROXY.getPort());
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                        return Collections.singletonList(proxy);
                    }

                    @Override
                    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                    }
                });
                String repoUrl = "https://myrepo/repo.git";
                new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri=" + repoUrl}).run(new String[0]);
                HttpClient httpClient = this.getHttpClientForUrl(repoUrl);
                this.makeRequest(httpClient, "http://somehost");
            }).hasCauseInstanceOf(UnknownHostException.class).hasMessageContaining(HTTP_PROXY.getHost());
        }
        finally {
            ProxySelector.setDefault(defaultProxySelector);
        }
    }

    private String[] gitProperties(String repoUrl, ProxyHostProperties httpProxy, ProxyHostProperties httpsProxy) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add("spring.cloud.config.server.git.uri=" + repoUrl);
        if (httpProxy != null) {
            result.addAll(Arrays.asList("spring.cloud.config.server.git.proxy.http.host=" + httpProxy.getHost(), "spring.cloud.config.server.git.proxy.http.port=" + httpProxy.getPort()));
            if (httpProxy.getUsername() != null && httpProxy.getPassword() != null) {
                result.addAll(Arrays.asList("spring.cloud.config.server.git.proxy.http.username=" + httpProxy.getUsername(), "spring.cloud.config.server.git.proxy.http.password=" + httpProxy.getPassword()));
            }
        }
        if (httpsProxy != null) {
            result.addAll(Arrays.asList("spring.cloud.config.server.git.proxy.https.host=" + httpsProxy.getHost(), "spring.cloud.config.server.git.proxy.https.port=" + httpsProxy.getPort()));
            if (httpsProxy.getUsername() != null && httpsProxy.getPassword() != null) {
                result.addAll(Arrays.asList("spring.cloud.config.server.git.proxy.https.username=" + httpsProxy.getUsername(), "spring.cloud.config.server.git.proxy.https.password=" + httpsProxy.getPassword()));
            }
        }
        return result.toArray(new String[0]);
    }

    private void makeRequest(HttpClient httpClient, String url) {
        try {
            httpClient.execute((HttpUriRequest)new HttpGet(url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpClient getHttpClientForUrl(String repoUrl) throws IOException {
        HttpConnectionFactory connectionFactory = HttpTransport.getConnectionFactory();
        URL url = new URL(repoUrl);
        HttpConnection httpConnection = connectionFactory.create(url);
        Assertions.assertThat((Object)httpConnection).isInstanceOf(HttpClientConnection.class);
        return (HttpClient)ReflectionTestUtils.getField((Object)httpConnection, (String)"client");
    }

    static {
        AUTHENTICATED_HTTP_PROXY.setHost("https://authenticated.http.proxy");
        AUTHENTICATED_HTTP_PROXY.setPort(8080);
        AUTHENTICATED_HTTP_PROXY.setUsername("username");
        AUTHENTICATED_HTTP_PROXY.setPassword("password");
        AUTHENTICATED_HTTPS_PROXY.setHost("https://authenticated.https.proxy");
        AUTHENTICATED_HTTPS_PROXY.setPort(8081);
        AUTHENTICATED_HTTPS_PROXY.setUsername("username2");
        AUTHENTICATED_HTTPS_PROXY.setPassword("password2");
        HTTP_PROXY.setHost("https://http.proxy");
        HTTP_PROXY.setPort(8080);
        HTTPS_PROXY.setHost("https://https.proxy");
        HTTPS_PROXY.setPort(8081);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={PropertyPlaceholderAutoConfiguration.class, EnvironmentRepositoryConfiguration.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }
    }
}

