/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.CredhubEnvironmentRepository;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.credhub.core.credential.CredHubCredentialOperations;
import org.springframework.credhub.support.CredentialDetails;
import org.springframework.credhub.support.CredentialName;
import org.springframework.credhub.support.CredentialSummary;
import org.springframework.credhub.support.CredentialType;
import org.springframework.credhub.support.SimpleCredentialName;
import org.springframework.credhub.support.json.JsonCredential;

public class CredhubEnvironmentRepositoryTests {
    private CredhubEnvironmentRepository credhubEnvironmentRepository;
    private CredHubCredentialOperations credhubCredentialOperations;

    @BeforeEach
    public void setUp() {
        CredHubOperations credhubOperations = (CredHubOperations)Mockito.mock(CredHubOperations.class);
        this.credhubCredentialOperations = (CredHubCredentialOperations)Mockito.mock(CredHubCredentialOperations.class);
        Mockito.when((Object)credhubOperations.credentials()).thenReturn((Object)this.credhubCredentialOperations);
        this.credhubEnvironmentRepository = new CredhubEnvironmentRepository(credhubOperations);
    }

    @Test
    public void shouldDisplayEmptyPropertiesWhenNoPathFound() {
        Mockito.when((Object)this.credhubCredentialOperations.findByPath("/my-application/production/mylabel")).thenReturn(Collections.emptyList());
        Environment environment = this.credhubEnvironmentRepository.findOne("my-application", "production", "mylabel");
        Assertions.assertThat((String)environment.getName()).isEqualTo("my-application");
        Assertions.assertThat((Object[])environment.getProfiles()).containsExactly((Object[])new String[]{"production"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("mylabel");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-my-application-production-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(0)).getSource()).isEmpty();
    }

    @Test
    public void shouldRetrieveDefaultsWhenNoLabelNorProfileProvided() {
        this.stubCredentials("/my-application/default/master", "toggles", "key1", "value1");
        Environment environment = this.credhubEnvironmentRepository.findOne("my-application", null, null);
        Assertions.assertThat((String)environment.getName()).isEqualTo("my-application");
        Assertions.assertThat((Object[])environment.getProfiles()).containsExactly((Object[])new String[]{"default"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-my-application-default-master");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(0)).getSource()).isEqualTo(Collections.singletonMap("key1", "value1"));
    }

    @Test
    public void shouldRetrieveGivenProfileAndLabel() {
        this.stubCredentials("/my-application/production/mylabel", "toggles", "key1", "value1");
        Environment environment = this.credhubEnvironmentRepository.findOne("my-application", "production", "mylabel");
        Assertions.assertThat((String)environment.getName()).isEqualTo("my-application");
        Assertions.assertThat((Object[])environment.getProfiles()).containsExactly((Object[])new String[]{"production"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("mylabel");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-my-application-production-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(0)).getSource()).isEqualTo(Collections.singletonMap("key1", "value1"));
    }

    @Test
    public void shouldRetrieveGivenMultipleProfiles() {
        this.stubCredentials("/my-application/production/mylabel", "toggles", "key1", "value1");
        this.stubCredentials("/my-application/cloud/mylabel", "abs", "key2", "value2");
        Environment environment = this.credhubEnvironmentRepository.findOne("my-application", "production,cloud", "mylabel");
        Assertions.assertThat((String)environment.getName()).isEqualTo("my-application");
        Assertions.assertThat((Object[])environment.getProfiles()).containsExactly((Object[])new String[]{"production", "cloud"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("mylabel");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-my-application-production-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(0)).getSource()).isEqualTo(Collections.singletonMap("key1", "value1"));
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).isEqualTo("credhub-my-application-cloud-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(1)).getSource()).isEqualTo(Collections.singletonMap("key2", "value2"));
    }

    @Test
    public void shouldMergeWhenMoreThanOneCredentialsFound() {
        String expectedPath = "/my-application/production/mylabel";
        SimpleCredentialName togglesCredentialName = new SimpleCredentialName(new String[]{expectedPath + "/toggles"});
        SimpleCredentialName absCredentialName = new SimpleCredentialName(new String[]{expectedPath + "/abs"});
        Mockito.when((Object)this.credhubCredentialOperations.findByPath(expectedPath)).thenReturn(Arrays.asList(new CredentialSummary((CredentialName)togglesCredentialName), new CredentialSummary((CredentialName)absCredentialName)));
        JsonCredential credentials = new JsonCredential();
        credentials.put((Object)"key1", (Object)"value1");
        Mockito.when((Object)this.credhubCredentialOperations.getByName((CredentialName)togglesCredentialName, JsonCredential.class)).thenReturn((Object)new CredentialDetails("id1", (CredentialName)togglesCredentialName, CredentialType.JSON, (Object)credentials));
        JsonCredential otherCredentials = new JsonCredential();
        otherCredentials.put((Object)"key2", (Object)"value2");
        Mockito.when((Object)this.credhubCredentialOperations.getByName((CredentialName)absCredentialName, JsonCredential.class)).thenReturn((Object)new CredentialDetails("id2", (CredentialName)absCredentialName, CredentialType.JSON, (Object)otherCredentials));
        Environment environment = this.credhubEnvironmentRepository.findOne("my-application", "production", "mylabel");
        Assertions.assertThat((String)environment.getName()).isEqualTo("my-application");
        Assertions.assertThat((Object[])environment.getProfiles()).containsExactly((Object[])new String[]{"production"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("mylabel");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-my-application-production-mylabel");
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("key1", "value1");
        expectedValues.put("key2", "value2");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(0)).getSource()).isEqualTo(expectedValues);
    }

    @Test
    public void shouldIncludeDefaultApplicationWhenOtherProvided() {
        this.stubCredentials("/my-application/production/mylabel", "toggles", "key1", "value1");
        this.stubCredentials("/application/production/mylabel", "abs", "key2", "value2");
        Environment environment = this.credhubEnvironmentRepository.findOne("my-application", "production", "mylabel");
        Assertions.assertThat((String)environment.getName()).isEqualTo("my-application");
        Assertions.assertThat((Object[])environment.getProfiles()).containsExactly((Object[])new String[]{"production"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("mylabel");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-my-application-production-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(0)).getSource()).isEqualTo(Collections.singletonMap("key1", "value1"));
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).isEqualTo("credhub-application-production-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(1)).getSource()).isEqualTo(Collections.singletonMap("key2", "value2"));
    }

    @Test
    public void shouldIncludeDefaultProfileWhenOtherProvided() {
        this.stubCredentials("/my-application/production/mylabel", "toggles", "key1", "value1");
        this.stubCredentials("/application/production/mylabel", "abs", "key2", "value2");
        this.stubCredentials("/my-application/default/mylabel", "abs", "key3", "value3");
        this.stubCredentials("/application/default/mylabel", "abs", "key4", "value4");
        Environment environment = this.credhubEnvironmentRepository.findOne("my-application", "production", "mylabel");
        Assertions.assertThat((String)environment.getName()).isEqualTo("my-application");
        Assertions.assertThat((Object[])environment.getProfiles()).contains((Object[])new String[]{"production"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("mylabel");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(4);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-my-application-production-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(0)).getSource()).isEqualTo(Collections.singletonMap("key1", "value1"));
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).isEqualTo("credhub-application-production-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(1)).getSource()).isEqualTo(Collections.singletonMap("key2", "value2"));
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(2)).getName()).isEqualTo("credhub-my-application-default-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(2)).getSource()).isEqualTo(Collections.singletonMap("key3", "value3"));
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(3)).getName()).isEqualTo("credhub-application-default-mylabel");
        Assertions.assertThat((Map)((PropertySource)environment.getPropertySources().get(3)).getSource()).isEqualTo(Collections.singletonMap("key4", "value4"));
    }

    private void stubCredentials(String expectedPath, String name, String key, String value) {
        SimpleCredentialName credentialsName = new SimpleCredentialName(new String[]{expectedPath + "/" + name});
        Mockito.when((Object)this.credhubCredentialOperations.findByPath(expectedPath)).thenReturn(Collections.singletonList(new CredentialSummary((CredentialName)credentialsName)));
        JsonCredential credentials = new JsonCredential();
        credentials.put((Object)key, (Object)value);
        Mockito.when((Object)this.credhubCredentialOperations.getByName((CredentialName)new SimpleCredentialName(new String[]{expectedPath + "/" + name}), JsonCredential.class)).thenReturn((Object)new CredentialDetails("id1", (CredentialName)credentialsName, CredentialType.JSON, (Object)credentials));
    }
}

