/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.HashMap;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentController;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.NoSuchRepositoryException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

class EnvironmentControllerIntegrationTests {
    EnvironmentControllerIntegrationTests() {
    }

    @Configuration
    @Import(value={PropertyPlaceholderAutoConfiguration.class, WebMvcAutoConfiguration.class})
    static class ControllerConfiguration {
        ControllerConfiguration() {
        }

        @Bean
        EnvironmentRepository environmentRepository() {
            return (EnvironmentRepository)Mockito.mock(EnvironmentRepository.class);
        }

        @Bean
        EnvironmentController controller() {
            return new EnvironmentController(this.environmentRepository());
        }
    }

    @SpringBootTest(classes={ControllerConfiguration.class})
    @TestPropertySource(properties={"spring.mvc.pathmatch.matching-strategy=ant_path_matcher"})
    static class AntPathMatcherTests
    extends TestCases {
        AntPathMatcherTests() {
        }
    }

    @SpringBootTest(classes={ControllerConfiguration.class})
    static class PathPatternParserTests
    extends TestCases {
        PathPatternParserTests() {
        }
    }

    static abstract class TestCases {
        @Autowired
        private WebApplicationContext context;
        private MockMvc mvc;
        @Autowired
        private EnvironmentRepository repository;
        private final Environment environment = new Environment("foo", new String[]{"default"});

        TestCases() {
        }

        @BeforeEach
        public void init() {
            Mockito.reset((Object[])new EnvironmentRepository[]{this.repository});
            this.mvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).build();
            this.environment.add(new PropertySource("foo", new HashMap()));
        }

        @Test
        public void environmentNoLabel() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", null, false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
            ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", null, false);
        }

        @Test
        public void profileWithDash() throws Exception {
            Environment dashEnvironment = new Environment("foo", new String[]{"dev-db"});
            dashEnvironment.add(new PropertySource("foo", new HashMap()));
            Mockito.when((Object)this.repository.findOne("foo", "dev-db", null, false)).thenReturn((Object)dashEnvironment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/dev-db", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
            ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "dev-db", null, false);
        }

        @ParameterizedTest
        @ValueSource(strings={"yml", "yaml", "json", "properties"})
        public void profileContainingExtensionKeyword(String extensionKeyword) throws Exception {
            String profiles = "dev-" + extensionKeyword;
            Environment dashEnvironment = new Environment("foo", new String[]{profiles});
            dashEnvironment.add(new PropertySource("foo", new HashMap()));
            Mockito.when((Object)this.repository.findOne("foo", profiles, null, false)).thenReturn((Object)dashEnvironment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/foo/" + profiles), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
            ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", profiles, null, false);
        }

        @ParameterizedTest
        @ValueSource(strings={"yml", "yaml", "json", "properties"})
        public void profileHavingAnExtension(String extensionKeyword) throws Exception {
            String profiles = "dev." + extensionKeyword;
            Environment dashEnvironment = new Environment("foo", new String[]{profiles});
            dashEnvironment.add(new PropertySource("foo", new HashMap()));
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/foo/" + profiles), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
            Mockito.verifyNoInteractions((Object[])new Object[]{this.repository});
        }

        @Test
        public void propertiesNoLabel() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", null, false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo-default.properties", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
            ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", null, false);
        }

        @Test
        public void propertiesLabel() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", "label", false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/label/foo-default.properties", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
            ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", "label", false);
        }

        @Test
        public void propertiesLabelWhenApplicationNameContainsHyphen() throws Exception {
            Environment environment = new Environment("foo-bar", new String[]{"default"});
            environment.add(new PropertySource("foo", new HashMap()));
            Mockito.when((Object)this.repository.findOne("foo-bar", "default", "label", false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/label/foo-bar-default.properties", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
            ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo-bar", "default", "label", false);
        }

        @Test
        public void propertiesLabelWithSlash() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", "label/spam", false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/label(_)spam/foo-default.properties", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
            ((EnvironmentRepository)Mockito.verify((Object)this.repository)).findOne("foo", "default", "label/spam", false);
        }

        @Test
        public void environmentWithLabel() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", "awesome", false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/awesome", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        }

        @Test
        public void environmentWithMissingLabel() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", "missing", false)).thenThrow(new Throwable[]{new NoSuchLabelException("Planned")});
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/missing", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        }

        @Test
        public void environmentWithMissingRepo() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", "missing", false)).thenThrow(new Throwable[]{new NoSuchRepositoryException("Planned")});
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/missing", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        }

        @Test
        public void environmentWithLabelContainingPeriod() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", "1.0.0", false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/1.0.0", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        }

        @Test
        public void environmentWithLabelContainingSlash() throws Exception {
            Mockito.when((Object)this.repository.findOne("foo", "default", "feature/puff", false)).thenReturn((Object)this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/default/feature(_)puff", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"\"propertySources\":")));
        }

        @Test
        public void environmentWithApplicationContainingSlash() throws Exception {
            Environment environment = new Environment("foo/app", new String[]{"default"});
            environment.add(new PropertySource("foo", new HashMap()));
            Mockito.when((Object)this.repository.findOne("foo/app", "default", null, false)).thenReturn((Object)environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo(_)app/default", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)"\"propertySources\":")));
        }
    }
}

