/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentController;
import org.springframework.cloud.config.server.environment.EnvironmentNotFoundException;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.FailedToConstructEnvironmentException;
import org.springframework.cloud.config.server.environment.InvalidEnvironmentRequestException;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.web.util.pattern.PathPatternParser;
import org.yaml.snakeyaml.Yaml;

class EnvironmentControllerTests {
    private final EnvironmentRepository repository = (EnvironmentRepository)Mockito.mock(EnvironmentRepository.class);
    private EnvironmentController controller;
    private final Environment environment = new Environment("foo", new String[]{"master"});

    EnvironmentControllerTests() {
    }

    @BeforeEach
    public void init() {
        this.controller = new EnvironmentController(this.repository);
        this.environment.add(new PropertySource("foo", new HashMap()));
    }

    @AfterEach
    public void clean() {
        System.clearProperty("foo");
    }

    @Test
    public void vanillaYaml() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a.b.c", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n    c: d\n");
    }

    @Test
    public void propertyOverrideInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("a.b.c", "d");
        this.environment.add(new PropertySource("one", map));
        this.environment.addFirst(new PropertySource("two", Collections.singletonMap("a.b.c", "e")));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n    c: e\n");
    }

    @Test
    public void propertyOverrideInYamlMultipleValues() throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("A", "Y");
        map.put("S", 2);
        map.put("Y", 0);
        this.environment.add(new PropertySource("one", map));
        map = new LinkedHashMap();
        map.put("A", "Z");
        map.put("S", 3);
        this.environment.addFirst(new PropertySource("two", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("A: Z\nS: 3\nY: 0\n");
    }

    @Test
    public void placeholdersResolvedInYaml() throws Exception {
        this.whenPlaceholders();
        String yaml = (String)this.controller.yaml("foo", "bar", true).getBody();
        Map map = (Map)new Yaml().load(yaml);
        Assertions.assertThat((Map)map).containsOnlyKeys((Object[])new String[]{"a", "foo"});
        Assertions.assertThat((Map)map).containsEntry((Object)"foo", (Object)"bar");
        Map a = (Map)map.get("a");
        Assertions.assertThat((Map)a).containsOnlyKeys((Object[])new String[]{"b"});
        Map b = (Map)a.get("b");
        ((MapAssert)Assertions.assertThat((Map)b).containsOnlyKeys((Object[])new String[]{"c"})).containsEntry((Object)"c", (Object)"bar");
    }

    @Test
    public void placeholdersNotResolvedInYaml() throws Exception {
        this.whenPlaceholders();
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Map map = (Map)new Yaml().load(yaml);
        Assertions.assertThat((Map)map).containsOnlyKeys((Object[])new String[]{"a", "foo"});
        Assertions.assertThat((Map)map).containsEntry((Object)"foo", (Object)"bar");
        Map a = (Map)map.get("a");
        Assertions.assertThat((Map)a).containsOnlyKeys((Object[])new String[]{"b"});
        Map b = (Map)a.get("b");
        ((MapAssert)Assertions.assertThat((Map)b).containsOnlyKeys((Object[])new String[]{"c"})).containsEntry((Object)"c", (Object)"${foo}");
    }

    @Test
    public void placeholdersNotResolvedInYamlFromSystemProperties() throws Exception {
        this.whenPlaceholdersSystemProps();
        String yaml = (String)this.controller.yaml("foo", "bar", true).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n    c: ${foo}\n");
    }

    @Test
    public void placeholdersNotResolvedInYamlFromSystemPropertiesWhenNotFlagged() throws Exception {
        this.whenPlaceholdersSystemProps();
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n    c: ${foo}\n");
    }

    @Test
    public void placeholdersNotResolvedInYamlFromSystemPropertiesWhenNotFlaggedWithDefault() throws Exception {
        this.whenPlaceholdersSystemPropsWithDefault();
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n    c: ${foo:spam}\n");
    }

    @Test
    public void placeholdersResolvedInYamlFromSystemPropertiesWhenFlagged() throws Exception {
        this.whenPlaceholdersSystemPropsWithDefault();
        String yaml = (String)this.controller.yaml("foo", "bar", true).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n    c: spam\n");
    }

    @Test
    public void arrayInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("a.b[0]", "c");
        map.put("a.b[1]", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n  - c\n  - d\n");
    }

    @Test
    public void yamlWithBrackets() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("a.test", "e");
        map.put("a.b[hello]", "c");
        map.put("a.b[world]", "d");
        map.put("a.b[world]d", "f");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  test: e\n  b[hello]: c\n  b[world]: d\n  b[world]d: f\n");
    }

    @Test
    public void arrayOverridenInEnvironment() throws Exception {
        LinkedHashMap<String, String> oneMap = new LinkedHashMap<String, String>();
        oneMap.put("a.b[0]", "c");
        oneMap.put("a.b[1]", "d");
        oneMap.put("a.b[2]", "z");
        this.environment.add(new PropertySource("one", oneMap));
        LinkedHashMap<String, String> twoMap = new LinkedHashMap<String, String>();
        twoMap.put("a.b[0]", "f");
        twoMap.put("a.b[1]", "h");
        this.environment.addFirst(new PropertySource("two", twoMap));
        Mockito.when((Object)this.repository.findOne("foo", "bar", "two", false)).thenReturn((Object)this.environment);
        Environment environment = this.controller.labelled("foo", "bar", "two");
        Assertions.assertThat((Object)environment).isNotNull();
        Assertions.assertThat((String)environment.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])environment.getProfiles()).isEqualTo((Object)new String[]{"master"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("master");
        Assertions.assertThat((String)environment.getVersion()).isNull();
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(3);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("two");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().entrySet()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(2)).getName()).isEqualTo("one");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(2)).getSource().entrySet()).hasSize(3);
    }

    @Test
    public void testNameWithSlash() {
        Mockito.when((Object)this.repository.findOne("foo/spam", "bar", "two", false)).thenReturn((Object)this.environment);
        Environment returnedEnvironment = this.controller.labelled("foo(_)spam", "bar", "two");
        Assertions.assertThat((String)returnedEnvironment.getLabel()).isEqualTo(this.environment.getLabel());
        Assertions.assertThat((String)returnedEnvironment.getName()).isEqualTo(this.environment.getName());
    }

    @Test
    public void testEnvironmentNotFound() {
        this.controller.setAcceptEmpty(false);
        Assertions.assertThatThrownBy(() -> this.controller.labelled("foo", "bar", null)).isInstanceOf(EnvironmentNotFoundException.class);
    }

    @Test
    public void testwithValidEnvironment() {
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        Environment environment = this.controller.labelled("foo", "bar", null);
        Assertions.assertThat((Object)environment).isNotNull();
    }

    @Test
    public void testLabelWithSlash() {
        Mockito.when((Object)this.repository.findOne("foo", "bar", "two/spam", false)).thenReturn((Object)this.environment);
        Environment returnedEnvironment = this.controller.labelled("foo", "bar", "two(_)spam");
        Assertions.assertThat((String)returnedEnvironment.getLabel()).isEqualTo(this.environment.getLabel());
        Assertions.assertThat((String)returnedEnvironment.getName()).isEqualTo(this.environment.getName());
    }

    @Test
    public void arrayOverridenInYaml() throws Exception {
        LinkedHashMap<String, String> oneMap = new LinkedHashMap<String, String>();
        oneMap.put("a.b[0]", "c");
        oneMap.put("a.b[1]", "d");
        oneMap.put("a.b[2]", "z");
        this.environment.add(new PropertySource("one", oneMap));
        LinkedHashMap<String, String> twoMap = new LinkedHashMap<String, String>();
        twoMap.put("a.b[0]", "f");
        twoMap.put("a.b[1]", "h");
        this.environment.addFirst(new PropertySource("two", twoMap));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("a:\n  b:\n  - f\n  - h\n");
    }

    @Test
    public void textAtTopLevelInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("document", "blah");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("blah\n");
    }

    @Test
    public void arrayAtTopLevelInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("document[0]", "c");
        map.put("document[1]", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("- c\n- d\n");
    }

    @Test
    public void arrayObObjectAtTopLevelInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("document[0].a", "c");
        map.put("document[1].a", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("- a: c\n- a: d\n");
    }

    @Test
    public void yamlWithProperties() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("org.springframework", "WARN");
        map.put("org.springframework.cloud", "ERROR");
        this.environment.add(new PropertySource("abo", map));
        Mockito.when((Object)this.repository.findOne("ay", "\u00e4z\u00f6q", null, false)).thenReturn((Object)this.environment);
        System.out.println("this.controller = " + this.controller);
        String yaml = (String)this.controller.yaml("ay", "\u00e4z\u00f6q", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("org:\n  springframework: WARN\n  springframework.cloud: ERROR\n");
    }

    @Test
    public void arrayOfObjectInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("a.b[0].c", "d");
        map.put("a.b[0].d", "e");
        map.put("a.b[1].c", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        ((AbstractBooleanAssert)Assertions.assertThat(("a:\n  b:\n  - d: e\n    c: d\n  - c: d\n".equals(yaml) || "a:\n  b:\n  - c: d\n    d: e\n  - c: d\n".equals(yaml) ? 1 : 0) != 0).as("Wrong output: " + yaml, new Object[0])).isTrue();
    }

    @Test
    public void nestedArraysOfObjectInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("a.b[0].c", "x");
        map.put("a.b[2].e[0].d", "z");
        map.put("a.b[0].d[2]", "yy");
        map.put("a.b[0].d[0]", "xx");
        map.put("a.b[2].c", "y");
        map.put("a.b[3][0]", "r");
        map.put("a.b[3][1]", "s");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Map level1 = (Map)new Yaml().load(yaml);
        Assertions.assertThat((Map)level1).containsOnlyKeys((Object[])new String[]{"a"});
        Map level2 = (Map)level1.get("a");
        Assertions.assertThat((Map)level2).containsOnlyKeys((Object[])new String[]{"b"});
        List level3 = (List)level2.get("b");
        Assertions.assertThat((List)level3).hasSize(4);
        Assertions.assertThat(level3.get(1)).isNull();
        Map item0 = (Map)level3.get(0);
        Assertions.assertThat((Map)item0).containsOnlyKeys((Object[])new String[]{"c", "d"});
        Assertions.assertThat((Map)item0).containsEntry((Object)"c", (Object)"x");
        List itemd = (List)item0.get("d");
        Assertions.assertThat((List)itemd).containsExactly(new Object[]{"xx", null, "yy"});
        Map item2 = (Map)level3.get(2);
        Assertions.assertThat((Map)item2).containsOnlyKeys((Object[])new String[]{"c", "e"});
        Assertions.assertThat((Map)item2).containsEntry((Object)"c", (Object)"y");
        List iteme = (List)item2.get("e");
        Assertions.assertThat((List)iteme).hasSize(1);
        Map item_e0 = (Map)iteme.get(0);
        Assertions.assertThat((Map)item_e0).containsExactly(new Map.Entry[]{Assertions.entry((Object)"d", (Object)"z")});
        List item3 = (List)level3.get(3);
        Assertions.assertThat((List)item3).containsExactly(new Object[]{"r", "s"});
    }

    @Test
    public void nestedArraysOfObjectInJson() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("a.b[0].c", "x");
        map.put("a.b[0].d[0]", "xx");
        map.put("a.b[0].d[1]", "yy");
        map.put("a.b[1].c", "y");
        map.put("a.b[1].e[0].d", "z");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String json = (String)this.controller.jsonProperties("foo", "bar", false).getBody();
        ((AbstractStringAssert)Assertions.assertThat((String)json).as("Wrong output: " + json, new Object[0])).isEqualTo("{\"a\":{\"b\":[{\"c\":\"x\",\"d\":[\"xx\",\"yy\"]},{\"c\":\"y\",\"e\":[{\"d\":\"z\"}]}]}}");
    }

    @Test
    public void arrayOfObjectAtTopLevelInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("b[0].c", "d");
        map.put("b[1].c", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("b:\n- c: d\n- c: d\n");
    }

    @Test
    public void arrayOfObjectNestedLevelInYaml() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("x.a.b[0].c", "d");
        map.put("x.a.b[1].c", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
        String yaml = (String)this.controller.yaml("foo", "bar", false).getBody();
        Assertions.assertThat((String)yaml).isEqualTo("x:\n  a:\n    b:\n    - c: d\n    - c: d\n");
    }

    @Test
    public void placeholdersResolvedInProperties() throws Exception {
        this.whenPlaceholders();
        String text = (String)this.controller.properties("foo", "bar", true).getBody();
        Properties properties = new Properties();
        properties.load(new StringReader(text));
        Assertions.assertThat((Map)properties).containsOnly(new Map.Entry[]{Assertions.entry((Object)"a.b.c", (Object)"bar"), Assertions.entry((Object)"foo", (Object)"bar")});
    }

    @Test
    public void placeholdersNotResolvedInProperties() throws Exception {
        this.whenPlaceholders();
        String text = (String)this.controller.properties("foo", "bar", false).getBody();
        Properties properties = new Properties();
        properties.load(new StringReader(text));
        Assertions.assertThat((Map)properties).containsOnly(new Map.Entry[]{Assertions.entry((Object)"a.b.c", (Object)"${foo}"), Assertions.entry((Object)"foo", (Object)"bar")});
    }

    @Test
    public void placeholdersNotResolvedInPropertiesFromSystemProperties() throws Exception {
        this.whenPlaceholdersSystemProps();
        String text = (String)this.controller.properties("foo", "bar", true).getBody();
        Assertions.assertThat((String)text).isEqualTo("a.b.c: ${foo}");
    }

    @Test
    public void placeholdersNotResolvedInPropertiesFromSystemPropertiesWhenNotFlagged() throws Exception {
        this.whenPlaceholdersSystemProps();
        String text = (String)this.controller.properties("foo", "bar", false).getBody();
        Assertions.assertThat((String)text).isEqualTo("a.b.c: ${foo}");
    }

    @Test
    public void placeholdersNotResolvedInPropertiesFromSystemPropertiesWhenNotFlaggedWithDefault() throws Exception {
        this.whenPlaceholdersSystemPropsWithDefault();
        String text = (String)this.controller.properties("foo", "bar", false).getBody();
        Assertions.assertThat((String)text).isEqualTo("a.b.c: ${foo:spam}");
    }

    @Test
    public void placeholdersResolvedInJson() throws Exception {
        this.whenPlaceholders();
        String json = (String)this.controller.jsonProperties("foo", "bar", true).getBody();
        JSONAssert.assertEquals((String)"{\"a\":{\"b\":{\"c\":\"bar\"}},\"foo\":\"bar\"}", (String)json, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    public void placeholdersNotResolvedInJson() throws Exception {
        this.whenPlaceholders();
        String json = (String)this.controller.jsonProperties("foo", "bar", false).getBody();
        JSONAssert.assertEquals((String)"{\"a\":{\"b\":{\"c\":\"${foo}\"}},\"foo\":\"bar\"}", (String)json, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    public void placeholdersNotResolvedInJsonFromSystemProperties() throws Exception {
        this.whenPlaceholdersSystemProps();
        String json = (String)this.controller.jsonProperties("foo", "bar", true).getBody();
        Assertions.assertThat((String)json).isEqualTo("{\"a\":{\"b\":{\"c\":\"${foo}\"}}}");
    }

    @Test
    public void placeholdersNotResolvedInJsonFromSystemPropertiesWhenNotFlagged() throws Exception {
        this.whenPlaceholdersSystemProps();
        String json = (String)this.controller.jsonProperties("foo", "bar", false).getBody();
        Assertions.assertThat((String)json).isEqualTo("{\"a\":{\"b\":{\"c\":\"${foo}\"}}}");
    }

    @Test
    public void placeholdersNotResolvedInJsonFromSystemPropertiesWhenNotFlaggedWithDefault() throws Exception {
        this.whenPlaceholdersSystemPropsWithDefault();
        String json = (String)this.controller.jsonProperties("foo", "bar", false).getBody();
        Assertions.assertThat((String)json).isEqualTo("{\"a\":{\"b\":{\"c\":\"${foo:spam}\"}}}");
    }

    @Test
    public void placeholdersResolvedInJsonFromSystemPropertiesWhenFlagged() throws Exception {
        this.whenPlaceholdersSystemPropsWithDefault();
        String json = (String)this.controller.jsonProperties("foo", "bar", true).getBody();
        Assertions.assertThat((String)json).isEqualTo("{\"a\":{\"b\":{\"c\":\"spam\"}}}");
    }

    private void whenPlaceholders() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("foo", "bar");
        this.environment.add(new PropertySource("one", map));
        this.environment.addFirst(new PropertySource("two", Collections.singletonMap("a.b.c", "${foo}")));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
    }

    private void whenPlaceholdersSystemProps() {
        System.setProperty("foo", "bar");
        this.environment.addFirst(new PropertySource("two", Collections.singletonMap("a.b.c", "${foo}")));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
    }

    private void whenPlaceholdersSystemPropsWithDefault() {
        System.setProperty("foo", "bar");
        this.environment.addFirst(new PropertySource("two", Collections.singletonMap("a.b.c", "${foo:spam}")));
        Mockito.when((Object)this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)this.environment);
    }

    @Test
    public void labelWithPreviousDirectory() {
        Assertions.assertThatThrownBy(() -> this.controller.labelled("foo", "bar", "..(_)..")).isInstanceOf(InvalidEnvironmentRequestException.class);
    }

    @Test
    public void labelWithPreviousDirectoryEncodedParenthesis() {
        Assertions.assertThatThrownBy(() -> this.controller.labelled("foo", "bar", "..%28_%29..")).isInstanceOf(InvalidEnvironmentRequestException.class);
    }

    @Test
    public void labelWithPreviousDirectoryAllEncoded() {
        Assertions.assertThatThrownBy(() -> this.controller.labelled("foo", "bar", "%2E%2E%28%5F%29%2E%2E")).isInstanceOf(InvalidEnvironmentRequestException.class);
    }

    @Test
    public void nameWithPound() {
        Assertions.assertThatThrownBy(() -> this.controller.labelled("foo#", "bar", "mylabel")).isInstanceOf(InvalidEnvironmentRequestException.class);
    }

    @Test
    public void nameWithPoundEncoded() {
        Assertions.assertThatThrownBy(() -> this.controller.labelled("foo%23", "bar", "mylabel")).isInstanceOf(InvalidEnvironmentRequestException.class);
    }

    @Nested
    class AntPathMatcherTests
    extends MockMvcTestCases {
        AntPathMatcherTests() {
        }

        @BeforeEach
        public void initMockMvc() {
            this.mvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{EnvironmentControllerTests.this.controller}).build();
        }
    }

    @Nested
    class PathPatternParserTests
    extends MockMvcTestCases {
        PathPatternParserTests() {
        }

        @BeforeEach
        public void initMockMvc() {
            StandaloneMockMvcBuilder builder = MockMvcBuilders.standaloneSetup((Object[])new Object[]{EnvironmentControllerTests.this.controller});
            builder.setPatternParser(new PathPatternParser());
            this.mvc = builder.build();
        }
    }

    abstract class MockMvcTestCases {
        protected MockMvc mvc;

        MockMvcTestCases() {
        }

        @Test
        public void mappingForEnvironment() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/bar", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        }

        @Test
        public void mappingForLabelledEnvironment() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", "other", false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo/bar/other", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        }

        @Test
        public void environmentMissing() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo1", "notfound", null, false)).thenThrow(new Throwable[]{new EnvironmentNotFoundException("Missing Environment")});
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo1/notfound", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        }

        @Test
        public void mappingForYaml() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo-bar.yml", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.content().string("{}\n"));
        }

        @Test
        public void mappingForJson() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo-bar.json", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.content().string("{}"));
        }

        @Test
        public void mappingForLabelledYaml() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", "other", false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/other/foo-bar.yml", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN));
        }

        @Test
        public void mappingForLabelledProperties() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", "other", false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/other/foo-bar.properties", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN));
        }

        @Test
        public void mappingForProperties() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo-bar.properties", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN));
        }

        @Test
        public void mappingForLabelledYamlWithHyphen() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo-bar-foo2-bar2", "spam", "other", false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/other/foo-bar-foo2-bar2-spam.yml", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN));
        }

        @Test
        public void mappingforLabelledJsonProperties() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", "other", false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/other/foo-bar.json", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON));
        }

        @Test
        public void mappingforJsonProperties() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo", "bar", null, false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/foo-bar.json", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON));
        }

        @Test
        public void mappingForLabelledJsonPropertiesWithHyphen() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne("foo-bar-foo2-bar2", "spam", "other", false)).thenReturn((Object)EnvironmentControllerTests.this.environment);
            this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/other/foo-bar-foo2-bar2-spam.json", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON));
        }

        @Test
        public void handleEnvironmentException() throws Exception {
            Mockito.when((Object)EnvironmentControllerTests.this.repository.findOne((String)ArgumentMatchers.eq((Object)"exception"), (String)ArgumentMatchers.eq((Object)"bad_syntax.ext"), (String)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenThrow(new Throwable[]{new FailedToConstructEnvironmentException("Cannot construct", (Throwable)new RuntimeException("underlier"))});
            MvcResult result = this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/exception/bad_syntax.ext", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(500)).andReturn();
            Assertions.assertThat((String)result.getResponse().getErrorMessage()).isEqualTo("Cannot construct");
        }
    }
}

