/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentEncryptorEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;

public class EnvironmentEncryptorEnvironmentRepositoryTests {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private EnvironmentRepository repository = (EnvironmentRepository)Mockito.mock(EnvironmentRepository.class);
    private EnvironmentEncryptorEnvironmentRepository controller;
    private Environment environment = new Environment("foo", new String[]{"master"});

    @BeforeEach
    public void init() {
        this.controller = new EnvironmentEncryptorEnvironmentRepository(this.repository, ObservationRegistry.NOOP);
    }

    @Test
    public void allowOverrideFalse() throws Exception {
        this.controller.setOverrides(Collections.singletonMap("foo", "bar"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a.b.c", "d");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", "master", false)).thenReturn((Object)this.environment);
        Assertions.assertThat((String)((PropertySource)this.controller.findOne("foo", "bar", "master", false).getPropertySources().get(0)).getSource().toString()).isEqualTo("{foo=bar}");
    }

    @Test
    public void overrideWithEscapedPlaceholders() throws Exception {
        this.controller.setOverrides(Collections.singletonMap("foo", "$\\{bar}"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bar", "foo");
        this.environment.add(new PropertySource("one", map));
        Mockito.when((Object)this.repository.findOne("foo", "bar", "master", false)).thenReturn((Object)this.environment);
        Assertions.assertThat((String)((PropertySource)this.controller.findOne("foo", "bar", "master", false).getPropertySources().get(0)).getSource().toString()).isEqualTo("{foo=${bar}}");
    }
}

