/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.google.cloud.secretmanager.v1.AccessSecretVersionRequest;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.ListSecretVersionsRequest;
import com.google.cloud.secretmanager.v1.ListSecretsRequest;
import com.google.cloud.secretmanager.v1.Secret;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.cloud.secretmanager.v1.SecretVersion;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.cloud.config.server.environment.GoogleSecretManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleConfigProvider;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretComparatorByVersion;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretManagerAccessStrategyFactory;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretManagerV1AccessStrategy;
import org.springframework.cloud.config.server.environment.secretmanager.HttpHeaderGoogleConfigProvider;
import org.springframework.web.client.RestTemplate;

public class GoogleSecretManagerEnvironmentRepositoryTests {
    @Test
    public void testSupportedStrategy() {
        GoogleSecretManagerEnvironmentProperties properties = new GoogleSecretManagerEnvironmentProperties();
        SecretManagerServiceClient mock = (SecretManagerServiceClient)Mockito.mock(SecretManagerServiceClient.class);
        properties.setVersion(Integer.valueOf(1));
        Assertions.assertThat((boolean)(GoogleSecretManagerAccessStrategyFactory.forVersion(null, null, (GoogleSecretManagerEnvironmentProperties)properties, (SecretManagerServiceClient)mock) instanceof GoogleSecretManagerV1AccessStrategy)).isTrue();
    }

    @Test
    public void testGetUnsupportedStrategy() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            GoogleSecretManagerEnvironmentProperties properties = new GoogleSecretManagerEnvironmentProperties();
            SecretManagerServiceClient mock = (SecretManagerServiceClient)Mockito.mock(SecretManagerServiceClient.class);
            properties.setVersion(Integer.valueOf(2));
            GoogleSecretManagerAccessStrategyFactory.forVersion(null, null, (GoogleSecretManagerEnvironmentProperties)properties, (SecretManagerServiceClient)mock);
        });
    }

    @Test
    public void testGetSecrets() throws IOException {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        GoogleConfigProvider provider = (GoogleConfigProvider)Mockito.mock(HttpHeaderGoogleConfigProvider.class);
        Mockito.when((Object)provider.getValue("X-Project-ID", Boolean.valueOf(true))).thenReturn((Object)"test-project");
        SecretManagerServiceClient mock = (SecretManagerServiceClient)Mockito.mock(SecretManagerServiceClient.class);
        SecretManagerServiceClient.ListSecretsPagedResponse response = (SecretManagerServiceClient.ListSecretsPagedResponse)Mockito.mock(SecretManagerServiceClient.ListSecretsPagedResponse.class);
        Secret secret = Secret.newBuilder().setName("projects/test-project/secrets/test").build();
        ArrayList<Secret> secrets = new ArrayList<Secret>();
        secrets.add(secret);
        Mockito.when((Object)response.iterateAll()).thenReturn(secrets);
        ((SecretManagerServiceClient)Mockito.doReturn((Object)response).when((Object)mock)).listSecrets((ListSecretsRequest)ArgumentMatchers.any(ListSecretsRequest.class));
        GoogleSecretManagerV1AccessStrategy strategy = new GoogleSecretManagerV1AccessStrategy(rest, provider, mock);
        Assertions.assertThat((List)strategy.getSecrets()).hasSize(1);
    }

    @Test
    public void testGetSecretValues() {
        RestTemplate rest = (RestTemplate)Mockito.mock(RestTemplate.class);
        GoogleConfigProvider provider = (GoogleConfigProvider)Mockito.mock(HttpHeaderGoogleConfigProvider.class);
        Mockito.when((Object)provider.getValue("X-Project-ID", Boolean.valueOf(true))).thenReturn((Object)"test-project");
        SecretManagerServiceClient mock = (SecretManagerServiceClient)Mockito.mock(SecretManagerServiceClient.class);
        SecretManagerServiceClient.ListSecretVersionsPagedResponse response = (SecretManagerServiceClient.ListSecretVersionsPagedResponse)Mockito.mock(SecretManagerServiceClient.ListSecretVersionsPagedResponse.class);
        SecretVersion secret1 = SecretVersion.newBuilder().setName("projects/test-project/secrets/test/versions/1").setState(SecretVersion.State.ENABLED).build();
        SecretVersion secret2 = SecretVersion.newBuilder().setName("projects/test-project/secrets/test/versions/4").setState(SecretVersion.State.ENABLED).build();
        SecretVersion secret3 = SecretVersion.newBuilder().setName("projects/test-project/secrets/test/versions/9").setState(SecretVersion.State.ENABLED).build();
        SecretVersion secret4 = SecretVersion.newBuilder().setName("projects/test-project/secrets/test/versions/12").setState(SecretVersion.State.ENABLED).build();
        ArrayList<SecretVersion> secrets = new ArrayList<SecretVersion>();
        secrets.add(secret1);
        secrets.add(secret2);
        secrets.add(secret3);
        secrets.add(secret4);
        Mockito.when((Object)response.iterateAll()).thenReturn(secrets);
        ((SecretManagerServiceClient)Mockito.doReturn((Object)response).when((Object)mock)).listSecretVersions((ListSecretVersionsRequest)ArgumentMatchers.any(ListSecretVersionsRequest.class));
        GoogleSecretManagerV1AccessStrategy strategy = new GoogleSecretManagerV1AccessStrategy(rest, provider, mock);
        AccessSecretVersionResponse accessSecretVersionResponse = (AccessSecretVersionResponse)Mockito.mock(AccessSecretVersionResponse.class);
        SecretPayload payload = (SecretPayload)Mockito.mock(SecretPayload.class);
        ByteString data = (ByteString)Mockito.mock(ByteString.class);
        Mockito.when((Object)accessSecretVersionResponse.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)payload.getData()).thenReturn((Object)data);
        Mockito.when((Object)data.toStringUtf8()).thenReturn((Object)"test-value");
        ArgumentMatcher<AccessSecretVersionRequest> matcher = new ArgumentMatcher<AccessSecretVersionRequest>(){

            public boolean matches(AccessSecretVersionRequest accessSecretVersionRequest) {
                return accessSecretVersionRequest.getName().equals("projects/test-project/secrets/test/versions/12");
            }
        };
        ((SecretManagerServiceClient)Mockito.doReturn((Object)accessSecretVersionResponse).when((Object)mock)).accessSecretVersion((AccessSecretVersionRequest)ArgumentMatchers.argThat((ArgumentMatcher)matcher));
        Assertions.assertThat((String)strategy.getSecretValue(Secret.newBuilder().setName("projects/test-project/secrets/test").build(), (Comparator)new GoogleSecretComparatorByVersion())).isEqualTo("test-value");
    }
}

