/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import jakarta.servlet.http.HttpServletRequest;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.HttpRequestConfigTokenProvider;
import org.springframework.mock.web.MockHttpServletRequest;

public class HttpRequestConfigTokenProviderTests {
    private ObjectProvider<HttpServletRequest> httpRequestProvider;
    private HttpRequestConfigTokenProvider tokenProvider;

    @BeforeEach
    public void setUp() {
        this.httpRequestProvider = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        this.tokenProvider = new HttpRequestConfigTokenProvider(this.httpRequestProvider);
    }

    @Test
    public void missingHttpRequest() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> {
            Mockito.when((Object)((HttpServletRequest)this.httpRequestProvider.getIfAvailable())).thenReturn(null);
            this.tokenProvider.getToken();
        });
    }

    @Test
    public void missingTokenHeader() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Mockito.when((Object)((HttpServletRequest)this.httpRequestProvider.getIfAvailable())).thenReturn((Object)new MockHttpServletRequest());
            this.tokenProvider.getToken();
        });
    }
}

