/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.Git;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.ResourceUtils;

public class JGitConfigServerTestData {
    private LocalGit serverGit;
    private LocalGit clonedGit;
    private JGitEnvironmentRepository repository;
    private ConfigurableApplicationContext context;

    public JGitConfigServerTestData(LocalGit serverGit, LocalGit clonedGit, JGitEnvironmentRepository repository, ConfigurableApplicationContext context) {
        this.serverGit = serverGit;
        this.clonedGit = clonedGit;
        this.repository = repository;
        this.context = context;
    }

    public static JGitConfigServerTestData prepareClonedGitRepository(Class ... sources) throws Exception {
        return JGitConfigServerTestData.prepareClonedGitRepository(Collections.emptySet(), sources);
    }

    public static JGitConfigServerTestData prepareClonedGitRepository(Collection<String> additionalProperties, Class ... sources) throws Exception {
        String remoteUri = ConfigServerTestUtils.prepareLocalRepo();
        File remoteRepoDir = ResourceUtils.getFile((String)remoteUri);
        Git remoteGit = Git.open((File)remoteRepoDir.getAbsoluteFile());
        remoteGit.checkout().setName("master").call();
        File clonedRepoDir = new File("target/repos/cloned");
        if (clonedRepoDir.exists()) {
            FileSystemUtils.deleteRecursively((File)clonedRepoDir);
        } else {
            clonedRepoDir.mkdirs();
        }
        Git clonedGit = Git.cloneRepository().setURI("file://" + remoteRepoDir.getAbsolutePath()).setDirectory(clonedRepoDir).setBranch("master").setCloneAllBranches(true).call();
        ArrayList<String> properties = new ArrayList<String>(additionalProperties);
        properties.add("spring.cloud.config.server.git.uri:file://" + clonedRepoDir.getAbsolutePath());
        ConfigurableApplicationContext context = new SpringApplicationBuilder(sources).web(WebApplicationType.NONE).properties(properties.toArray(new String[0])).run(new String[0]);
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)context.getBean(JGitEnvironmentRepository.class);
        return new JGitConfigServerTestData(new LocalGit(remoteGit, remoteRepoDir), new LocalGit(clonedGit, clonedRepoDir), repository, context);
    }

    public LocalGit getServerGit() {
        return this.serverGit;
    }

    public LocalGit getClonedGit() {
        return this.clonedGit;
    }

    public JGitEnvironmentRepository getRepository() {
        return this.repository;
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public static class LocalGit {
        private Git git;
        private File gitWorkingDirectory;

        public LocalGit(Git git, File gitWorkingDirectory) {
            this.git = git;
            this.gitWorkingDirectory = gitWorkingDirectory;
        }

        public Git getGit() {
            return this.git;
        }

        public File getGitWorkingDirectory() {
            return this.gitWorkingDirectory;
        }
    }
}

