/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JGitConfigServerTestData;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

public class JGitEnvironmentRepositoryConcurrencyTests {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableApplicationContext context;
    private File basedir = new File("target/config");

    @BeforeAll
    public static void initClass() {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
    }

    @BeforeEach
    public void init() throws Exception {
        if (this.basedir.exists()) {
            FileUtils.delete((File)this.basedir, (int)1);
        }
        ConfigServerTestUtils.deleteLocalRepo("config-copy");
    }

    @AfterEach
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void vanilla() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalRepo();
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + uri}).run(new String[0]);
        final EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        ExecutorService threads = Executors.newFixedThreadPool(4);
        ArrayList<Future<Boolean>> tasks = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 30; ++i) {
            tasks.add(threads.submit(new Runnable(){

                @Override
                public void run() {
                    repository.findOne("bar", "staging", "master");
                }
            }, true));
        }
        for (Future future : tasks) {
            future.get();
        }
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)environment.getName()).isEqualTo("bar");
        Assertions.assertThat((Object[])environment.getProfiles()).isEqualTo((Object)new String[]{"staging"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("master");
    }

    @Test
    public void concurrentRefreshContextAndGetLabels() throws Exception {
        final JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
        JGitEnvironmentRepository repository = testData.getRepository();
        repository.setCloneOnStart(true);
        repository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new DelayedGitFactoryMock());
        repository.setBasedir(testData.getClonedGit().getGitWorkingDirectory());
        repository.setUri(testData.getServerGit().getGitWorkingDirectory().getAbsolutePath().replace("file://", ""));
        final AtomicInteger errorCount = new AtomicInteger();
        Thread client = new Thread(new Runnable(){

            @Override
            public void run() {
                JGitEnvironmentRepositoryConcurrencyTests.this.logger.info((Object)"client start.");
                try {
                    Environment environment = testData.getRepository().findOne("bar", "staging", "master");
                }
                catch (Exception e) {
                    errorCount.incrementAndGet();
                    e.printStackTrace();
                }
                JGitEnvironmentRepositoryConcurrencyTests.this.logger.info((Object)"client end.");
            }
        });
        Thread refresh = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JGitEnvironmentRepositoryConcurrencyTests.this.logger.info((Object)"refresh start.");
                    testData.getRepository().afterPropertiesSet();
                    JGitEnvironmentRepositoryConcurrencyTests.this.logger.info((Object)"refresh end.");
                }
                catch (Exception e) {
                    errorCount.incrementAndGet();
                    e.printStackTrace();
                }
            }
        });
        refresh.start();
        client.start();
        refresh.join();
        client.join();
        Assertions.assertThat((int)errorCount.get()).isEqualTo(0);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={PropertyPlaceholderAutoConfiguration.class, EnvironmentRepositoryConfiguration.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }
    }

    private static class DelayedGitFactoryMock
    extends JGitEnvironmentRepository.JGitFactory {
        private DelayedGitFactoryMock() {
        }

        public Git getGitByOpen(File file) throws IOException {
            Git originalGit = DelayedGitMock.open((File)file);
            return new DelayedGitMock(originalGit.getRepository());
        }

        public CloneCommand getCloneCommandByCloneRepository() {
            return new DelayedCloneCommand();
        }
    }

    private static class DelayedCheckoutCommand
    extends CheckoutCommand {
        DelayedCheckoutCommand(Repository repo) {
            super(repo);
        }

        public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return super.call();
        }
    }

    private static class DelayedFetchCommand
    extends FetchCommand {
        DelayedFetchCommand(Repository repo) {
            super(repo);
        }

        public FetchResult call() throws GitAPIException, InvalidRemoteException, TransportException {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return super.call();
        }
    }

    private static class DelayedCloneCommand
    extends CloneCommand {
        private DelayedCloneCommand() {
        }

        public Git call() throws GitAPIException, InvalidRemoteException, TransportException {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return super.call();
        }
    }

    private static class DelayedGitMock
    extends Git {
        DelayedGitMock(Repository repo) {
            super(repo);
        }

        public FetchCommand fetch() {
            return new DelayedFetchCommand(this.getRepository());
        }

        public CheckoutCommand checkout() {
            return new DelayedCheckoutCommand(this.getRepository());
        }
    }
}

