/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JGitConfigServerTestData;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;

public class JGitEnvironmentRepositoryIntegrationTests {
    private ConfigurableApplicationContext context;
    private File basedir = new File("target/config");

    @BeforeAll
    public static void initClass() {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
    }

    @BeforeEach
    public void init() throws Exception {
        if (this.basedir.exists()) {
            FileUtils.delete((File)this.basedir, (int)1);
        }
        ConfigServerTestUtils.deleteLocalRepo("");
    }

    @AfterEach
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void vanilla() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo();
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + uri}).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)environment.getName()).isEqualTo("bar");
        Assertions.assertThat((Object[])environment.getProfiles()).isEqualTo((Object)new String[]{"staging"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("master");
    }

    @Test
    public void shouldFailIfNotTryingMaster() {
        AssertionsForClassTypes.assertThatExceptionOfType(NoSuchLabelException.class).isThrownBy(() -> {
            String uri = ConfigServerTestUtils.prepareLocalRepo();
            this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + uri, "spring.cloud.config.server.git.tryMasterBranch:false"}).run(new String[0]);
            EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
            Environment environment = repository.findOne("bar", "staging", null);
        });
    }

    @Test
    public void pull() throws Exception {
        ConfigServerTestUtils.prepareLocalRepo();
        String uri = ConfigServerTestUtils.copyLocalRepo("config-copy");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"bar");
        Git git = Git.open((File)ResourceUtils.getFile((String)uri).getAbsoluteFile());
        git.checkout().setName("master").call();
        StreamUtils.copy((String)"foo: foo", (Charset)Charset.defaultCharset(), (OutputStream)new FileOutputStream(ResourceUtils.getFile((String)(uri + "/bar.properties"))));
        git.add().addFilepattern("bar.properties").call();
        git.commit().setMessage("Updated for pull").call();
        environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"foo");
    }

    @Test
    public void pullDirtyRepo() throws Exception {
        ConfigServerTestUtils.prepareLocalRepo();
        String uri = ConfigServerTestUtils.copyLocalRepo("config-copy");
        Repository remote = ConfigServerTestUtils.prepareBareRemote();
        Git git = Git.open((File)ResourceUtils.getFile((String)uri).getAbsoluteFile());
        StoredConfig config = git.getRepository().getConfig();
        config.setString("remote", "origin", "url", remote.getDirectory().getAbsolutePath());
        config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
        config.save();
        git.push().call();
        String commitToRevertBeforePull = ((RevCommit)git.log().setMaxCount(1).call().iterator().next()).getName();
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri});
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        SearchPathLocator.Locations locations = repository.getLocations("bar", "test", "raw");
        Assertions.assertThat((String)commitToRevertBeforePull).isEqualTo(locations.getVersion());
        git.reset().setMode(ResetCommand.ResetType.HARD).setRef("master").call();
        Path applicationFilePath = Paths.get(ResourceUtils.getFile((String)uri).getAbsoluteFile() + "/application.yml", new String[0]);
        Files.write(applicationFilePath, Arrays.asList("info:", "  foo: bar", "raw: false"), StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);
        git.add().addFilepattern(".").call();
        git.commit().setMessage("Conflicting commit.").call();
        git.push().setForce(true).call();
        String conflictingCommit = ((RevCommit)git.log().setMaxCount(1).call().iterator().next()).getName();
        git.reset().setMode(ResetCommand.ResetType.HARD).setRef(commitToRevertBeforePull).call();
        locations = repository.getLocations("bar", "test", "raw");
        Assertions.assertThat((String)conflictingCommit).isEqualTo(locations.getVersion());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)git.status().call().isClean()).as("Local repository is not cleaned after retrieving resources.", new Object[0])).isTrue();
    }

    @Test
    public void pullMissingRepo() throws Exception {
        this.pull();
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        new File(repository.getUri().replaceAll("file:", ""), ".git/index.lock").createNewFile();
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"foo");
    }

    @Test
    public void nested() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("another-config-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.searchPaths=sub"});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void nestedWithApplicationPlaceholders() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("nested-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.searchPaths={application}"});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("foo,bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(3);
    }

    @Test
    @Disabled
    public void verifyPropertySourceOrdering() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("ordering-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.searchPaths=**"});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("application", "test", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("file:././target/repos/ordering-repo//project/sub/application-test.yml");
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).isEqualTo("file:././target/repos/ordering-repo//project/application.yml");
    }

    @Test
    public void nestedWithProfilePlaceholders() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("nested-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.searchPaths={profile}"});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("staging", "foo,bar", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(3);
    }

    @Test
    public void singleElementArrayIndexSearchPath() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("nested-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.searchPaths[0]={application}"});
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        Assertions.assertThat((Object[])repository.getSearchPaths()).containsExactly((Object[])new String[]{"{application}"});
        Assertions.assertThat((boolean)Arrays.equals(repository.getSearchPaths(), new JGitEnvironmentRepository(repository.getEnvironment(), new JGitEnvironmentProperties(), ObservationRegistry.NOOP).getSearchPaths())).isFalse();
    }

    @Test
    public void defaultLabel() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalRepo();
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + uri}).run(new String[0]);
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        Assertions.assertThat((String)repository.getDefaultLabel()).isEqualTo("main");
    }

    @Test
    public void invalidLabel() {
        AssertionsForClassTypes.assertThatExceptionOfType(NoSuchLabelException.class).isThrownBy(() -> {
            String uri = ConfigServerTestUtils.prepareLocalRepo();
            this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + uri}).run(new String[0]);
            EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
            repository.findOne("bar", "staging", "unknownlabel");
        });
    }

    @Test
    public void findOne_CloneOnStartTrue_FindOneSuccess() throws Exception {
        ConfigServerTestUtils.prepareLocalRepo();
        String uri = ConfigServerTestUtils.copyLocalRepo("config-copy");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.cloneOnStart=true"});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        Assertions.assertThat((boolean)((JGitEnvironmentRepository)repository).isCloneOnStart()).isTrue();
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)environment.getName()).isEqualTo("bar");
        Assertions.assertThat((Object[])environment.getProfiles()).isEqualTo((Object)new String[]{"staging"});
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("master");
    }

    @Test
    public void findOne_FileAddedToRepo_FindOneSuccess() throws Exception {
        ConfigServerTestUtils.prepareLocalRepo();
        String uri = ConfigServerTestUtils.copyLocalRepo("config-copy");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.cloneOnStart=true"});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"bar");
        Git git = Git.open((File)ResourceUtils.getFile((String)uri).getAbsoluteFile());
        git.checkout().setName("master").call();
        StreamUtils.copy((String)"foo: foo", (Charset)Charset.defaultCharset(), (OutputStream)new FileOutputStream(ResourceUtils.getFile((String)(uri + "/bar.properties"))));
        git.add().addFilepattern("bar.properties").call();
        git.commit().setMessage("Updated for pull").call();
        environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"foo");
    }

    @Test
    public void findOne_NestedSearchPath_FindOneSuccess() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("another-config-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.searchPaths=sub", "--spring.cloud.config.server.git.cloneOnStart=true"});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void findOne_FindInvalidLabel_IllegalStateExceptionThrown() throws IOException {
        AssertionsForClassTypes.assertThatExceptionOfType(NoSuchLabelException.class).isThrownBy(() -> {
            String uri = ConfigServerTestUtils.prepareLocalRepo();
            this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + uri, "--spring.cloud.config.server.git.cloneOnStart=true"}).run(new String[0]);
            EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
            repository.findOne("bar", "staging", "unknownlabel");
        });
    }

    @Test
    public void testVersionUpdate() throws Exception {
        JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
        String startingLocalVersion = this.getCommitID(testData.getClonedGit().getGit(), "master");
        String startingRemoteVersion = this.getCommitID(testData.getServerGit().getGit(), "master");
        Environment environment = testData.getRepository().findOne("bar", "staging", "master");
        Assertions.assertThat((String)startingRemoteVersion).isEqualTo(environment.getVersion());
        FileOutputStream out = new FileOutputStream(new File(testData.getServerGit().getGitWorkingDirectory(), "bar.properties"));
        StreamUtils.copy((String)"foo: foo", (Charset)Charset.defaultCharset(), (OutputStream)out);
        testData.getServerGit().getGit().add().addFilepattern("bar.properties").call();
        testData.getServerGit().getGit().commit().setMessage("Updated for pull").call();
        environment = testData.getRepository().findOne("bar", "staging", "master");
        String updatedLocalVersion = this.getCommitID(testData.getClonedGit().getGit(), "master");
        String updatedRemoteVersion = this.getCommitID(testData.getClonedGit().getGit(), "master");
        Assertions.assertThat((String)updatedLocalVersion).isEqualTo(updatedRemoteVersion);
        Assertions.assertThat((String)startingRemoteVersion).isNotEqualTo((Object)updatedRemoteVersion);
        Assertions.assertThat((String)startingLocalVersion).isNotEqualTo((Object)updatedLocalVersion);
        Assertions.assertThat((String)updatedRemoteVersion).isEqualTo(environment.getVersion());
    }

    @Test
    public void testNewRemoteBranch() throws Exception {
        JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
        Environment environment = testData.getRepository().findOne("bar", "staging", "master");
        Object fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"bar").isEqualTo(fooProperty);
        testData.getServerGit().getGit().branchCreate().setName("testNewRemoteBranch").call();
        testData.getServerGit().getGit().checkout().setName("testNewRemoteBranch").call();
        FileOutputStream out = new FileOutputStream(new File(testData.getServerGit().getGitWorkingDirectory(), "/bar.properties"));
        StreamUtils.copy((String)"foo: branchBar", (Charset)Charset.defaultCharset(), (OutputStream)out);
        testData.getServerGit().getGit().add().addFilepattern("bar.properties").call();
        testData.getServerGit().getGit().commit().setMessage("Updated for branch test").call();
        environment = testData.getRepository().findOne("bar", "staging", "testNewRemoteBranch");
        fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"branchBar").isEqualTo(fooProperty);
    }

    @Test
    public void testNewRemoteTag() throws Exception {
        JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
        Git serverGit = testData.getServerGit().getGit();
        Environment environment = testData.getRepository().findOne("bar", "staging", "master");
        Object fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"bar").isEqualTo(fooProperty);
        serverGit.checkout().setName("master").call();
        serverGit.tag().setName("testTag").setMessage("Testing a tag").call();
        FileOutputStream out = new FileOutputStream(new File(testData.getServerGit().getGitWorkingDirectory(), "/bar.properties"));
        StreamUtils.copy((String)"foo: testAfterTag", (Charset)Charset.defaultCharset(), (OutputStream)out);
        testData.getServerGit().getGit().add().addFilepattern("bar.properties").call();
        testData.getServerGit().getGit().commit().setMessage("Updated for branch test").call();
        environment = testData.getRepository().findOne("bar", "staging", "master");
        fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"testAfterTag").isEqualTo(fooProperty);
        environment = testData.getRepository().findOne("bar", "staging", "testTag");
        fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"bar").isEqualTo(fooProperty);
        serverGit.tag().setName("testTag").setForceUpdate(true).setMessage("Testing a moved tag").call();
        environment = testData.getRepository().findOne("bar", "staging", "testTag");
        fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"testAfterTag").isEqualTo(fooProperty);
    }

    @Test
    public void testNewCommitID() throws Exception {
        JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
        String startingRemoteVersion = this.getCommitID(testData.getServerGit().getGit(), "master");
        Environment environment = testData.getRepository().findOne("bar", "staging", "master");
        Assertions.assertThat((String)startingRemoteVersion).isEqualTo(environment.getVersion());
        FileOutputStream out = new FileOutputStream(new File(testData.getServerGit().getGitWorkingDirectory(), "bar.properties"));
        StreamUtils.copy((String)"foo: barNewCommit", (Charset)Charset.defaultCharset(), (OutputStream)out);
        testData.getServerGit().getGit().add().addFilepattern("bar.properties").call();
        testData.getServerGit().getGit().commit().setMessage("Updated for pull").call();
        String updatedRemoteVersion = this.getCommitID(testData.getServerGit().getGit(), "master");
        environment = testData.getRepository().findOne("bar", "staging", "master");
        Assertions.assertThat((String)updatedRemoteVersion).isEqualTo(environment.getVersion());
        Object fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"barNewCommit").isEqualTo(fooProperty);
        environment = testData.getRepository().findOne("bar", "staging", startingRemoteVersion);
        Assertions.assertThat((String)startingRemoteVersion).isEqualTo(environment.getVersion());
        fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"bar").isEqualTo(fooProperty);
    }

    @Test
    public void testNewCommitIDWithRefreshRate() throws Exception {
        JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
        String startingRemoteVersion = this.getCommitID(testData.getServerGit().getGit(), "master");
        try {
            testData.getRepository().findOne("bar", "staging", "test");
            Assertions.fail((String)"Should have thrown NoSuchLabelException.");
        }
        catch (NoSuchLabelException noSuchLabelException) {
            // empty catch block
        }
        Environment environment = testData.getRepository().findOne("bar", "staging", "master");
        Assertions.assertThat((String)startingRemoteVersion).isEqualTo(environment.getVersion());
        FileOutputStream out = new FileOutputStream(new File(testData.getServerGit().getGitWorkingDirectory(), "bar.properties"));
        StreamUtils.copy((String)"foo: barNewCommit", (Charset)Charset.defaultCharset(), (OutputStream)out);
        testData.getServerGit().getGit().add().addFilepattern("bar.properties").call();
        testData.getServerGit().getGit().commit().setMessage("Updated for pull").call();
        String updatedRemoteVersion = this.getCommitID(testData.getServerGit().getGit(), "master");
        testData.getRepository().setRefreshRate(60);
        try {
            testData.getRepository().findOne("bar", "staging", "test");
            Assertions.fail((String)"Should have thrown NoSuchLabelException.");
        }
        catch (NoSuchLabelException noSuchLabelException) {
            // empty catch block
        }
        environment = testData.getRepository().findOne("bar", "staging", "master");
        Assertions.assertThat((String)updatedRemoteVersion).isEqualTo(environment.getVersion());
        Object fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"barNewCommit").isEqualTo(fooProperty);
        environment = testData.getRepository().findOne("bar", "staging", startingRemoteVersion);
        Assertions.assertThat((String)startingRemoteVersion).isEqualTo(environment.getVersion());
        fooProperty = ConfigServerTestUtils.getProperty(environment, "bar.properties", "foo");
        Assertions.assertThat((String)"bar").isEqualTo(fooProperty);
    }

    @Test
    public void testUnknownLabelWithRemote() throws Exception {
        AssertionsForClassTypes.assertThatExceptionOfType(NoSuchLabelException.class).isThrownBy(() -> {
            JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
            testData.getRepository().findOne("bar", "staging", "BADLabel");
        });
    }

    private String getCommitID(Git git, String label) throws GitAPIException {
        CheckoutCommand checkout = git.checkout();
        checkout.setName(label);
        Ref localRef = checkout.call();
        return localRef.getObjectId().getName();
    }

    public void passphrase() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String passphrase = "thisismypassphrase";
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.passphrase=thisismypassphrase"});
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        Assertions.assertThat((String)repository.getPassphrase()).contains(new CharSequence[]{"thisismypassphrase"});
    }

    @Test
    public void strictHostKeyChecking() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        boolean strictHostKeyChecking = true;
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).run(new String[]{"--spring.cloud.config.server.git.uri=" + uri, "--spring.cloud.config.server.git.strict-host-key-checking=true"});
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        Assertions.assertThat((boolean)true).isEqualTo(repository.isStrictHostKeyChecking());
    }

    @Test
    public void shouldSetTransportConfigCallback() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo();
        this.context = new SpringApplicationBuilder(new Class[]{TestConfigurationWithTransportConfigCallback.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + uri}).run(new String[0]);
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)this.context.getBean(JGitEnvironmentRepository.class);
        Assertions.assertThat((Object)repository.getTransportConfigCallback()).isNotNull();
    }

    @Test
    public void testShouldReturnEnvironmentFromLocalBranchInCaseRemoteDeleted() throws Exception {
        JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(TestConfiguration.class);
        String branchToDelete = "branchToDelete";
        testData.getServerGit().getGit().branchCreate().setName(branchToDelete).call();
        Environment environment = testData.getRepository().findOne("bar", "staging", "branchToDelete");
        Assertions.assertThat((Object)environment).isNotNull();
        testData.getServerGit().getGit().branchDelete().setBranchNames(new String[]{branchToDelete}).call();
        testData.getRepository().findOne("bar", "staging", "branchToDelete");
        Assertions.assertThat((Object)environment).isNotNull();
    }

    @Test
    public void testShouldFailIfRemoteBranchWasDeleted() throws Exception {
        AssertionsForClassTypes.assertThatExceptionOfType(NoSuchLabelException.class).isThrownBy(() -> {
            JGitConfigServerTestData testData = JGitConfigServerTestData.prepareClonedGitRepository(Collections.singleton("spring.cloud.config.server.git.deleteUntrackedBranches=true"), TestConfiguration.class);
            String branchToDelete = "branchToDelete";
            testData.getServerGit().getGit().branchCreate().setName(branchToDelete).call();
            Environment environment = testData.getRepository().findOne("bar", "staging", "branchToDelete");
            Assertions.assertThat((Object)environment).isNotNull();
            testData.getServerGit().getGit().branchDelete().setBranchNames(new String[]{branchToDelete}).call();
            testData.getRepository().findOne("bar", "staging", "branchToDelete");
        });
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={PropertyPlaceholderAutoConfiguration.class, EnvironmentRepositoryConfiguration.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={PropertyPlaceholderAutoConfiguration.class, EnvironmentRepositoryConfiguration.class})
    protected static class TestConfigurationWithTransportConfigCallback {
        protected TestConfigurationWithTransportConfigCallback() {
        }

        @Bean
        public TransportConfigCallback transportConfigCallback() {
            return (TransportConfigCallback)Mockito.mock(TransportConfigCallback.class);
        }
    }
}

