/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.net.URL;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.AssertionsForClassTypes;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.junit.http.SimpleHttpServer;
import org.eclipse.jgit.lib.Repository;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Disabled(value="SimpleHttpServer does not use jakarta.servlet")
public class JGitEnvironmentRepositorySslTests {
    private static SimpleHttpServer server;

    @BeforeAll
    public static void setup() throws Exception {
        URL repoUrl = JGitEnvironmentRepositorySslTests.class.getResource("/test1-config-repo/git");
        FileRepository repo = new FileRepository(new File(repoUrl.toURI()));
        server = new SimpleHttpServer((Repository)repo, true);
        server.start();
    }

    @AfterAll
    public static void teardown() throws Exception {
        server.stop();
    }

    private static String[] configServerProperties(String ... extraProperties) {
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList(extraProperties));
        properties.add("spring.cloud.config.server.git.uri=" + server.getSecureUri());
        properties.add("spring.cloud.config.server.git.username=agitter");
        properties.add("spring.cloud.config.server.git.password=letmein");
        return properties.toArray(new String[0]);
    }

    @Test
    public void selfSignedCertIsRejected() {
        AssertionsForClassTypes.assertThatExceptionOfType(CertificateException.class).isThrownBy(() -> {
            ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).properties(JGitEnvironmentRepositorySslTests.configServerProperties(new String[0])).web(WebApplicationType.NONE).run(new String[0]);
            JGitEnvironmentRepository repository = (JGitEnvironmentRepository)context.getBean(JGitEnvironmentRepository.class);
            try {
                repository.findOne("bar", "staging", "master");
            }
            catch (Throwable e) {
                while (e.getCause() != null && !((e = e.getCause()) instanceof CertificateException)) {
                }
                throw e;
            }
        });
    }

    @Test
    public void selfSignedCertWithSkipSslValidationIsAccepted() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).properties(JGitEnvironmentRepositorySslTests.configServerProperties("spring.cloud.config.server.git.skipSslValidation=true")).web(WebApplicationType.NONE).run(new String[0]);
        JGitEnvironmentRepository repository = (JGitEnvironmentRepository)context.getBean(JGitEnvironmentRepository.class);
        repository.findOne("bar", "staging", "master");
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={PropertyPlaceholderAutoConfiguration.class, EnvironmentRepositoryConfiguration.class})
    static class TestConfiguration {
        TestConfiguration() {
        }
    }
}

