/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;
import org.junit.Rule;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.support.AwsCodeCommitCredentialProvider;
import org.springframework.cloud.config.server.support.GitSkipSslValidationCredentialsProvider;
import org.springframework.cloud.config.server.support.PassphraseCredentialsProvider;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class JGitEnvironmentRepositoryTests {
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    RefDatabase database = (RefDatabase)Mockito.mock(RefDatabase.class);
    private StandardEnvironment environment = new StandardEnvironment();
    private JGitEnvironmentRepository repository;
    private File basedir = new File("target/config");
    private final ObjectId newObjectId = ObjectId.fromRaw((int[])new int[]{1, 2, 3, 4, 5});

    @BeforeAll
    public static void initClass() {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
    }

    @BeforeEach
    public void init() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalRepo();
        this.repository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        this.repository.setUri(uri);
        if (this.basedir.exists()) {
            FileUtils.delete((File)this.basedir, (int)3);
        }
    }

    @Test
    public void vanilla() {
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void nested() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("another-config-repo");
        this.repository.setUri(uri);
        this.repository.setSearchPaths(new String[]{"sub"});
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/sub/application.yml");
        this.assertVersion(environment);
    }

    @Test
    public void placeholderInSearchPath() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("another-config-repo");
        this.repository.setUri(uri);
        this.repository.setSearchPaths(new String[]{"{application}"});
        Environment environment = this.repository.findOne("sub", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/sub/application.yml");
        this.assertVersion(environment);
    }

    private void assertVersion(Environment environment) {
        String version = environment.getVersion();
        ((AbstractStringAssert)Assertions.assertThat((String)version).as("version was null", new Object[0])).isNotNull();
        TestCase.assertTrue((String)"version length was wrong", (version.length() >= 40 && version.length() <= 64 ? 1 : 0) != 0);
    }

    @Test
    @Disabled
    public void nestedPattern() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("another-config-repo");
        this.repository.setUri(uri);
        this.repository.setSearchPaths(new String[]{"sub*"});
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/sub/application.yml");
        this.assertVersion(environment);
    }

    @Test
    public void branch() {
        this.repository.setBasedir(this.basedir);
        Environment environment = this.repository.findOne("bar", "staging", "raw");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void tag() {
        this.repository.setBasedir(this.basedir);
        Environment environment = this.repository.findOne("bar", "staging", "foo");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void basedir() {
        this.repository.setBasedir(this.basedir);
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void basedirExists() throws Exception {
        Assertions.assertThat((boolean)this.basedir.mkdirs()).isTrue();
        Assertions.assertThat((boolean)new File(this.basedir, ".nothing").createNewFile()).isTrue();
        this.repository.setBasedir(this.basedir);
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void uriWithHostOnly() throws Exception {
        this.repository.setUri("git://localhost");
        Assertions.assertThat((String)this.repository.getUri()).isEqualTo("git://localhost/");
    }

    @Test
    public void uriWithHostAndPath() throws Exception {
        this.repository.setUri("git://localhost/foo/");
        Assertions.assertThat((String)this.repository.getUri()).isEqualTo("git://localhost/foo");
    }

    @Test
    public void testBranchEndsWithTag() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("branch-with-slash-repo");
        this.repository.setUri(uri);
        Environment environment = this.repository.findOne("bar", "staging", "feature/foo");
        this.assertVersion(environment);
        environment = this.repository.findOne("bar", "staging", "foo");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("key")).isEqualTo((Object)"value from tag");
    }

    @Test
    public void afterPropertiesSet_CloneOnStartTrue_CloneAndFetchCalled() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)1))).call();
    }

    @Test
    public void afterPropertiesSet_CloneOnStartFalse_CloneAndFetchNotCalled() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.afterPropertiesSet();
        ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)0))).call();
        ((Git)Mockito.verify((Object)mockGit, (VerificationMode)Mockito.times((int)0))).fetch();
    }

    @Test
    public void afterPropertiesSet_CloneOnStartTrueWithFileURL_CloneAndFetchNotCalled() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("file://somefilesystem/somegitrepo");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)0))).call();
        ((Git)Mockito.verify((Object)mockGit, (VerificationMode)Mockito.times((int)0))).fetch();
    }

    @Test
    public void shouldPullForcepullNotClean() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)false);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        repo.setForcePull(true);
        boolean shouldPull = repo.shouldPull(git);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldPull).as("shouldPull was false", new Object[0])).isTrue();
    }

    @Test
    public void shouldPullNotClean() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)false);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        boolean shouldPull = repo.shouldPull(git);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldPull).as("shouldPull was true", new Object[0])).isFalse();
    }

    @Test
    public void shouldPullTruncatedIndexForcePull() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        ResetCommand resetCommand = (ResetCommand)Mockito.mock(ResetCommand.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenThrow(new Throwable[]{new JGitInternalException("Short read of block.")}).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        Mockito.when((Object)git.reset()).thenReturn((Object)resetCommand);
        Mockito.when((Object)resetCommand.setMode((ResetCommand.ResetType)ArgumentMatchers.any())).thenReturn((Object)resetCommand);
        Mockito.when((Object)resetCommand.setRef((String)ArgumentMatchers.any())).thenReturn((Object)resetCommand);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        repo.setUri("");
        repo.setForcePull(true);
        boolean shouldPull = repo.shouldPull(git);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldPull).as("shouldPull was false", new Object[0])).isTrue();
    }

    @Test
    public void shouldPullTruncatedIndexNotForcePull() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenThrow(new Throwable[]{new JGitInternalException("Short read of block.")});
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        repo.setForcePull(false);
        try {
            boolean shouldPull = repo.shouldPull(git);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldPull).as("shouldPull did not fail", new Object[0])).isFalse();
        }
        catch (JGitInternalException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).as("shouldPull did not fail as expected", new Object[0])).isEqualTo("Short read of block.");
        }
    }

    @Test
    public void shouldPullTruncatedIndexResetFail() throws Exception {
        String mockThrownMessage = "__mock_thrown__";
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        ResetCommand resetCommand = (ResetCommand)Mockito.mock(ResetCommand.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenThrow(new Throwable[]{new JGitInternalException("__mock_thrown__")}).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        Mockito.when((Object)git.reset()).thenReturn((Object)resetCommand);
        Mockito.when((Object)resetCommand.call()).thenThrow(new Throwable[]{new GitAPIException(""){}});
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        try {
            repo.shouldPull(git);
            Assertions.fail((String)"shouldPull did not fail");
        }
        catch (JGitInternalException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).as("shouldPull did not fail as expected", new Object[0])).isEqualTo("__mock_thrown__");
        }
    }

    @Test
    public void shouldPullStatusFail() throws Exception {
        String mockThrownMessage = "__mock_thrown__";
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenThrow(new Throwable[]{new JGitInternalException("__mock_thrown__")});
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        try {
            repo.shouldPull(git);
            Assertions.fail((String)"shouldPull did not fail");
        }
        catch (JGitInternalException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).as("shouldPull did not fail as expected", new Object[0])).isEqualTo("__mock_thrown__");
        }
    }

    @Test
    public void shouldPullClean() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        boolean shouldPull = repo.shouldPull(git);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldPull).as("shouldPull was false", new Object[0])).isTrue();
    }

    @Test
    public void shouldNotRefresh() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        JGitEnvironmentProperties properties = new JGitEnvironmentProperties();
        properties.setRefreshRate(2);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, properties, ObservationRegistry.NOOP);
        repo.setLastRefresh(System.currentTimeMillis() - 5000L);
        boolean shouldPull = repo.shouldPull(git);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldPull).as("shouldPull was false", new Object[0])).isTrue();
        repo.setRefreshRate(30);
        shouldPull = repo.shouldPull(git);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldPull).as("shouldPull was true", new Object[0])).isFalse();
    }

    @Test
    public void shouldUpdateLastRefresh() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        FetchResult fetchResult = (FetchResult)Mockito.mock(FetchResult.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)fetchCommand.call()).thenReturn((Object)fetchResult);
        Mockito.when((Object)git.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        JGitEnvironmentProperties properties = new JGitEnvironmentProperties();
        properties.setRefreshRate(1000);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, properties, ObservationRegistry.NOOP);
        repo.setLastRefresh(0L);
        repo.fetch(git, "master");
        long timeDiff = System.currentTimeMillis() - repo.getLastRefresh();
        ((AbstractBooleanAssert)Assertions.assertThat((timeDiff < 1000L ? 1 : 0) != 0).as("time difference (" + timeDiff + ") was longer than 1 second", new Object[0])).isTrue();
    }

    @Test
    public void testFetchException() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        CloneCommand cloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        MockGitFactory factory = new MockGitFactory(git, cloneCommand);
        this.repository.setGitFactory((JGitEnvironmentRepository.JGitFactory)factory);
        this.repository.setDeleteUntrackedBranches(true);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Repository repository = this.stubbedRepo();
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        Mockito.when((Object)git.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.setRemote(ArgumentMatchers.anyString())).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.call()).thenThrow(new Throwable[]{new InvalidRemoteException("invalid mock remote")});
        CheckoutCommand checkoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        ListBranchCommand listBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        Mockito.when((Object)git.checkout()).thenReturn((Object)checkoutCommand);
        Mockito.when((Object)git.branchList()).thenReturn((Object)listBranchCommand);
        ArrayList<Ref> refs = new ArrayList<Ref>();
        Ref ref = (Ref)Mockito.mock(Ref.class);
        refs.add(ref);
        Mockito.when((Object)ref.getName()).thenReturn((Object)"/master");
        Mockito.when((Object)listBranchCommand.call()).thenReturn(refs);
        MergeCommand mergeCommand = (MergeCommand)Mockito.mock(MergeCommand.class);
        Mockito.when((Object)git.merge()).thenReturn((Object)mergeCommand);
        Mockito.when((Object)mergeCommand.call()).thenThrow(new Throwable[]{new NotMergedException()});
        SearchPathLocator.Locations locations = this.repository.getLocations("bar", "staging", null);
        Assertions.assertThat((String)this.newObjectId.getName()).isEqualTo(locations.getVersion());
        ((Git)Mockito.verify((Object)git, (VerificationMode)Mockito.times((int)0))).branchDelete();
    }

    private Repository stubbedRepo() {
        return (Repository)Mockito.spy((Object)new Repository(new BaseRepositoryBuilder()){
            private String id;
            {
                this.id = UUID.randomUUID().toString();
            }

            public void create(boolean bare) throws IOException {
            }

            public String getIdentifier() {
                return this.id;
            }

            public ObjectDatabase getObjectDatabase() {
                return null;
            }

            public RefDatabase getRefDatabase() {
                RefDatabase database = (RefDatabase)Mockito.mock(RefDatabase.class);
                Ref headRef = (Ref)Mockito.mock(Ref.class);
                ObjectId newObjectId = ObjectId.fromRaw((int[])new int[]{1, 2, 3, 4, 5});
                Mockito.when((Object)headRef.getObjectId()).thenReturn((Object)newObjectId);
                try {
                    Mockito.when((Object)database.findRef(ArgumentMatchers.anyString())).thenReturn((Object)headRef);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return database;
            }

            public StoredConfig getConfig() {
                return null;
            }

            public AttributesNodeProvider createAttributesNodeProvider() {
                return null;
            }

            public void scanForRepoChanges() throws IOException {
            }

            public void notifyIndexChanged(boolean internal) {
            }

            public ReflogReader getReflogReader(String refName) throws IOException {
                return null;
            }
        });
    }

    @Test
    public void testMergeException() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        CloneCommand cloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        MockGitFactory factory = new MockGitFactory(git, cloneCommand);
        this.repository.setGitFactory((JGitEnvironmentRepository.JGitFactory)factory);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Repository repository = this.stubbedRepo();
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        FetchResult fetchResult = (FetchResult)Mockito.mock(FetchResult.class);
        Mockito.when((Object)git.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.setRemote(ArgumentMatchers.anyString())).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.call()).thenReturn((Object)fetchResult);
        Mockito.when((Object)fetchResult.getTrackingRefUpdates()).thenReturn(Collections.emptyList());
        CheckoutCommand checkoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        ListBranchCommand listBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        Mockito.when((Object)git.checkout()).thenReturn((Object)checkoutCommand);
        Mockito.when((Object)git.branchList()).thenReturn((Object)listBranchCommand);
        ArrayList<Ref> refs = new ArrayList<Ref>();
        Ref ref = (Ref)Mockito.mock(Ref.class);
        refs.add(ref);
        Mockito.when((Object)ref.getName()).thenReturn((Object)"/master");
        Mockito.when((Object)listBranchCommand.call()).thenReturn(refs);
        MergeCommand mergeCommand = (MergeCommand)Mockito.mock(MergeCommand.class);
        Mockito.when((Object)git.merge()).thenReturn((Object)mergeCommand);
        Mockito.when((Object)mergeCommand.call()).thenThrow(new Throwable[]{new NotMergedException()});
        SearchPathLocator.Locations locations = this.repository.getLocations("bar", "staging", "master");
        Assertions.assertThat((String)this.newObjectId.getName()).isEqualTo(locations.getVersion());
        ((Git)Mockito.verify((Object)git, (VerificationMode)Mockito.times((int)0))).branchDelete();
    }

    @Test
    public void testRefreshWithoutFetch() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        CloneCommand cloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)cloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)cloneCommand);
        Mockito.when((Object)cloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)cloneCommand);
        Mockito.when((Object)cloneCommand.call()).thenReturn((Object)git);
        MockGitFactory factory = new MockGitFactory(git, cloneCommand);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        CheckoutCommand checkoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Repository repository = (Repository)Mockito.mock(Repository.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Ref ref = (Ref)Mockito.mock(Ref.class);
        ListBranchCommand listBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        FetchResult fetchResult = (FetchResult)Mockito.mock(FetchResult.class);
        Ref branch1Ref = (Ref)Mockito.mock(Ref.class);
        Mockito.when((Object)git.branchList()).thenReturn((Object)listBranchCommand);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        Mockito.when((Object)git.checkout()).thenReturn((Object)checkoutCommand);
        Mockito.when((Object)git.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)git.merge()).thenReturn((Object)((MergeCommand)Mockito.mock(MergeCommand.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)checkoutCommand.call()).thenReturn((Object)ref);
        Mockito.when((Object)listBranchCommand.call()).thenReturn(Arrays.asList(branch1Ref));
        Mockito.when((Object)fetchCommand.call()).thenReturn((Object)fetchResult);
        Mockito.when((Object)branch1Ref.getName()).thenReturn((Object)"refs/remotes/origin/master");
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        JGitEnvironmentRepository repo = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        repo.setGitFactory((JGitEnvironmentRepository.JGitFactory)factory);
        repo.setUri("http://somegitserver/somegitrepo");
        repo.setBasedir(this.basedir);
        repo.setLastRefresh(System.currentTimeMillis() - 100L);
        repo.setRefreshRate(2);
        repo.refresh("master");
        ((Git)Mockito.verify((Object)git, (VerificationMode)Mockito.times((int)0))).fetch();
        ((Git)Mockito.verify((Object)git)).merge();
    }

    @Test
    public void testResetHardException() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        CloneCommand cloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        MockGitFactory factory = new MockGitFactory(git, cloneCommand);
        this.repository.setGitFactory((JGitEnvironmentRepository.JGitFactory)factory);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Repository repository = this.stubbedRepo();
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true).thenReturn((Object)false);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        FetchResult fetchResult = (FetchResult)Mockito.mock(FetchResult.class);
        Mockito.when((Object)git.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.setRemote(ArgumentMatchers.anyString())).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.call()).thenReturn((Object)fetchResult);
        Mockito.when((Object)fetchResult.getTrackingRefUpdates()).thenReturn(Collections.emptyList());
        CheckoutCommand checkoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        ListBranchCommand listBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        Mockito.when((Object)git.checkout()).thenReturn((Object)checkoutCommand);
        Mockito.when((Object)git.branchList()).thenReturn((Object)listBranchCommand);
        ArrayList<Ref> refs = new ArrayList<Ref>();
        Ref ref = (Ref)Mockito.mock(Ref.class);
        refs.add(ref);
        Mockito.when((Object)ref.getName()).thenReturn((Object)"/master");
        Mockito.when((Object)listBranchCommand.call()).thenReturn(refs);
        MergeCommand mergeCommand = (MergeCommand)Mockito.mock(MergeCommand.class);
        Mockito.when((Object)git.merge()).thenReturn((Object)mergeCommand);
        Mockito.when((Object)mergeCommand.call()).thenThrow(new Throwable[]{new NotMergedException()});
        ResetCommand resetCommand = (ResetCommand)Mockito.mock(ResetCommand.class);
        Mockito.when((Object)git.reset()).thenReturn((Object)resetCommand);
        Mockito.when((Object)resetCommand.call()).thenReturn((Object)ref);
        SearchPathLocator.Locations locations = this.repository.getLocations("bar", "staging", "master");
        Assertions.assertThat((String)this.newObjectId.getName()).isEqualTo(locations.getVersion());
        ((Git)Mockito.verify((Object)git, (VerificationMode)Mockito.times((int)0))).branchDelete();
    }

    @Test
    public void shouldDeleteBaseDirWhenCloneFails() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.call()).thenThrow(new Throwable[]{new TransportException("failed to clone")});
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setBasedir(this.basedir);
        try {
            envRepository.findOne("bar", "staging", "master");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((AbstractBooleanAssert)Assertions.assertThat((this.basedir.listFiles().length > 0 ? 1 : 0) != 0).as("baseDir should be deleted when clone fails", new Object[0])).isFalse();
    }

    @Test
    public void usernamePasswordShouldSetCredentials() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        MockCloneCommand mockCloneCommand = new MockCloneCommand(mockGit);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("git+ssh://git@somegitserver/somegitrepo");
        envRepository.setBasedir(new File("./mybasedir"));
        String username = "someuser";
        String password = "mypassword";
        envRepository.setUsername("someuser");
        envRepository.setPassword("mypassword");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        TestCase.assertTrue((boolean)(mockCloneCommand.getCredentialsProvider() instanceof UsernamePasswordCredentialsProvider));
        CredentialsProvider provider = mockCloneCommand.getCredentialsProvider();
        CredentialItem.Username usernameCredential = new CredentialItem.Username();
        CredentialItem.Password passwordCredential = new CredentialItem.Password();
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{usernameCredential})).isTrue();
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{passwordCredential})).isTrue();
        provider.get(new URIish(), new CredentialItem[]{usernameCredential});
        Assertions.assertThat((String)"someuser").isEqualTo(usernameCredential.getValue());
        provider.get(new URIish(), new CredentialItem[]{passwordCredential});
        Assertions.assertThat((String)"mypassword").isEqualTo(String.valueOf(passwordCredential.getValue()));
    }

    @Test
    public void passphraseShouldSetCredentials() throws Exception {
        String passphrase = "mypassphrase";
        Git mockGit = (Git)Mockito.mock(Git.class);
        MockCloneCommand mockCloneCommand = new MockCloneCommand(mockGit);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("git+ssh://git@somegitserver/somegitrepo");
        envRepository.setBasedir(new File("./mybasedir"));
        envRepository.setPassphrase("mypassphrase");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        Assertions.assertThat((boolean)mockCloneCommand.hasPassphraseCredentialsProvider()).isTrue();
        CredentialsProvider provider = mockCloneCommand.getCredentialsProvider();
        Assertions.assertThat((boolean)provider.isInteractive()).isFalse();
        CredentialItem.Password credential = new CredentialItem.Password("Passphrase");
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{credential})).isTrue();
        provider.get(new URIish(), new CredentialItem[]{credential});
        Assertions.assertThat((char[])"mypassphrase".toCharArray()).isEqualTo((Object)credential.getValue());
    }

    @Test
    public void gitCredentialsProviderFactoryCreatesPassphraseProvider() throws Exception {
        String passphrase = "mypassphrase";
        String gitUri = "git+ssh://git@somegitserver/somegitrepo";
        Git mockGit = (Git)Mockito.mock(Git.class);
        MockCloneCommand mockCloneCommand = new MockCloneCommand(mockGit);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("git+ssh://git@somegitserver/somegitrepo");
        envRepository.setBasedir(new File("./mybasedir"));
        envRepository.setPassphrase("mypassphrase");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        Assertions.assertThat((boolean)mockCloneCommand.hasPassphraseCredentialsProvider()).isTrue();
        CredentialsProvider provider = mockCloneCommand.getCredentialsProvider();
        Assertions.assertThat((boolean)provider.isInteractive()).isFalse();
        CredentialItem.InformationalMessage informational = new CredentialItem.InformationalMessage("Passphrase required for ssh key");
        CredentialItem.Password credential = new CredentialItem.Password("Passphrase");
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{credential})).isTrue();
        provider.get(new URIish(), new CredentialItem[]{informational, credential});
        Assertions.assertThat((char[])"mypassphrase".toCharArray()).isEqualTo((Object)credential.getValue());
    }

    @Test
    public void gitCredentialsProviderFactoryCreatesUsernamePasswordProvider() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        MockCloneCommand mockCloneCommand = new MockCloneCommand(mockGit);
        String username = "someuser";
        String password = "mypassword";
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("git+ssh://git@somegitserver/somegitrepo");
        envRepository.setBasedir(new File("./mybasedir"));
        envRepository.setUsername("someuser");
        envRepository.setPassword("mypassword");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        TestCase.assertTrue((boolean)(mockCloneCommand.getCredentialsProvider() instanceof UsernamePasswordCredentialsProvider));
        CredentialsProvider provider = mockCloneCommand.getCredentialsProvider();
        CredentialItem.Username usernameCredential = new CredentialItem.Username();
        CredentialItem.Password passwordCredential = new CredentialItem.Password();
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{usernameCredential})).isTrue();
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{passwordCredential})).isTrue();
        provider.get(new URIish(), new CredentialItem[]{usernameCredential});
        Assertions.assertThat((String)"someuser").isEqualTo(usernameCredential.getValue());
        provider.get(new URIish(), new CredentialItem[]{passwordCredential});
        Assertions.assertThat((String)"mypassword").isEqualTo(String.valueOf(passwordCredential.getValue()));
    }

    @Test
    public void gitCredentialsProviderFactoryCreatesAwsCodeCommitProvider() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        MockCloneCommand mockCloneCommand = new MockCloneCommand(mockGit);
        String awsUri = "https://git-codecommit.us-east-1.amazonaws.com/v1/repos/test";
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("https://git-codecommit.us-east-1.amazonaws.com/v1/repos/test");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        TestCase.assertTrue((boolean)(mockCloneCommand.getCredentialsProvider() instanceof AwsCodeCommitCredentialProvider));
    }

    @Test
    public void gitCredentialsProviderFactoryCreatesSkipSslValidationProvider() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        MockCloneCommand mockCloneCommand = new MockCloneCommand(mockGit);
        String username = "someuser";
        String password = "mypassword";
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("https://somegitserver/somegitrepo");
        envRepository.setBasedir(new File("./mybasedir"));
        envRepository.setUsername("someuser");
        envRepository.setPassword("mypassword");
        envRepository.setSkipSslValidation(true);
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        CredentialsProvider provider = mockCloneCommand.getCredentialsProvider();
        Assertions.assertThat((boolean)(provider instanceof GitSkipSslValidationCredentialsProvider)).isTrue();
        CredentialItem.Username usernameCredential = new CredentialItem.Username();
        CredentialItem.Password passwordCredential = new CredentialItem.Password();
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{usernameCredential})).isTrue();
        Assertions.assertThat((boolean)provider.supports(new CredentialItem[]{passwordCredential})).isTrue();
        provider.get(new URIish(), new CredentialItem[]{usernameCredential});
        Assertions.assertThat((String)"someuser").isEqualTo(usernameCredential.getValue());
        provider.get(new URIish(), new CredentialItem[]{passwordCredential});
        Assertions.assertThat((String)"mypassword").isEqualTo(String.valueOf(passwordCredential.getValue()));
    }

    @Test
    public void shouldPrintStacktraceIfDebugEnabled() throws Exception {
        final Log mockLogger = (Log)Mockito.mock(Log.class);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP){

            public void afterPropertiesSet() throws Exception {
                this.logger = mockLogger;
            }
        };
        envRepository.afterPropertiesSet();
        Mockito.when((Object)mockLogger.isDebugEnabled()).thenReturn((Object)true);
        envRepository.warn("", (Exception)new RuntimeException());
        ((Log)Mockito.verify((Object)mockLogger)).warn(ArgumentMatchers.eq((Object)""));
        ((Log)Mockito.verify((Object)mockLogger)).debug(ArgumentMatchers.eq((Object)"Stacktrace for: "), (Throwable)ArgumentMatchers.any(RuntimeException.class));
        int numberOfInvocations = Mockito.mockingDetails((Object)mockLogger).getInvocations().size();
        ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfInvocations).as("should call isDebugEnabled warn and debug", new Object[0])).isEqualTo(3);
    }

    @Test
    public void shouldSetTransportConfigCallbackOnCloneAndFetch() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        Mockito.when((Object)mockGit.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.call()).thenReturn((Object)((FetchResult)Mockito.mock(FetchResult.class)));
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        TransportConfigCallback configCallback = (TransportConfigCallback)Mockito.mock(TransportConfigCallback.class);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setTransportConfigCallback(configCallback);
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)1))).setTransportConfigCallback(configCallback);
        envRepository.fetch(mockGit, "master");
        ((FetchCommand)Mockito.verify((Object)fetchCommand, (VerificationMode)Mockito.times((int)1))).setTransportConfigCallback(configCallback);
    }

    @Test
    public void shouldSetRemoveBranchesFlagToFetchCommand() throws Exception {
        Git mockGit = (Git)Mockito.mock(Git.class);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        Mockito.when((Object)mockGit.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.call()).thenReturn((Object)((FetchResult)Mockito.mock(FetchResult.class)));
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, (CloneCommand)Mockito.mock(CloneCommand.class)));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setDeleteUntrackedBranches(true);
        envRepository.fetch(mockGit, "master");
        ((FetchCommand)Mockito.verify((Object)fetchCommand, (VerificationMode)Mockito.times((int)1))).setRemoveDeletedRefs(true);
        ((FetchCommand)Mockito.verify((Object)fetchCommand, (VerificationMode)Mockito.times((int)1))).call();
    }

    @Test
    public void shouldHandleExceptionWhileRemovingBranches() throws Exception {
        Git git = (Git)Mockito.mock(Git.class);
        CloneCommand cloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        MockGitFactory factory = new MockGitFactory(git, cloneCommand);
        this.repository.setGitFactory((JGitEnvironmentRepository.JGitFactory)factory);
        this.repository.setDeleteUntrackedBranches(true);
        StatusCommand statusCommand = (StatusCommand)Mockito.mock(StatusCommand.class);
        Status status = (Status)Mockito.mock(Status.class);
        Mockito.when((Object)git.status()).thenReturn((Object)statusCommand);
        Repository repository = this.stubbedRepo();
        Mockito.when((Object)git.getRepository()).thenReturn((Object)repository);
        StoredConfig storedConfig = (StoredConfig)Mockito.mock(StoredConfig.class);
        Mockito.when((Object)repository.getConfig()).thenReturn((Object)storedConfig);
        Mockito.when((Object)storedConfig.getString("remote", "origin", "url")).thenReturn((Object)"http://example/git");
        Mockito.when((Object)statusCommand.call()).thenReturn((Object)status);
        Mockito.when((Object)status.isClean()).thenReturn((Object)true);
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class);
        FetchResult fetchResult = (FetchResult)Mockito.mock(FetchResult.class);
        TrackingRefUpdate trackingRefUpdate = (TrackingRefUpdate)Mockito.mock(TrackingRefUpdate.class);
        List<TrackingRefUpdate> trackingRefUpdates = Collections.singletonList(trackingRefUpdate);
        Mockito.when((Object)git.fetch()).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.setRemote(ArgumentMatchers.anyString())).thenReturn((Object)fetchCommand);
        Mockito.when((Object)fetchCommand.call()).thenReturn((Object)fetchResult);
        Mockito.when((Object)fetchResult.getTrackingRefUpdates()).thenReturn(trackingRefUpdates);
        ReceiveCommand receiveCommand = (ReceiveCommand)Mockito.mock(ReceiveCommand.class);
        Mockito.when((Object)trackingRefUpdate.asReceiveCommand()).thenReturn((Object)receiveCommand);
        Mockito.when((Object)receiveCommand.getType()).thenReturn((Object)ReceiveCommand.Type.DELETE);
        Mockito.when((Object)trackingRefUpdate.getLocalName()).thenReturn((Object)"refs/remotes/origin/feature/deletedBranchFromOrigin");
        DeleteBranchCommand deleteBranchCommand = (DeleteBranchCommand)Mockito.mock(DeleteBranchCommand.class);
        Mockito.when((Object)git.branchDelete()).thenReturn((Object)deleteBranchCommand);
        Mockito.when((Object)deleteBranchCommand.setBranchNames(new String[]{(String)ArgumentMatchers.eq((Object)"feature/deletedBranchFromOrigin")})).thenReturn((Object)deleteBranchCommand);
        Mockito.when((Object)deleteBranchCommand.setForce(true)).thenReturn((Object)deleteBranchCommand);
        Mockito.when((Object)deleteBranchCommand.call()).thenThrow(new Throwable[]{new NotMergedException()});
        CheckoutCommand checkoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        ListBranchCommand listBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        Mockito.when((Object)git.checkout()).thenReturn((Object)checkoutCommand);
        Mockito.when((Object)git.branchList()).thenReturn((Object)listBranchCommand);
        ArrayList<Ref> refs = new ArrayList<Ref>();
        Ref ref = (Ref)Mockito.mock(Ref.class);
        refs.add(ref);
        Mockito.when((Object)ref.getName()).thenReturn((Object)"/master");
        Mockito.when((Object)listBranchCommand.call()).thenReturn(refs);
        MergeResult mergeResult = (MergeResult)Mockito.mock(MergeResult.class);
        MergeResult.MergeStatus mergeStatus = (MergeResult.MergeStatus)Mockito.mock(MergeResult.MergeStatus.class);
        MergeCommand mergeCommand = (MergeCommand)Mockito.mock(MergeCommand.class);
        Mockito.when((Object)git.merge()).thenReturn((Object)mergeCommand);
        Mockito.when((Object)mergeCommand.call()).thenReturn((Object)mergeResult);
        Mockito.when((Object)mergeResult.getMergeStatus()).thenReturn((Object)mergeStatus);
        Mockito.when((Object)mergeStatus.isSuccessful()).thenReturn((Object)true);
        SearchPathLocator.Locations locations = this.repository.getLocations("bar", "staging", "master");
        Assertions.assertThat((String)this.newObjectId.getName()).isEqualTo(locations.getVersion());
        ((DeleteBranchCommand)Mockito.verify((Object)deleteBranchCommand)).setBranchNames(new String[]{(String)ArgumentMatchers.eq((Object)"feature/deletedBranchFromOrigin")});
        ((DeleteBranchCommand)Mockito.verify((Object)deleteBranchCommand)).setForce(true);
        ((DeleteBranchCommand)Mockito.verify((Object)deleteBranchCommand)).call();
    }

    @Test
    public void afterPropertiesSet_CloneOnStartTrue_DefaultLabelSet_CloneAndCheckoutCalled() throws Exception {
        String LABEL_TO_CHECKOUT = "release";
        Repository mockRepository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)mockRepository.getBranch()).thenReturn((Object)"master");
        Git mockGit = (Git)Mockito.mock(Git.class);
        Mockito.when((Object)mockGit.getRepository()).thenReturn((Object)mockRepository);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        ListBranchCommand mockListBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        CheckoutCommand mockCheckoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        Mockito.when((Object)mockGit.checkout()).thenReturn((Object)mockCheckoutCommand);
        Mockito.when((Object)mockGit.branchList()).thenReturn((Object)mockListBranchCommand);
        ArrayList<Ref> repositoryRefsList = new ArrayList<Ref>();
        Ref mockMasterRef = (Ref)Mockito.mock(Ref.class);
        repositoryRefsList.add(mockMasterRef);
        Mockito.when((Object)mockMasterRef.getName()).thenReturn((Object)"refs/remotes/origin/master");
        Ref mockReleaseRef = (Ref)Mockito.mock(Ref.class);
        repositoryRefsList.add(mockReleaseRef);
        Mockito.when((Object)mockReleaseRef.getName()).thenReturn((Object)"refs/remotes/origin/release");
        Mockito.when((Object)mockListBranchCommand.call()).thenReturn(repositoryRefsList);
        Mockito.when((Object)mockCheckoutCommand.call()).thenReturn((Object)mockReleaseRef);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setCloneOnStart(true);
        envRepository.setDefaultLabel("release");
        envRepository.afterPropertiesSet();
        ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)1))).call();
        ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)1))).call();
        ((ListBranchCommand)Mockito.verify((Object)mockListBranchCommand, (VerificationMode)Mockito.times((int)2))).call();
        ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)1))).setName(ArgumentMatchers.anyString());
    }

    @Test
    public void tryMasterBranch() throws Exception {
        Repository mockRepository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)mockRepository.getBranch()).thenReturn((Object)"master");
        Git mockGit = (Git)Mockito.mock(Git.class);
        Mockito.when((Object)mockGit.getRepository()).thenReturn((Object)mockRepository);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        ListBranchCommand mockListBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        CheckoutCommand mockCheckoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        Mockito.when((Object)mockGit.checkout()).thenReturn((Object)mockCheckoutCommand);
        Mockito.when((Object)mockGit.branchList()).thenReturn((Object)mockListBranchCommand);
        ArrayList<Ref> repositoryRefsList = new ArrayList<Ref>();
        Ref mockMasterRef = (Ref)Mockito.mock(Ref.class);
        repositoryRefsList.add(mockMasterRef);
        Mockito.when((Object)mockMasterRef.getName()).thenReturn((Object)"refs/remotes/origin/master");
        Mockito.when((Object)mockListBranchCommand.call()).thenReturn(repositoryRefsList);
        Mockito.when((Object)mockCheckoutCommand.call()).thenThrow(new Throwable[]{new RefNotFoundException("Ref main cannot be resolved")}).thenReturn((Object)mockMasterRef);
        JGitEnvironmentProperties properties = new JGitEnvironmentProperties();
        properties.setTryMasterBranch(true);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, properties, ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setCloneOnStart(true);
        envRepository.afterPropertiesSet();
        ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)1))).call();
        ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)2))).call();
        ((ListBranchCommand)Mockito.verify((Object)mockListBranchCommand, (VerificationMode)Mockito.times((int)3))).call();
        ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)1))).setName((String)ArgumentMatchers.eq((Object)"master"));
    }

    @Test
    public void doNotTryMasterBranch() throws Exception {
        Repository mockRepository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)mockRepository.getBranch()).thenReturn((Object)"master");
        Git mockGit = (Git)Mockito.mock(Git.class);
        Mockito.when((Object)mockGit.getRepository()).thenReturn((Object)mockRepository);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        ListBranchCommand mockListBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        CheckoutCommand mockCheckoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        Mockito.when((Object)mockGit.checkout()).thenReturn((Object)mockCheckoutCommand);
        Mockito.when((Object)mockGit.branchList()).thenReturn((Object)mockListBranchCommand);
        ArrayList<Ref> repositoryRefsList = new ArrayList<Ref>();
        Ref mockMasterRef = (Ref)Mockito.mock(Ref.class);
        repositoryRefsList.add(mockMasterRef);
        Mockito.when((Object)mockMasterRef.getName()).thenReturn((Object)"/master");
        Mockito.when((Object)mockListBranchCommand.call()).thenReturn(repositoryRefsList);
        Mockito.when((Object)mockCheckoutCommand.call()).thenThrow(new Throwable[]{new RefNotFoundException("Ref main cannot be resolved")}).thenReturn((Object)mockMasterRef);
        JGitEnvironmentProperties properties = new JGitEnvironmentProperties();
        properties.setTryMasterBranch(false);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, properties, ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setCloneOnStart(true);
        try {
            envRepository.afterPropertiesSet();
        }
        catch (RefNotFoundException e) {
            ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)1))).call();
            ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)1))).call();
            ((ListBranchCommand)Mockito.verify((Object)mockListBranchCommand, (VerificationMode)Mockito.times((int)1))).call();
            ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)1))).setName((String)ArgumentMatchers.eq((Object)"main"));
        }
    }

    @Test
    public void afterPropertiesSet_CloneOnStartTrue_DefaultLabelSameAsDefaultBranch_CheckoutNotCalled() throws Exception {
        String LABEL_TO_CHECKOUT = "master";
        Repository mockRepository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)mockRepository.getBranch()).thenReturn((Object)"master");
        Git mockGit = (Git)Mockito.mock(Git.class);
        Mockito.when((Object)mockGit.getRepository()).thenReturn((Object)mockRepository);
        CloneCommand mockCloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class);
        Mockito.when((Object)mockCloneCommand.setURI(ArgumentMatchers.anyString())).thenReturn((Object)mockCloneCommand);
        Mockito.when((Object)mockCloneCommand.setDirectory((File)ArgumentMatchers.any(File.class))).thenReturn((Object)mockCloneCommand);
        ListBranchCommand mockListBranchCommand = (ListBranchCommand)Mockito.mock(ListBranchCommand.class);
        CheckoutCommand mockCheckoutCommand = (CheckoutCommand)Mockito.mock(CheckoutCommand.class);
        Mockito.when((Object)mockGit.checkout()).thenReturn((Object)mockCheckoutCommand);
        Mockito.when((Object)mockGit.branchList()).thenReturn((Object)mockListBranchCommand);
        ArrayList<Ref> repositoryRefsList = new ArrayList<Ref>();
        Ref mockMasterRef = (Ref)Mockito.mock(Ref.class);
        repositoryRefsList.add(mockMasterRef);
        Mockito.when((Object)mockMasterRef.getName()).thenReturn((Object)"/master");
        Ref mockReleaseRef = (Ref)Mockito.mock(Ref.class);
        repositoryRefsList.add(mockReleaseRef);
        Mockito.when((Object)mockReleaseRef.getName()).thenReturn((Object)"/release");
        Mockito.when((Object)mockListBranchCommand.call()).thenReturn(repositoryRefsList);
        Mockito.when((Object)mockCheckoutCommand.call()).thenReturn((Object)mockReleaseRef);
        JGitEnvironmentRepository envRepository = new JGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new JGitEnvironmentProperties(), ObservationRegistry.NOOP);
        envRepository.setGitFactory((JGitEnvironmentRepository.JGitFactory)new MockGitFactory(mockGit, mockCloneCommand));
        envRepository.setUri("http://somegitserver/somegitrepo");
        envRepository.setCloneOnStart(true);
        envRepository.setDefaultLabel("master");
        envRepository.afterPropertiesSet();
        ((CloneCommand)Mockito.verify((Object)mockCloneCommand, (VerificationMode)Mockito.times((int)1))).call();
        ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)0))).call();
        ((ListBranchCommand)Mockito.verify((Object)mockListBranchCommand, (VerificationMode)Mockito.times((int)0))).call();
        ((CheckoutCommand)Mockito.verify((Object)mockCheckoutCommand, (VerificationMode)Mockito.times((int)0))).setName(ArgumentMatchers.anyString());
    }

    class MockGitFactory
    extends JGitEnvironmentRepository.JGitFactory {
        private Git mockGit;
        private CloneCommand mockCloneCommand;

        MockGitFactory(Git mockGit, CloneCommand mockCloneCommand) {
            this.mockGit = mockGit;
            this.mockCloneCommand = mockCloneCommand;
        }

        public Git getGitByOpen(File file) throws IOException {
            return this.mockGit;
        }

        public CloneCommand getCloneCommandByCloneRepository() {
            return this.mockCloneCommand;
        }
    }

    class MockCloneCommand
    extends CloneCommand {
        private Git mockGit;

        MockCloneCommand(Git mockGit) {
            this.mockGit = mockGit;
        }

        public Git call() throws GitAPIException, InvalidRemoteException {
            return this.mockGit;
        }

        public boolean hasPassphraseCredentialsProvider() {
            return this.credentialsProvider instanceof PassphraseCredentialsProvider;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }
    }
}

