/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.assertj.AssertableWebApplicationContext;
import org.springframework.boot.test.context.runner.ContextConsumer;
import org.springframework.boot.test.context.runner.WebApplicationContextRunner;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepository;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.dao.DataAccessException;

public class JdbcEnvironmentRepositoryConfigurationTests {
    @Test
    public void jdbcEnvironmentRepositoryBeansConfiguredWhenDefault() throws IOException {
        ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active=test,jdbc", "spring.main.web-application-type=none"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(JdbcEnvironmentRepositoryFactory.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(JdbcEnvironmentRepository.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(JdbcEnvironmentRepository.PropertiesResultSetExtractor.class);
        });
    }

    @Test
    public void jdbcEnvironmentRepositoryBeansConfiguredWitCustomResultSetExtractor() {
        ((WebApplicationContextRunner)((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withBean(CustomResultSetExtractor.class, CustomResultSetExtractor::new, new BeanDefinitionCustomizer[0])).withPropertyValues(new String[]{"spring.profiles.active=test,jdbc", "spring.main.web-application-type=none"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(JdbcEnvironmentRepositoryFactory.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(JdbcEnvironmentRepository.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(CustomResultSetExtractor.class);
        });
    }

    @Test
    public void jdbcEnvironmentRepositoryBeansConfiguredWhenEnabled() throws IOException {
        this.getApplicationContextWithJdbcEnabled(true, (ContextConsumer<? super AssertableWebApplicationContext>)((ContextConsumer)context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(JdbcEnvironmentRepositoryFactory.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(JdbcEnvironmentRepository.class);
        }));
    }

    @Test
    public void jdbcEnvironmentRepositoryFactoryNotConfiguredWhenDisabled() throws IOException {
        this.getApplicationContextWithJdbcEnabled(false, (ContextConsumer<? super AssertableWebApplicationContext>)((ContextConsumer)context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(JdbcEnvironmentRepositoryFactory.class)));
    }

    @Test
    public void jdbcEnvironmentRepositoryNotConfiguredWhenDisabled() throws IOException {
        this.getApplicationContextWithJdbcEnabled(false, (ContextConsumer<? super AssertableWebApplicationContext>)((ContextConsumer)context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(JdbcEnvironmentRepository.class)));
    }

    private void getApplicationContextWithJdbcEnabled(boolean jdbcEnabled, ContextConsumer<? super AssertableWebApplicationContext> consumer) throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo();
        ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active=test,jdbc", "spring.main.web-application-type=none", "spring.cloud.config.server.git.uri:" + uri, "spring.cloud.config.server.jdbc.enabled:" + jdbcEnabled})).run(consumer);
    }

    private static class CustomResultSetExtractor
    extends JdbcEnvironmentRepository.PropertiesResultSetExtractor {
        private CustomResultSetExtractor() {
        }

        public Map<String, Object> extractData(ResultSet rs) throws SQLException, DataAccessException {
            return super.extractData(rs);
        }
    }
}

