/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.List;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.sql.init.SqlInitializationAutoConfiguration;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentProperties;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepository;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(classes={ApplicationConfiguration.class}, properties={"logging.level.root=debug", "spring.sql.init.schema-locations=classpath:schema-jdbc.sql", "spring.sql.init.data-locations=classpath:data-jdbc.sql"})
@AutoConfigureTestDatabase
@DirtiesContext
public class JdbcEnvironmentRepositoryTests {
    @Autowired
    private DataSource dataSource;

    @Test
    public void basicProperties() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("foo", "bar", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"bar"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("foo-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"foo-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(2)).getName()).isEqualTo("foo");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(2)).getSource().get("a.b.c")).isEqualTo((Object)"foo-null");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(3)).getName()).isEqualTo("application");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(3)).getSource().get("a.b.c")).isEqualTo((Object)"application-null");
    }

    @Test
    public void testDefaultProfile() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("foo", "", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"default"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("foo-default");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"foo-default");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application-default");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-default");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(2)).getName()).isEqualTo("foo");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(2)).getSource().get("a.b.c")).isEqualTo((Object)"foo-null");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(3)).getName()).isEqualTo("application");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(3)).getSource().get("a.b.c")).isEqualTo((Object)"application-null");
    }

    @Test
    public void testProfileNotExist() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("foo", "not_exist", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"not_exist"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("foo");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"foo-null");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-null");
    }

    @Test
    public void testApplicationNotExist() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("not_exist", "bar", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("not_exist");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"bar"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("application-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"application-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-null");
    }

    @Test
    public void testApplicationProfileBothNotExist() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("not_exist", "not_exist", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("not_exist");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"not_exist"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("application");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"application-null");
    }

    @Test
    public void testCustomSql() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        properties.setSql("SELECT MY_KEY, MY_VALUE from MY_PROPERTIES where APPLICATION=? and PROFILE=? and LABEL=?");
        properties.setSqlWithoutProfile("SELECT MY_KEY, MY_VALUE from MY_PROPERTIES where APPLICATION=? and PROFILE is null and LABEL=?");
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("foo", "bar", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"bar"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("foo-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"foo-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(2)).getName()).isEqualTo("foo");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(2)).getSource().get("a.b.c")).isEqualTo((Object)"foo-null");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(3)).getName()).isEqualTo("application");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(3)).getSource().get("a.b.c")).isEqualTo((Object)"application-null");
    }

    @Test
    public void testIncompleteConfig() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        properties.setSql("SELECT MY_KEY, MY_VALUE from MY_PROPERTIES where APPLICATION=? and PROFILE=? and LABEL=?");
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("foo", "bar", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"default", "bar"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("foo-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"foo-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(2)).getName()).isEqualTo("foo-default");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(2)).getSource().get("a.b.c")).isEqualTo((Object)"foo-default");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(3)).getName()).isEqualTo("application-default");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(3)).getSource().get("a.b.c")).isEqualTo((Object)"application-default");
    }

    @Test
    public void testNotFailOnError() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        properties.setFailOnError(false);
        properties.setSql("SELECT MY_KEY, MY_VALUE from MY_PROPERTIES where APPLICATION=? and PROFILE=? and LABEL=?");
        properties.setSqlWithoutProfile("SELECT SHOULD_FAIL from TABLE_NOTEXIST where APPLICATION=? and PROFILE is null and LABEL=?");
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("foo", "bar", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"bar"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("master");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("foo-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"foo-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-bar");
    }

    @Test
    public void testFailOnError() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        properties.setSqlWithoutProfile("SELECT SHOULD_FAIL from TABLE_NOTEXIST where APPLICATION=? and PROFILE is null and LABEL=?");
        JdbcEnvironmentRepository repository = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties);
        Assertions.assertThatThrownBy(() -> repository.findOne("foo", "bar", "")).isInstanceOf(DataAccessException.class);
    }

    @Test
    public void testCustomLabel() {
        JdbcEnvironmentProperties properties = new JdbcEnvironmentProperties();
        properties.setDefaultLabel("main");
        Environment env = new JdbcEnvironmentRepository(new JdbcTemplate(this.dataSource), properties, new JdbcEnvironmentRepository.PropertiesResultSetExtractor()).findOne("foo", "bar", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((Object[])env.getProfiles()).isEqualTo((Object)new String[]{"bar"});
        Assertions.assertThat((String)env.getLabel()).isEqualTo("main");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("foo-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("a.b.c")).isEqualTo((Object)"foo-bar");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("application-bar");
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(1)).getSource().get("a.b.c")).isEqualTo((Object)"application-bar");
    }

    @ImportAutoConfiguration(value={SqlInitializationAutoConfiguration.class})
    @Configuration(proxyBeanMethods=false)
    protected static class ApplicationConfiguration {
        protected ApplicationConfiguration() {
        }
    }
}

