/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class MultipleJGitEnvironmentApplicationPlaceholderRepositoryTests {
    private StandardEnvironment environment = new StandardEnvironment();
    private MultipleJGitEnvironmentRepository repository = new MultipleJGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new MultipleJGitEnvironmentProperties(), ObservationRegistry.NOOP);

    @BeforeAll
    public static void initClass() {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
    }

    @BeforeEach
    public void init() throws Exception {
        String defaultUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        this.repository.setUri(defaultUri);
        this.repository.setRepos(this.createRepositories());
    }

    private Map<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository> createRepositories() throws Exception {
        String test1Uri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        ConfigServerTestUtils.prepareLocalRepo("test2-config-repo");
        HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository> repos = new HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository>();
        repos.put("templates", this.createRepository("test", "*-config-repo", test1Uri.replace("test1-config-repo", "{application}")));
        return repos;
    }

    private MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository createRepository(String name, String pattern, String uri) {
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo = new MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository(ObservationRegistry.NOOP);
        repo.setEnvironment((ConfigurableEnvironment)this.environment);
        repo.setName(name);
        repo.setPattern(new String[]{pattern});
        repo.setUri(uri);
        return repo;
    }

    @Test
    public void defaultRepo() {
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void missingRepo() {
        Environment environment = this.repository.findOne("missing-config-repo", "staging", "master");
        ((AbstractIntegerAssert)Assertions.assertThat((int)environment.getPropertySources().size()).as("Wrong property sources: " + environment, new Object[0])).isEqualTo(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/application.yml");
        this.assertVersion(environment);
    }

    @Test
    public void mappingRepo() {
        Environment environment = this.repository.findOne("test1-config-repo", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.getUri("*").replace("{application}", "test1-config-repo") + "/application.yml");
        this.assertVersion(environment);
    }

    @Test
    public void otherMappingRepo() {
        Environment environment = this.repository.findOne("test2-config-repo", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.getUri("*").replace("{application}", "test2-config-repo") + "/application.properties");
        this.assertVersion(environment);
    }

    @Test
    @Disabled(value="not supported yet (placeholders in search paths with lists)")
    public void profilesInSearchPaths() {
        this.repository.setSearchPaths(new String[]{"{profile}"});
        SearchPathLocator.Locations locations = this.repository.getLocations("foo", "dev,one,two", "master");
        Assertions.assertThat((int)locations.getLocations().length).isEqualTo(3);
        Assertions.assertThat((String)locations.getLocations()[0]).isEqualTo("classpath:/test/dev/");
    }

    private void assertVersion(Environment environment) {
        String version = environment.getVersion();
        ((AbstractStringAssert)Assertions.assertThat((String)version).as("version was null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((version.length() >= 40 && version.length() <= 64 ? 1 : 0) != 0).as("version length was wrong", new Object[0])).isTrue();
    }

    private String getUri(String pattern) {
        String uri = null;
        Map repoMappings = this.repository.getRepos();
        for (MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo : repoMappings.values()) {
            String[] mappingPattern = repo.getPattern();
            if (mappingPattern == null || mappingPattern.length == 0) continue;
            uri = repo.getUri();
            break;
        }
        return uri;
    }
}

