/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class MultipleJGitEnvironmentLabelPlaceholderRepositoryTests {
    private StandardEnvironment environment = new StandardEnvironment();
    private MultipleJGitEnvironmentRepository repository = new MultipleJGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new MultipleJGitEnvironmentProperties(), ObservationRegistry.NOOP);
    private String defaultUri;

    @BeforeAll
    public static void initClass() {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
    }

    @BeforeEach
    public void init() throws Exception {
        this.defaultUri = ConfigServerTestUtils.prepareLocalRepo("master-labeltest-config-repo");
        this.repository.setUri(this.defaultUri.replace("master-", "{label}-"));
    }

    @Test
    public void defaultRepo() {
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.defaultUri + "application.yml");
        this.assertVersion(environment);
    }

    @Test
    public void missingRepo() {
        Environment environment = this.repository.findOne("missing-config-repo", "staging", "master");
        ((AbstractIntegerAssert)Assertions.assertThat((int)environment.getPropertySources().size()).as("Wrong property sources: " + environment, new Object[0])).isEqualTo(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.defaultUri + "application.yml");
        this.assertVersion(environment);
    }

    @Test
    public void defaultLabelRepo() {
        Environment environment = this.repository.findOne("bar", "staging", null);
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.defaultUri + "application.yml");
        this.assertVersion(environment);
    }

    private void assertVersion(Environment environment) {
        String version = environment.getVersion();
        ((AbstractStringAssert)Assertions.assertThat((String)version).as("version was null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((version.length() >= 40 && version.length() <= 64 ? 1 : 0) != 0).as("version length was wrong", new Object[0])).isTrue();
    }
}

