/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.HashMap;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.ConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.support.GitCredentialsProviderFactory;
import org.springframework.cloud.config.server.support.TransportConfigCallbackFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class MultipleJGitEnvironmentRepositoryFactoryTests {
    private MultipleJGitEnvironmentRepositoryFactory multipleJGitEnvironmentRepositoryFactory;
    ConfigurableEnvironment environment = (ConfigurableEnvironment)Mockito.mock(ConfigurableEnvironment.class);
    ConfigServerProperties server = (ConfigServerProperties)Mockito.mock(ConfigServerProperties.class);
    Optional<ConfigurableHttpConnectionFactory> connectionFactory = Optional.empty();
    TransportConfigCallbackFactory transportConfigCallbackFactory = (TransportConfigCallbackFactory)Mockito.mock(TransportConfigCallbackFactory.class);
    GitCredentialsProviderFactory gitCredentialsProviderFactory;

    @Test
    public void buildGitCredentialsFactory() throws Exception {
        this.multipleJGitEnvironmentRepositoryFactory = new MultipleJGitEnvironmentRepositoryFactory(this.environment, this.server, this.connectionFactory, this.transportConfigCallbackFactory, this.gitCredentialsProviderFactory);
        MultipleJGitEnvironmentProperties multipleJGitEnvironmentProperties = new MultipleJGitEnvironmentProperties();
        HashMap<String, MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties> patternMatchingJGitEnvironmentPropertiesMap = new HashMap<String, MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties>();
        patternMatchingJGitEnvironmentPropertiesMap.put("pattenMatchingGitRepo1", new MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties());
        multipleJGitEnvironmentProperties.setRepos(patternMatchingJGitEnvironmentPropertiesMap);
        MultipleJGitEnvironmentRepository multipleJGitEnvironmentRepository = this.multipleJGitEnvironmentRepositoryFactory.build(multipleJGitEnvironmentProperties);
        Assertions.assertThat((Object)multipleJGitEnvironmentRepository.getGitCredentialsProviderFactory()).isSameAs((Object)this.gitCredentialsProviderFactory);
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository pattenMatchingGitRepo = (MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository)multipleJGitEnvironmentRepository.getRepos().get("pattenMatchingGitRepo1");
        Assertions.assertThat((Object)pattenMatchingGitRepo.getGitCredentialsProviderFactory()).isSameAs((Object)this.gitCredentialsProviderFactory);
    }
}

