/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

public class MultipleJGitEnvironmentRepositoryIntegrationTests {
    private ConfigurableApplicationContext context;
    private File basedir = new File("target/config");

    @BeforeAll
    public static void initClass() {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
    }

    @BeforeEach
    public void init() throws Exception {
        if (this.basedir.exists()) {
            FileUtils.delete((File)this.basedir, (int)1);
        }
        ConfigServerTestUtils.deleteLocalRepo("config-copy");
    }

    @AfterEach
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void defaultRepo() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri}).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void mappingRepo() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String test1RepoUri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        LinkedHashMap<String, String> repoMapping = new LinkedHashMap<String, String>();
        repoMapping.put("spring.cloud.config.server.git.repos[test1].pattern", "*test1*");
        repoMapping.put("spring.cloud.config.server.git.repos[test1].uri", test1RepoUri);
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri}).properties(repoMapping).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("test1-svc", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void mappingRepoWithRefreshRate() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String test1RepoUri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        LinkedHashMap<String, String> repoMapping = new LinkedHashMap<String, String>();
        repoMapping.put("spring.cloud.config.server.git.repos[test1].pattern", "*test1*");
        repoMapping.put("spring.cloud.config.server.git.repos[test1].uri", test1RepoUri);
        repoMapping.put("spring.cloud.config.server.git.refresh-rate", "30");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri}).properties(repoMapping).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("test1-svc", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((int)30).isEqualTo(((MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository)((MultipleJGitEnvironmentRepository)repository).getRepos().get("test1")).getRefreshRate());
    }

    @Test
    public void mappingRepoWithProfile() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String test1RepoUri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        LinkedHashMap<String, String> repoMapping = new LinkedHashMap<String, String>();
        repoMapping.put("spring.cloud.config.server.git.repos[test1].pattern", "*/staging");
        repoMapping.put("spring.cloud.config.server.git.repos[test1].uri", test1RepoUri);
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri}).properties(repoMapping).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("test1-svc", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void mappingRepoWithProfileDefaultPatterns() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String test1RepoUri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        LinkedHashMap<String, String> repoMapping = new LinkedHashMap<String, String>();
        repoMapping.put("spring.cloud.config.server.git.repos[test1].pattern", "*/staging");
        repoMapping.put("spring.cloud.config.server.git.repos[test1].uri", test1RepoUri);
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri}).properties(repoMapping).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("test1-svc", "staging,cloud", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void mappingRepoWithProfiles() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String test1RepoUri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        LinkedHashMap<String, String> repoMapping = new LinkedHashMap<String, String>();
        repoMapping.put("spring.cloud.config.server.git.repos[test1].pattern[0]", "*/staging,*");
        repoMapping.put("spring.cloud.config.server.git.repos[test1].pattern[1]", "*/*,staging");
        repoMapping.put("spring.cloud.config.server.git.repos[test1].pattern[2]", "*/staging");
        repoMapping.put("spring.cloud.config.server.git.repos[test1].uri", test1RepoUri);
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri}).properties(repoMapping).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("test1-svc", "cloud,staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        environment = repository.findOne("test1-svc", "staging,cloud", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void mappingRepoWithJustUri() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String test1RepoUri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        LinkedHashMap<String, String> repoMapping = new LinkedHashMap<String, String>();
        repoMapping.put("spring.cloud.config.server.git.repos.test1-svc.uri", test1RepoUri);
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri}).properties(repoMapping).run(new String[0]);
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("test1-svc", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void nonWritableBasedir() {
        Assertions.assertThatThrownBy(() -> {
            String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
            this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.uri:" + defaultRepoUri, "spring.cloud.config.server.git.basedir:/tmp"}).run(new String[0]);
        }).hasMessageContaining("Cannot write parent");
    }

    @Test
    public void patternMatchingShortcutSyntax() throws IOException {
        String defaultRepoUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        String test1RepoUri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).properties(new String[]{"spring.cloud.config.server.git.repos.admin:" + test1RepoUri, "spring.cloud.config.server.git.uri:" + defaultRepoUri}).run(new String[0]);
        MultipleJGitEnvironmentProperties properties = (MultipleJGitEnvironmentProperties)this.context.getBean(MultipleJGitEnvironmentProperties.class);
        ((MapAssert)Assertions.assertThat((Map)properties.getRepos()).hasSize(1)).containsOnlyKeys((Object[])new String[]{"admin"});
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={PropertyPlaceholderAutoConfiguration.class, EnvironmentRepositoryConfiguration.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }
    }
}

