/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class MultipleJGitEnvironmentRepositoryTests {
    private StandardEnvironment environment = new StandardEnvironment();
    private MultipleJGitEnvironmentRepository repository;

    @BeforeAll
    public static void initClass() {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
    }

    @BeforeEach
    public void init() throws Exception {
        String defaultUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        this.repository = new MultipleJGitEnvironmentRepository((ConfigurableEnvironment)this.environment, new MultipleJGitEnvironmentProperties(), ObservationRegistry.NOOP);
        this.repository.setUri(defaultUri);
        this.repository.setRepos(this.createRepositories());
    }

    private Map<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository> createRepositories() throws Exception {
        String test1Uri = ConfigServerTestUtils.prepareLocalRepo("test1-config-repo");
        HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository> repos = new HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository>();
        repos.put("test1", this.createRepository("test1", "*test1*", test1Uri));
        return repos;
    }

    private MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository createRepository(String name, String pattern, String uri) {
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo = new MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository(ObservationRegistry.NOOP);
        repo.setEnvironment((ConfigurableEnvironment)this.environment);
        repo.setName(name);
        repo.setPattern(new String[]{pattern});
        repo.setUri(uri);
        repo.setBasedir(new File(this.repository.getBasedir().getParentFile(), name));
        return repo;
    }

    @Test
    public void defaultRepo() {
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void baseDirRepo() {
        this.repository.setUri(this.repository.getUri().replace("config-repo", "{application}"));
        this.repository.setBasedir(new File("target/testBase"));
        JGitEnvironmentRepository newRepo = this.repository.getRepository((JGitEnvironmentRepository)this.repository, "config-repo", "staging", "master");
        Assertions.assertThat((String)newRepo.getBasedir().getAbsolutePath()).contains(new CharSequence[]{"target/testBase"});
    }

    private void assertVersion(Environment environment) {
        String version = environment.getVersion();
        ((AbstractStringAssert)Assertions.assertThat((String)version).as("version was null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((version.length() >= 40 && version.length() <= 64 ? 1 : 0) != 0).as("version length was wrong", new Object[0])).isTrue();
    }

    @Test
    public void defaultRepoNested() throws IOException {
        String uri = ConfigServerTestUtils.prepareLocalRepo("another-config-repo");
        this.repository.setUri(uri);
        this.repository.setSearchPaths(new String[]{"sub"});
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/sub/application.yml");
        this.assertVersion(environment);
    }

    @Test
    public void defaultRepoBranch() {
        Environment environment = this.repository.findOne("bar", "staging", "raw");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void defaultRepoTag() {
        Environment environment = this.repository.findOne("bar", "staging", "foo");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void defaultRepoTwice() {
        Environment environment = this.repository.findOne("bar", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void defaultRepoBasedir() {
        this.repository.setBasedir(new File("target/testBase"));
        Assertions.assertThat((String)this.repository.getBasedir().toString()).contains(new CharSequence[]{"target/testBase"});
        Assertions.assertThat((String)((MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository)this.repository.getRepos().get("test1")).getBasedir().toString()).contains(new CharSequence[]{"/test1"});
    }

    @Test
    public void mappingRepo() {
        Environment environment = this.repository.findOne("test1-svc", "staging", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.getUri("*test1*") + "/test1-svc.properties");
        this.assertVersion(environment);
    }

    @Test
    public void defaultLabel() {
        this.repository.setDefaultLabel("raw");
        Environment environment = this.repository.findOne("bar", "staging", null);
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("raw");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.repository.getUri() + "/bar.properties");
        this.assertVersion(environment);
    }

    @Test
    public void mappingRepoWithDefaultLabel() {
        Environment environment = this.repository.findOne("test1-svc", "staging", null);
        Assertions.assertThat((String)environment.getLabel()).isEqualTo("main");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo(this.getUri("*test1*") + "/test1-svc.properties");
        this.assertVersion(environment);
    }

    @Test
    public void shouldSetTransportConfigCallback() throws Exception {
        TransportConfigCallback mockCallback1 = (TransportConfigCallback)Mockito.mock(TransportConfigCallback.class);
        TransportConfigCallback mockCallback2 = (TransportConfigCallback)Mockito.mock(TransportConfigCallback.class);
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo1 = this.createRepository("test1", "*test1*", "test1Uri");
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo2 = this.createRepository("test2", "*test2*", "test2Uri");
        repo2.setTransportConfigCallback(mockCallback2);
        HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository> repos = new HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository>();
        repos.put("test1", repo1);
        repos.put("test2", repo2);
        this.repository.setRepos(repos);
        this.repository.setTransportConfigCallback(mockCallback1);
        this.repository.afterPropertiesSet();
        Assertions.assertThat((Object)mockCallback1).isEqualTo((Object)repo1.getTransportConfigCallback());
        Assertions.assertThat((Object)mockCallback2).isEqualTo((Object)repo2.getTransportConfigCallback());
    }

    @Test
    public void setCorrectCredentials() throws Exception {
        String repo1Username = "repo1-username";
        String repo1Password = "repo1-password";
        String repo2Passphrase = "repo2-passphrase";
        String multiRepoUsername = "multi-repo-username";
        String multiRepoPassword = "multi-repo-password";
        String multiRepoPassphrase = "multi-repo-passphrase";
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo1 = this.createRepository("test1", "*test1*", "test1Uri");
        repo1.setUsername("repo1-username");
        repo1.setPassword("repo1-password");
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo2 = this.createRepository("test2", "*test2*", "test2Uri");
        repo2.setPassphrase("repo2-passphrase");
        HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository> repos = new HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository>();
        repos.put("test1", repo1);
        repos.put("test2", repo2);
        this.repository.setRepos(repos);
        this.repository.setUsername("multi-repo-username");
        this.repository.setPassword("multi-repo-password");
        this.repository.setPassphrase("multi-repo-passphrase");
        this.repository.afterPropertiesSet();
        ((AbstractStringAssert)Assertions.assertThat((String)"repo1-username").as("Repo1 has its own username which should not be overwritten", new Object[0])).isEqualTo(repo1.getUsername());
        ((AbstractStringAssert)Assertions.assertThat((String)"repo1-password").as("Repo1 has its own password which should not be overwritten", new Object[0])).isEqualTo(repo1.getPassword());
        ((AbstractStringAssert)Assertions.assertThat((String)"multi-repo-passphrase").as("Repo1 did not specify a passphrase so this should have been copied from the multi repo", new Object[0])).isEqualTo(repo1.getPassphrase());
        ((AbstractStringAssert)Assertions.assertThat((String)"multi-repo-username").as("Repo2 did not specify a username so this should have been copied from the multi repo", new Object[0])).isEqualTo(repo2.getUsername());
        ((AbstractStringAssert)Assertions.assertThat((String)"multi-repo-password").as("Repo2 did not specify a username so this should have been copied from the multi repo", new Object[0])).isEqualTo(repo2.getPassword());
        ((AbstractStringAssert)Assertions.assertThat((String)"repo2-passphrase").as("Repo2 has its own passphrase which should not have been overwritten", new Object[0])).isEqualTo(repo2.getPassphrase());
    }

    @Test
    public void setSkipSslValidation() throws Exception {
        boolean repo1SkipSslValidation = false;
        boolean repo2SkipSslValidation = true;
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo1 = this.createRepository("test1", "*test1*", "test1Uri");
        repo1.setSkipSslValidation(false);
        MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo2 = this.createRepository("test2", "*test2*", "test2Uri");
        repo2.setSkipSslValidation(true);
        HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository> repos = new HashMap<String, MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository>();
        repos.put("test1", repo1);
        repos.put("test2", repo2);
        this.repository.setRepos(repos);
        this.repository.setSkipSslValidation(false);
        this.repository.afterPropertiesSet();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)repo1.isSkipSslValidation()).as("If skip SSL validation is false at multi-repo level, then per-repo settings take priority", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)repo2.isSkipSslValidation()).as("If skip SSL validation is false at multi-repo level, then per-repo settings take priority", new Object[0])).isTrue();
        this.repository.setSkipSslValidation(true);
        this.repository.afterPropertiesSet();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)repo1.isSkipSslValidation()).as("If explicitly set to skip SSL validation at the multi-repo level, then apply same setting to sub-repos", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)repo2.isSkipSslValidation()).as("If explicitly set to skip SSL validation at the multi-repo level, then apply same setting to sub-repos", new Object[0])).isTrue();
    }

    @Test
    public void basedirCreatedIfNotExists() throws Exception {
        Path tempDir = Files.createTempDirectory("basedirCreatedTest", new FileAttribute[0]);
        File parent = new File(tempDir.toFile(), "parent");
        File basedir = new File(parent, "basedir");
        this.repository.setBasedir(basedir);
        Assertions.assertThat((File)basedir).doesNotExist();
        this.repository.afterPropertiesSet();
        Assertions.assertThat((File)basedir).exists();
    }

    @Test
    public void exceptionThrownIfBasedirDoesnotExistAndCannotBeCreated() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            File basedir = (File)Mockito.mock(File.class);
            File absoluteBasedir = (File)Mockito.mock(File.class);
            Mockito.when((Object)basedir.getAbsoluteFile()).thenReturn((Object)absoluteBasedir);
            Mockito.when((Object)absoluteBasedir.exists()).thenReturn((Object)false);
            Mockito.when((Object)absoluteBasedir.mkdir()).thenReturn((Object)false);
            this.repository.setBasedir(basedir);
            this.repository.afterPropertiesSet();
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Basedir does not exist and can not be created:");
    }

    @Test
    public void exceptionNotThrownIfRelativeBasedirIsPassedByProperties() throws Exception {
        MultipleJGitEnvironmentProperties props = new MultipleJGitEnvironmentProperties();
        props.setBasedir(new File("relative"));
        this.repository = new MultipleJGitEnvironmentRepository((ConfigurableEnvironment)this.environment, props, ObservationRegistry.NOOP);
        String defaultUri = ConfigServerTestUtils.prepareLocalRepo("config-repo");
        this.repository.setUri(defaultUri);
        this.repository.setRepos(this.createRepositories());
        this.repository.afterPropertiesSet();
    }

    private String getUri(String pattern) {
        String uri = null;
        Map repoMappings = this.repository.getRepos();
        for (MultipleJGitEnvironmentRepository.PatternMatchingJGitEnvironmentRepository repo : repoMappings.values()) {
            String[] mappingPattern = repo.getPattern();
            if (mappingPattern == null || mappingPattern.length == 0) continue;
            uri = repo.getUri();
            break;
        }
        return uri;
    }
}

