/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class NativeEnvironmentRepositoryFactoryTest {
    @Test
    public void testDefaultLabel() {
        ConfigServerProperties props = new ConfigServerProperties();
        props.setDefaultLabel("mylabel");
        NativeEnvironmentRepositoryFactory factory = new NativeEnvironmentRepositoryFactory((ConfigurableEnvironment)new StandardEnvironment(), props, ObservationRegistry.NOOP);
        NativeEnvironmentProperties environmentProperties = new NativeEnvironmentProperties();
        NativeEnvironmentRepository repo = factory.build(environmentProperties);
        Assertions.assertThat((String)repo.getDefaultLabel()).isEqualTo("mylabel");
        factory = new NativeEnvironmentRepositoryFactory((ConfigurableEnvironment)new StandardEnvironment(), props, ObservationRegistry.NOOP);
        environmentProperties = new NativeEnvironmentProperties();
        environmentProperties.setDefaultLabel("mynewlabel");
        repo = factory.build(environmentProperties);
        Assertions.assertThat((String)repo.getDefaultLabel()).isEqualTo("mylabel");
        factory = new NativeEnvironmentRepositoryFactory((ConfigurableEnvironment)new StandardEnvironment(), new ConfigServerProperties(), ObservationRegistry.NOOP);
        environmentProperties = new NativeEnvironmentProperties();
        environmentProperties.setDefaultLabel("mynewlabel");
        repo = factory.build(environmentProperties);
        Assertions.assertThat((String)repo.getDefaultLabel()).isEqualTo("mynewlabel");
    }
}

