/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.FailedToConstructEnvironmentException;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.context.ConfigurableApplicationContext;

public class NativeEnvironmentRepositoryTests {
    private NativeEnvironmentRepository repository;

    @BeforeEach
    public void init() {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{NativeEnvironmentRepositoryTests.class}).properties(new String[]{"logging.level.org.springframework.boot.context.config=TRACE"}).web(WebApplicationType.NONE).run(new String[0]);
        this.repository = new NativeEnvironmentRepository(context.getEnvironment(), new NativeEnvironmentProperties(), ObservationRegistry.NOOP);
        this.repository.setVersion("myversion");
        this.repository.setDefaultLabel(null);
        context.close();
    }

    @Test
    public void emptySearchLocations() {
        this.repository.setSearchLocations((String[])null);
        Environment environment = this.repository.findOne("foo", "development", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void vanilla() {
        Environment environment = this.repository.findOne("foo", "development", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)environment.getVersion()).as("version was wrong", new Object[0])).isEqualTo("myversion");
    }

    @Test
    public void ignoresExistingProfile() {
        System.setProperty("spring.profiles.active", "cloud");
        Environment environment = this.repository.findOne("foo", "main", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)environment.getVersion()).as("version was wrong", new Object[0])).isEqualTo("myversion");
    }

    @Test
    public void prefixed() {
        this.repository.setSearchLocations(new String[]{"classpath:/test"});
        Environment environment = this.repository.findOne("foo", "development", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)environment.getVersion()).as("version was wrong", new Object[0])).isEqualTo("myversion");
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isNotEqualTo((Object)((PropertySource)environment.getPropertySources().get(1)).getName());
    }

    @Test
    public void prefixedYaml() {
        this.repository.setSearchLocations(new String[]{"classpath:/test"});
        Environment environment = this.repository.findOne("bar", "development", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)environment.getVersion()).as("version was wrong", new Object[0])).isEqualTo("myversion");
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isNotEqualTo((Object)((PropertySource)environment.getPropertySources().get(1)).getName());
    }

    @Test
    public void prefixedMultiDocProperties() {
        this.repository.setSearchLocations(new String[]{"classpath:/test"});
        Environment environment = this.repository.findOne("baz", "development", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)environment.getVersion()).as("version was wrong", new Object[0])).isEqualTo("myversion");
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isNotEqualTo((Object)((PropertySource)environment.getPropertySources().get(1)).getName());
    }

    @Test
    public void prefixedWithFile() {
        this.repository.setSearchLocations(new String[]{"file:./src/test/resources/test"});
        Environment environment = this.repository.findOne("foo", "development", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)environment.getVersion()).as("version was wrong", new Object[0])).isEqualTo("myversion");
    }

    @Test
    public void cleanBoot24() {
        Environment environment = new Environment("application", new String[0]);
        environment.add(new PropertySource("Config resource 'file [/tmp/config-repo-7780026223759117699/application-dev.yml]' via location 'file:/tmp/config-repo-7780026223759117699/'", Collections.singletonMap("foo", "bar")));
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((boolean)((PropertySource)environment.getPropertySources().get(0)).getName().contains("application-dev.yml"));
    }

    @Test
    public void cleanBoot240Classpath() {
        Environment environment = new Environment("application", new String[0]);
        environment.add(new PropertySource("Config resource 'classpath:/configs/application-myprofile.yml' via location 'classpath:/configs/' (document #0)", Collections.singletonMap("foo", "bar")));
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((boolean)((PropertySource)environment.getPropertySources().get(0)).getName().contains("application-myprofile.yml"));
    }

    @Test
    public void cleanBoot241Classpath() {
        Environment environment = new Environment("application", new String[0]);
        environment.add(new PropertySource("Config resource 'class path resource [configs/application.yml]' via location 'classpath:/configs/' (document #0)", Collections.singletonMap("foo", "bar")));
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((boolean)((PropertySource)environment.getPropertySources().get(0)).getName().contains("application-myprofile.yml"));
    }

    @Test
    @Disabled
    public void labelled() {
        this.repository.setSearchLocations(new String[]{"classpath:/test"});
        Environment environment = this.repository.findOne("foo", "development", "dev", false);
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(3);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(1)).getSource().get("foo")).isEqualTo((Object)"dev_bar");
        ((AbstractStringAssert)Assertions.assertThat((String)environment.getVersion()).as("version was wrong", new Object[0])).isEqualTo("myversion");
    }

    @Test
    public void placeholdersLabel() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{label}/"});
        Environment environment = this.repository.findOne("foo", "development", "dev");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"dev_bar");
    }

    @Test
    public void placeholdersProfile() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{profile}/"});
        Environment environment = this.repository.findOne("foo", "dev", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"dev_bar");
    }

    @Test
    public void placeholdersProfiles() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{profile}/"});
        Environment environment = this.repository.findOne("foo", "dev,mysql", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"mysql");
    }

    @Test
    public void placeholdersApplicationAndProfile() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{profile}/{application}/"});
        Environment environment = this.repository.findOne("app", "dev", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"app");
    }

    @Test
    public void placeholdersApplicationWithPrefixAndProfile() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{profile}/{application}/"});
        Environment environment = this.repository.findOne("applicationxyz", "dev", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"default-app");
    }

    @Test
    public void locationPlaceholdersApplication() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{application}"});
        SearchPathLocator.Locations locations = this.repository.getLocations("foo", "dev", "master");
        Assertions.assertThat((int)locations.getLocations().length).isEqualTo(1);
        Assertions.assertThat((String)locations.getLocations()[0]).isEqualTo("classpath:/test/foo/");
    }

    @Test
    public void locationPlaceholdersMultipleApplication() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{application}"});
        SearchPathLocator.Locations locations = this.repository.getLocations("foo,bar", "dev", "master");
        Assertions.assertThat((int)locations.getLocations().length).isEqualTo(2);
        Assertions.assertThat((String)locations.getLocations()[0]).isEqualTo("classpath:/test/foo/");
        Assertions.assertThat((String)locations.getLocations()[1]).isEqualTo("classpath:/test/bar/");
    }

    @Test
    public void locationProfilesApplication() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{profile}"});
        SearchPathLocator.Locations locations = this.repository.getLocations("foo", "dev,one,two", "master");
        Assertions.assertThat((int)locations.getLocations().length).isEqualTo(3);
        Assertions.assertThat((String)locations.getLocations()[0]).isEqualTo("classpath:/test/dev/");
    }

    @Test
    public void placeholdersNoTrailingSlash() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{label}"});
        Environment environment = this.repository.findOne("foo", "development", "dev");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"dev_bar");
    }

    @Test
    public void locationAddLabelLocations() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/dev/"});
        Environment environment = this.repository.findOne("foo", "development", "ignore");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isNotEqualTo((Object)"dev_bar");
    }

    @Test
    public void tryToStartReactive() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/reactive/"});
        Environment environment = this.repository.findOne("foo", "master", "default");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"reactive");
    }

    @Test
    public void locationDontAddLabelLocations() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/dev/"});
        this.repository.setAddLabelLocations(false);
        Environment environment = this.repository.findOne("foo", "development", "ignore");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"dev_bar");
    }

    @Test
    public void locationNoDuplicates() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/{profile}", "classpath:/test/dev"});
        SearchPathLocator.Locations locations = this.repository.getLocations("foo", "dev", null);
        Assertions.assertThat((int)locations.getLocations().length).isEqualTo(1);
    }

    @Test
    public void testDefaultLabel() {
        this.repository.setDefaultLabel("test");
        Environment environment = this.repository.findOne("foo", "default", null);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"test_bar");
    }

    @Test
    public void testImportVanilla() {
        this.testImport();
    }

    @Test
    public void testImportEmptySearchLocations() {
        this.repository.setSearchLocations(new String[0]);
        this.testImport();
    }

    @Test
    public void testImportPrefixedWithClasspath() {
        this.repository.setSearchLocations(new String[]{"classpath:/test"});
        this.testImport();
    }

    @Test
    public void testImportPrefixedWithFile() {
        this.repository.setSearchLocations(new String[]{"file:./src/test/resources/test"});
        this.testImport();
    }

    @Test
    public void testImportWithoutPrefix() {
        this.repository.setSearchLocations(new String[]{"src/test/resources/test"});
        this.testImport();
    }

    private void testImport() {
        Environment environment = this.repository.findOne("import", "default", "master");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(3);
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"imported");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(2)).getSource().get("foo")).isEqualTo((Object)"importing");
    }

    @Test
    public void duplicateYamlKeys() {
        this.repository.setSearchLocations(new String[]{"classpath:/test/bad-syntax"});
        NativeEnvironmentRepository repo = this.repository;
        Assertions.assertThatExceptionOfType(FailedToConstructEnvironmentException.class).isThrownBy(() -> repo.findOne("foo", "master", "default")).withMessage("Could not construct context for config=foo profile=master label=default includeOrigin=false; nested exception is while constructing a mapping\n in 'reader', line 1, column 1:\n    key: value\n    ^\nfound duplicate key key\n in 'reader', line 2, column 1:\n    key: value\n    ^\n");
    }

    @Test
    public void resourcePatternWorks() {
        String name = "Config resource 'abc' via location '123'";
        Matcher matcher = NativeEnvironmentRepository.RESOURCE_PATTERN.matcher(name);
        Assertions.assertThat((boolean)matcher.find()).isTrue();
        Assertions.assertThat((String)matcher.group(1)).isEqualTo("abc");
    }
}

