/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.tck.TestObservationRegistry;
import io.micrometer.observation.tck.TestObservationRegistryAssert;
import java.util.Arrays;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryWrapper;

class ObservationEnvironmentRepositoryWrapperTests {
    ObservationEnvironmentRepositoryWrapperTests() {
    }

    @Test
    void shouldCollectMetrics() {
        TestObservationRegistry registry = TestObservationRegistry.create();
        MyEnvRepo delegate = new MyEnvRepo();
        EnvironmentRepository wrapper = ObservationEnvironmentRepositoryWrapper.wrap((ObservationRegistry)registry, (EnvironmentRepository)delegate);
        wrapper.findOne("foo", "bar", "baz");
        ((TestObservationRegistryAssert.TestObservationRegistryAssertReturningObservationContextAssert)TestObservationRegistryAssert.assertThat((TestObservationRegistry)registry).hasSingleObservationThat().hasNameEqualTo("spring.cloud.config.environment.find")).hasBeenStarted().hasBeenStopped().hasLowCardinalityKeyValue("spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryWrapperTests$MyEnvRepo");
    }

    @Test
    void shouldCreateRootObservationForCompositeAndChildObservationsForDelegates() {
        TestObservationRegistry registry = TestObservationRegistry.create();
        MyEnvRepo delegate = new MyEnvRepo();
        CompositeEnvironmentRepository composite = new CompositeEnvironmentRepository(Arrays.asList(delegate), (ObservationRegistry)registry, true);
        EnvironmentRepository wrapper = ObservationEnvironmentRepositoryWrapper.wrap((ObservationRegistry)registry, (EnvironmentRepository)composite);
        wrapper.findOne("foo", "bar", "baz");
        TestObservationRegistryAssert.assertThat((TestObservationRegistry)registry).hasHandledContextsThatSatisfy(contexts -> {
            contexts.stream().filter(context -> context.getName().equals("spring.cloud.config.environment.find") && this.contextExists((Observation.Context)context, "spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository")).findFirst().orElseThrow(() -> new AssertionError((Object)"There's no observation for the Composite EnvironmentRepository"));
            contexts.stream().filter(context -> context.getName().equals("spring.cloud.config.environment.find") && this.contextExists((Observation.Context)context, "spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryWrapperTests$MyEnvRepo")).findFirst().orElseThrow(() -> new AssertionError((Object)"There's no observation for the wrapped EnvironmentRepository"));
        });
    }

    private boolean contextExists(Observation.Context context, String tagName, String tagValue) {
        return context.getLowCardinalityKeyValues().stream().anyMatch(keyValue -> keyValue.getKey().equals(tagName) && keyValue.getValue().equals(tagValue));
    }

    static class MyEnvRepo
    implements EnvironmentRepository {
        MyEnvRepo() {
        }

        public Environment findOne(String application, String profile, String label) {
            return new Environment("foo", new String[]{"bar"});
        }
    }
}

