/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.PassthruEnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.mock.env.MockEnvironment;

public class PassthruEnvironmentRepositoryTests {
    @Test
    public void originTrackedPropertySourceWithoutOriginWorks() {
        MockEnvironment mockEnvironment = new MockEnvironment();
        mockEnvironment.setProperty("normalKey", "normalValue");
        mockEnvironment.getPropertySources().addFirst((PropertySource)new OriginTrackedMapPropertySource("myorigintrackedsource", Collections.singletonMap("keyNoOrigin", "valueNoOrigin")));
        PassthruEnvironmentRepository repository = new PassthruEnvironmentRepository((ConfigurableEnvironment)mockEnvironment);
        Environment environment = repository.findOne("testapp", "default", "master", true);
        Assertions.assertThat((Object)environment).isNotNull();
        List propertySources = environment.getPropertySources();
        Assertions.assertThat((List)propertySources).hasSize(2);
        for (org.springframework.cloud.config.environment.PropertySource propertySource : propertySources) {
            Map source = propertySource.getSource();
            if (propertySource.getName().equals("myorigintrackedsource")) {
                Assertions.assertThat((Map)source).containsEntry((Object)"keyNoOrigin", (Object)"valueNoOrigin");
                continue;
            }
            if (!propertySource.getName().equals("mockProperties")) continue;
            Assertions.assertThat((Map)source).containsEntry((Object)"normalKey", (Object)"normalValue");
        }
    }
}

