/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.RedisEnvironmentProperties;
import org.springframework.cloud.config.server.environment.RedisEnvironmentRepository;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@SpringBootTest
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@ActiveProfiles(value={"redis"})
@Testcontainers
@Tag(value="DockerRequired")
public class RedisEnvironmentRepositoryIntegrationTests {
    @Container
    public static GenericContainer redisContainer = new GenericContainer("redis:5.0.9-alpine").withExposedPorts(new Integer[]{6379});
    @Autowired
    private StringRedisTemplate redis;

    @DynamicPropertySource
    static void containerProperties(DynamicPropertyRegistry registry) {
        registry.add("spring.data.redis.host", () -> ((GenericContainer)redisContainer).getHost());
        registry.add("spring.data.redis.port", () -> ((GenericContainer)redisContainer).getFirstMappedPort());
    }

    @Test
    public void test() {
        BoundHashOperations bound = this.redis.boundHashOps((Object)"foo-bar");
        bound.put((Object)"name", (Object)"foo");
        bound.put((Object)"tag", (Object)"myapp");
        Environment env = new RedisEnvironmentRepository(this.redis, new RedisEnvironmentProperties()).findOne("foo", "bar", "");
        Assertions.assertThat((String)env.getName()).isEqualTo("foo");
        Assertions.assertThat((List)env.getPropertySources()).isNotEmpty();
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("tag")).isEqualTo((Object)"myapp");
    }
}

