/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StreamUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNKitEnvironmentRepositoryIntegrationTests {
    private ConfigurableApplicationContext context;
    private File workingDir;

    @BeforeEach
    public void init() {
        this.workingDir = new File("target/repos/svn-config-repo-update");
        if (this.workingDir.exists()) {
            FileSystemUtils.deleteRecursively((File)this.workingDir);
        }
    }

    @AfterEach
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void vanilla() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/config");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).profiles(new String[]{"subversion"}).run(new String[]{"--spring.cloud.config.server.svn.uri=" + uri});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "trunk");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
    }

    @Test
    public void update() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/config");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).profiles(new String[]{"subversion"}).run(new String[]{"--spring.cloud.config.server.svn.uri=" + uri});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "trunk");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"bar");
        this.updateRepoForUpdate(uri);
        environment = repository.findOne("bar", "staging", "trunk");
        Assertions.assertThat(((PropertySource)environment.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"foo");
    }

    private void updateRepoForUpdate(String uri) throws SVNException, FileNotFoundException, IOException {
        SvnOperationFactory svnFactory = new SvnOperationFactory();
        SvnCheckout checkout = svnFactory.createCheckout();
        checkout.setSource(SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)uri)));
        checkout.setSingleTarget(SvnTarget.fromFile((File)this.workingDir));
        checkout.run();
        File barProps = new File(this.workingDir, "trunk/bar.properties");
        StreamUtils.copy((String)"foo: foo", (Charset)Charset.defaultCharset(), (OutputStream)new FileOutputStream(barProps));
        SvnCommit svnCommit = svnFactory.createCommit();
        svnCommit.setCommitMessage("update bar.properties");
        svnCommit.setSingleTarget(SvnTarget.fromFile((File)barProps));
        svnCommit.run();
    }

    @Test
    public void defaultLabel() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/config");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).profiles(new String[]{"subversion"}).run(new String[]{"--spring.cloud.config.server.svn.uri=" + uri});
        SvnKitEnvironmentRepository repository = (SvnKitEnvironmentRepository)this.context.getBean(SvnKitEnvironmentRepository.class);
        Assertions.assertThat((String)repository.getDefaultLabel()).isEqualTo("trunk");
    }

    @Test
    public void invalidLabel() {
        Assertions.assertThatThrownBy(() -> {
            String uri = ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/config");
            this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).profiles(new String[]{"subversion"}).run(new String[]{"--spring.cloud.config.server.svn.uri=" + uri});
            EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
            Environment environment = repository.findOne("bar", "staging", "unknownlabel");
            Assertions.assertThat((List)environment.getPropertySources()).isEmpty();
        }).isInstanceOf(NoSuchLabelException.class);
    }

    @Test
    public void branchLabel() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/config");
        this.context = new SpringApplicationBuilder(new Class[]{TestConfiguration.class}).web(WebApplicationType.NONE).profiles(new String[]{"subversion"}).run(new String[]{"--spring.cloud.config.server.svn.uri=" + uri});
        EnvironmentRepository repository = (EnvironmentRepository)this.context.getBean(EnvironmentRepository.class);
        Environment environment = repository.findOne("bar", "staging", "demobranch");
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).contains(new CharSequence[]{"bar.properties"});
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={ConfigServerProperties.class})
    @Import(value={PropertyPlaceholderAutoConfiguration.class, EnvironmentRepositoryConfiguration.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }
    }
}

