/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.util.FileUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.EnableConfigServer;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class SVNKitEnvironmentRepositoryTests {
    private static final String REPOSITORY_NAME = "svn-config-repo";
    private StandardEnvironment environment = new StandardEnvironment();
    private SvnKitEnvironmentRepository repository = new SvnKitEnvironmentRepository((ConfigurableEnvironment)this.environment, new SvnKitEnvironmentProperties(), ObservationRegistry.NOOP);
    private File basedir = new File("target/config");

    @BeforeEach
    public void init() throws Exception {
        String uri = ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/repos/svn-config-repo");
        this.repository.setUri(uri);
        if (this.basedir.exists()) {
            FileUtils.delete((File)this.basedir, (int)3);
        }
    }

    @Test
    public void vanilla() {
        Environment environment = this.findOne();
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).contains(new CharSequence[]{"bar.properties"});
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).contains(new CharSequence[]{"application.yml"});
    }

    @Test
    public void basedir() {
        this.repository.setBasedir(this.basedir);
        Environment environment = this.findOne();
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).contains(new CharSequence[]{"bar.properties"});
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).contains(new CharSequence[]{"application.yml"});
    }

    @Test
    public void basedirWithSpace() throws Exception {
        File basedirWithSpace = new File("target/config with space");
        if (basedirWithSpace.exists()) {
            FileUtils.delete((File)basedirWithSpace, (int)3);
        }
        this.repository.setBasedir(basedirWithSpace);
        Environment environment = this.findOne();
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).contains(new CharSequence[]{"bar.properties"});
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).contains(new CharSequence[]{"application.yml"});
    }

    @Test
    public void branch() {
        Environment environment = this.repository.findOne("bar", "staging", "branches/demobranch");
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).contains(new CharSequence[]{"bar.properties"});
    }

    @Test
    public void branch_no_folder() {
        Environment environment = this.repository.findOne("bar", "staging", "demobranch", false);
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).contains(new CharSequence[]{"bar.properties"});
    }

    @Test
    public void vanilla_with_update() {
        this.findOne();
        Environment environment = this.findOne();
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).contains(new CharSequence[]{"bar.properties"});
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(1)).getName()).contains(new CharSequence[]{"application.yml"});
    }

    @Test
    public void invalidLabel() {
        Assertions.assertThatThrownBy(() -> {
            Environment environment = this.repository.findOne("bar", "staging", "unknownlabel");
            Assertions.assertThat((List)environment.getPropertySources()).isEmpty();
        }).isInstanceOf(NoSuchLabelException.class);
    }

    @Test
    public void vanilla_with_update_after_repo_delete() throws IOException {
        this.vanilla_with_update();
        ConfigServerTestUtils.deleteLocalRepo(REPOSITORY_NAME);
        Assertions.assertThat((File)new File(this.basedir, REPOSITORY_NAME)).doesNotExist();
        this.vanilla();
    }

    private Environment findOne() {
        return this.repository.findOne("bar", "staging", "trunk");
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    @EnableConfigServer
    protected static class TestApplication {
        protected TestApplication() {
        }

        public static void main(String[] args) throws Exception {
            File basedir = new File("target/config");
            String uri = ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/repos/svn-config-repo");
            if (basedir.exists()) {
                FileUtils.delete((File)basedir, (int)3);
            }
            new SpringApplicationBuilder(new Class[]{TestApplication.class}).profiles(new String[]{"subversion"}).properties(new String[]{"server.port=8888", "spring.cloud.config.server.svn.uri:" + uri}).run(args);
        }
    }
}

