/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.HttpClientVaultRestTemplateFactory;
import org.springframework.cloud.config.server.environment.HttpRequestConfigTokenProvider;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepository;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepositoryFactory;

@SpringBootTest(classes={TestApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"server.ssl.key-store=classpath:ssl-test.jks", "server.ssl.key-store-password=password", "server.ssl.key-password=password", "server.key-alias=ssl-test"})
public class VaultEnvironmentRepositoryIntegrationTests {
    @LocalServerPort
    private String localServerPort;

    @Test
    public void withSslValidation() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            ObjectProvider<HttpServletRequest> request = this.withRequest();
            VaultEnvironmentRepositoryFactory vaultEnvironmentRepositoryFactory = new VaultEnvironmentRepositoryFactory(request, (EnvironmentWatch)new EnvironmentWatch.Default(), Optional.of(new HttpClientVaultRestTemplateFactory()), this.withTokenProvider(request));
            VaultEnvironmentRepository vaultEnvironmentRepository = vaultEnvironmentRepositoryFactory.build(this.withEnvironmentProperties(false));
            vaultEnvironmentRepository.findOne("application", "profile", "label");
        }).hasCauseInstanceOf(SSLHandshakeException.class);
    }

    @Test
    public void skipSslValidation() throws Exception {
        ObjectProvider<HttpServletRequest> request = this.withRequest();
        VaultEnvironmentRepositoryFactory vaultEnvironmentRepositoryFactory = new VaultEnvironmentRepositoryFactory(request, (EnvironmentWatch)new EnvironmentWatch.Default(), Optional.of(new HttpClientVaultRestTemplateFactory()), this.withTokenProvider(request));
        VaultEnvironmentRepository vaultEnvironmentRepository = vaultEnvironmentRepositoryFactory.build(this.withEnvironmentProperties(true));
        Environment actual = vaultEnvironmentRepository.findOne("application", "profile", "label");
        Assertions.assertThat((Object)actual).isNotNull();
    }

    private VaultEnvironmentProperties withEnvironmentProperties(boolean skipSslValidation) {
        VaultEnvironmentProperties environmentProperties = new VaultEnvironmentProperties();
        environmentProperties.setPort(Integer.decode(this.localServerPort));
        environmentProperties.setScheme("https");
        environmentProperties.setSkipSslValidation(skipSslValidation);
        return environmentProperties;
    }

    private ObjectProvider<HttpServletRequest> withRequest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getHeader("X-Config-Token")).thenReturn((Object)"configToken");
        ObjectProvider requestProvider = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        Mockito.when((Object)((HttpServletRequest)requestProvider.getIfAvailable())).thenReturn((Object)request);
        return requestProvider;
    }

    private ConfigTokenProvider withTokenProvider(ObjectProvider<HttpServletRequest> request) {
        return new HttpRequestConfigTokenProvider(request);
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    public static class TestApplication {
        public static void main(String[] args) {
            SpringApplication.run(TestApplication.class, (String[])args);
        }
    }
}

